/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.fordiac.ide.gef.validation.CancelableDiagnostician;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class VariableDiagnostician
extends CancelableDiagnostician {
    public VariableDiagnostician(IProgressMonitor progressMonitor) {
        super(progressMonitor);
    }

    @Override
    protected boolean doValidate(EValidator eValidator, EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Attribute attribute;
        VarDeclaration varDeclaration;
        boolean result = super.doValidate(eValidator, eClass, eObject, diagnostics, context);
        if (eObject instanceof VarDeclaration && (varDeclaration = (VarDeclaration)eObject).getType() instanceof AnyType) {
            result &= VariableDiagnostician.validate(varDeclaration, VariableOperations::validateType, diagnostics, (EObject)varDeclaration.getArraySize());
            result &= VariableDiagnostician.validate(varDeclaration, VariableOperations::validateValue, diagnostics, (EObject)varDeclaration.getValue());
        } else if (eObject instanceof Attribute && (attribute = (Attribute)eObject).getType() instanceof AnyType && !InternalAttributeDeclarations.isInternalAttribute((AttributeDeclaration)attribute.getAttributeDeclaration())) {
            result &= VariableDiagnostician.validate(attribute, VariableOperations::validateValue, diagnostics, (EObject)attribute, (EStructuralFeature)LibraryElementPackage.Literals.ATTRIBUTE__VALUE);
        }
        return result;
    }

    protected static <T> boolean validate(T element, VariableValidator<? super T> validator, DiagnosticChain diagnostics, EObject context) {
        return VariableDiagnostician.validate(element, validator, diagnostics, context, null);
    }

    protected static <T> boolean validate(T element, VariableValidator<? super T> validator, DiagnosticChain diagnostics, EObject context, EStructuralFeature feature) {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        ArrayList<String> infos = new ArrayList<String>();
        boolean result = validator.validate(element, errors, warnings, infos);
        if (diagnostics != null) {
            VariableDiagnostician.createDiagnostics(4, errors, context, feature, diagnostics);
            VariableDiagnostician.createDiagnostics(2, warnings, context, feature, diagnostics);
            VariableDiagnostician.createDiagnostics(1, infos, context, feature, diagnostics);
        }
        return result;
    }

    protected static void createDiagnostics(int severity, List<String> messages, EObject object, EStructuralFeature feature, DiagnosticChain diagnostics) {
        messages.stream().map(message -> VariableDiagnostician.createDiagnostic(severity, message, object, feature)).forEachOrdered(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
    }

    protected static Diagnostic createDiagnostic(int severity, String message, EObject object, EStructuralFeature feature) {
        return new BasicDiagnostic(severity, "org.eclipse.fordiac.ide.model.libraryElement", 0, message, FordiacMarkerHelper.getDiagnosticData((EObject)object, (EStructuralFeature)feature, (String[])new String[0]));
    }

    @FunctionalInterface
    public static interface VariableValidator<T> {
        public boolean validate(T var1, List<String> var2, List<String> var3, List<String> var4);
    }
}

