# Platform specific configuration
IF(CMAKE_SYSTEM_NAME MATCHES "^.*BSD$|DragonFly")
    ADD_DEFINITIONS(-DFREEBSD -D_BSD_SOURCE)
    CONFIGURE_FILE(freebsd/rspamd.sh.in freebsd/rspamd @ONLY)
    MESSAGE(STATUS "Configuring for BSD system")
    # Find util library
    ProcessPackage(LIBUTIL LIBRARY util INCLUDE libutil.h
            ROOT ${LIBUTIL_ROOT_DIR} OPTIONAL)
    IF(WITH_LIBUTIL)
        SET(HAVE_LIBUTIL_H 1)
        LIST(APPEND CMAKE_REQUIRED_LIBRARIES util)
        CHECK_FUNCTION_EXISTS(pidfile_open HAVE_PIDFILE)
        CHECK_FUNCTION_EXISTS(pidfile_fileno HAVE_PIDFILE_FILENO)
    ENDIF()
    IF(CMAKE_SYSTEM_NAME MATCHES "^NetBSD$")
        LIST(APPEND CMAKE_REQUIRED_LIBRARIES rt)
    ENDIF()
    SET(POE_LOOP "Loop::Kqueue")
    SET(TAR "gtar")
ENDIF()

IF(CMAKE_SYSTEM_NAME STREQUAL "Darwin")
    ADD_DEFINITIONS(-D_BSD_SOURCE -DDARWIN)
    SET(CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS "${CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS} -undefined dynamic_lookup")
    IF(ENABLE_LUAJIT MATCHES "ON")
        SET(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -pagezero_size 10000 -image_base 100000000")
    ENDIF(ENABLE_LUAJIT MATCHES "ON")
    MESSAGE(STATUS "Configuring for Darwin")
    SET(TAR "gnutar")
    SET(CMAKE_FIND_FRAMEWORK "NEVER")
ENDIF(CMAKE_SYSTEM_NAME STREQUAL "Darwin")

IF(CMAKE_SYSTEM_NAME STREQUAL "Linux")
    ADD_DEFINITIONS(-D_GNU_SOURCE -DLINUX)
    # Workaround with architecture specific includes
    #IF(IS_DIRECTORY "/usr/include/${CMAKE_SYSTEM_PROCESSOR}-linux-gnu/")
    #	INCLUDE_DIRECTORIES("/usr/include/${CMAKE_SYSTEM_PROCESSOR}-linux-gnu/")
    #	LIST(APPEND CMAKE_REQUIRED_INCLUDES "/usr/include/${CMAKE_SYSTEM_PROCESSOR}-linux-gnu/")
    #ENDIF(IS_DIRECTORY "/usr/include/${CMAKE_SYSTEM_PROCESSOR}-linux-gnu/")

    LIST(APPEND CMAKE_REQUIRED_LIBRARIES rt)
    LIST(APPEND CMAKE_REQUIRED_LIBRARIES dl)
    LIST(APPEND CMAKE_REQUIRED_LIBRARIES resolv)
    MESSAGE(STATUS "Configuring for Linux")
    IF(EXISTS "/etc/debian_version")
        SET(LINUX_START_SCRIPT "rspamd_debian.in")
    ELSE(EXISTS "/etc/debian_version")
        SET(LINUX_START_SCRIPT "rspamd_rh.in")
    ENDIF(EXISTS "/etc/debian_version")
    SET(POE_LOOP "XS::Loop::EPoll")
ENDIF(CMAKE_SYSTEM_NAME STREQUAL "Linux")

IF(CMAKE_SYSTEM_NAME STREQUAL "SunOS")

    IF("${CMAKE_C_COMPILER_ID}" MATCHES SunPro)
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -Xa -xregs=no%frameptr -xstrconst -xc99")
        IF(ENABLE_OPTIMIZATION MATCHES "ON")
            SET(CMAKE_C_OPT_FLAGS "-fast -xdepend")
        ELSE(ENABLE_OPTIMIZATION MATCHES "ON")
            SET(CMAKE_C_OPT_FLAGS "-xO0")
        ENDIF(ENABLE_OPTIMIZATION MATCHES "ON")
    ENDIF("${CMAKE_C_COMPILER_ID}" MATCHES SunPro)

    ADD_DEFINITIONS(-D__EXTENSIONS__ -DSOLARIS -D_POSIX_SOURCE -D_POSIX_C_SOURCE=200112)
    LIST(APPEND CMAKE_REQUIRED_LIBRARIES rt)
    LIST(APPEND CMAKE_REQUIRED_LIBRARIES dl)
    LIST(APPEND CMAKE_REQUIRED_LIBRARIES resolv)
    LIST(APPEND CMAKE_REQUIRED_LIBRARIES nsl)
    LIST(APPEND CMAKE_REQUIRED_LIBRARIES socket)
    LIST(APPEND CMAKE_REQUIRED_LIBRARIES umem)
    # Ugly hack, but FindOpenSSL on Solaris does not link with libcrypto
    SET(CMAKE_VERBOSE_MAKEFILE ON)
    SET(CMAKE_INSTALL_RPATH_USE_LINK_PATH FALSE)
    SET(CMAKE_INSTALL_RPATH "${CMAKE_INSTALL_PREFIX}/lib:${RSPAMD_LIBDIR}")
ENDIF(CMAKE_SYSTEM_NAME STREQUAL "SunOS")