'use strict';
const common = require('../common');
if (!common.hasCrypto) {
  common.skip('missing crypto');
  return;
}
const assert = require('assert');

const tls = require('tls');
const fs = require('fs');
const net = require('net');

const key = fs.readFileSync(common.fixturesDir + '/keys/agent2-key.pem');
const cert = fs.readFileSync(common.fixturesDir + '/keys/agent2-cert.pem');

let tlsSocket;
// tls server
const tlsServer = tls.createServer({ cert, key }, (socket) => {
  tlsSocket = socket;
  socket.on('error', common.mustCall((error) => {
    assert.strictEqual(error.code, 'EINVAL');
    tlsServer.close();
    netServer.close();
  }));
});

let netSocket;
// plain tcp server
const netServer = net.createServer((socket) => {
  // if client wants to use tls
  tlsServer.emit('connection', socket);

  netSocket = socket;
}).listen(0, common.mustCall(function() {
  // connect client
  tls.connect({
    host: 'localhost',
    port: this.address().port,
    rejectUnauthorized: false
  }).write('foo', 'utf8', common.mustCall(() => {
    assert(netSocket);
    netSocket.setTimeout(1, common.mustCall(() => {
      assert(tlsSocket);
      // this breaks if TLSSocket is already managing the socket:
      netSocket.destroy();
      const interval = setInterval(() => {
        // Checking this way allows us to do the write at a time that causes a
        // segmentation fault (not always, but often) in Node.js 7.7.3 and
        // earlier. If we instead, for example, wait on the `close` event, then
        // it will not segmentation fault, which is what this test is all about.
        if (tlsSocket._handle._parent.bytesRead === 0) {
          tlsSocket.write('bar');
          clearInterval(interval);
        }
      }, 1);
    }));
  }));
}));
