// Copyright 2016 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Run the test runner and dump a json file. Use this script to pass
// the json file and return a list of failing tests that can be copied
// to test262.status.
//
// Usage:
//
// Run the test runner to generate the results:
// $ tools/run-tests.py --gn test262 --json-test-results=tools/.test262-results.json
//
// Run this script to print the formatted results:
// $ node tools/test262-results-parser.js .test262-results.json
//
// Note: The json results file generated by the test runner should be
// in the tools/ directly, which is the same dir as this script.

var fs = require('fs'),
    path = require('path');

function main() {
  if (process.argv.length === 2)  {
    throw new Error('File name required as first arg.');
  }

  var fileName = process.argv[2],
      fullPath = path.join(__dirname, fileName),
      results = require(fullPath)[0].results,
      tests = new Set();
  for (let result of results) {
    let [_, ...test] = result.name.split('/');
    tests.add(`  '${test.join('/')}': [FAIL],`);
  }


  [...tests].sort().forEach(i => console.log(i));
}

main();
