/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.mdr.persistence.MOFID;

public class TransactionCache {
    private static final int GLOBAL_TRESHOLD = 768;
    private static final int LOCAL_TRESHOLD = 512;
    public static final byte OP_INSERT = 0;
    public static final byte OP_DELETE = 1;
    public static final byte OP_REPLACE = 2;
    private static int cacheSize = 0;
    private int localCacheSize = 0;
    private boolean tresholdReached = false;
    private boolean dataCommited = false;
    private LinkedList commitedOperations = new LinkedList();
    private LinkedList operations = new LinkedList();

    public boolean tresholdReached() {
        return this.tresholdReached;
    }

    public boolean containsCommitedData() {
        return this.dataCommited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.operations = new LinkedList();
        this.commitedOperations.clear();
        Class clazz = TransactionCache.class;
        synchronized (clazz) {
            cacheSize -= this.localCacheSize;
            this.localCacheSize = 0;
            this.tresholdReached = false;
        }
        this.dataCommited = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementCacheSize() {
        Class clazz = TransactionCache.class;
        synchronized (clazz) {
            ++this.localCacheSize;
            this.tresholdReached |= ++cacheSize >= 768 || this.localCacheSize >= 512;
        }
    }

    public void addInserted(MOFID id, byte[] value) {
        if (!this.tresholdReached) {
            this.operations.addLast(new Record(0, id, value));
            this.incrementCacheSize();
        }
    }

    public void addDeleted(MOFID id) {
        if (!this.tresholdReached) {
            this.operations.addLast(new Record(1, id, null));
            this.incrementCacheSize();
        }
    }

    public void addReplaced(MOFID id, byte[] value) {
        if (!this.tresholdReached) {
            this.operations.addLast(new Record(2, id, value));
            this.incrementCacheSize();
        }
    }

    public void commit() {
        if (!this.operations.isEmpty()) {
            this.commitedOperations.addLast(this.operations);
        }
        this.operations = new LinkedList();
        this.dataCommited = true;
    }

    public CacheIterator iterator() {
        return new CacheIterator();
    }

    public class CacheIterator {
        private Iterator primar;
        private Iterator secondar = null;
        private Object nextItem = null;

        CacheIterator() {
            this.primar = TransactionCache.this.commitedOperations.iterator();
            if (this.primar.hasNext()) {
                this.secondar = ((List)this.primar.next()).iterator();
                this.fetchNext();
            }
        }

        private void fetchNext() {
            if (this.secondar.hasNext()) {
                this.nextItem = this.secondar.next();
            } else if (this.primar.hasNext()) {
                this.secondar = ((List)this.primar.next()).iterator();
                this.nextItem = this.secondar.next();
            } else {
                this.nextItem = null;
            }
        }

        public boolean hasNext() {
            return this.nextItem != null;
        }

        public Record next() {
            Object temp = this.nextItem;
            this.fetchNext();
            return (Record)temp;
        }
    }

    public static class Record {
        byte op;
        MOFID id;
        byte[] value;

        public Record(byte opId, MOFID id, byte[] value) {
            this.op = opId;
            this.id = id;
            this.value = value;
        }
    }
}

