import { DateTime as LuxonDateTime, DateTimeOptions } from "luxon";
export declare class DateTime {
    dateTime: LuxonDateTime;
    constructor(dateTime: LuxonDateTime);
    get isDateTime(): boolean;
    get isValid(): boolean;
    get year(): number;
    get month(): number;
    get day(): number;
    get hour(): number;
    get minute(): number;
    get second(): number;
    static fromMillis(milliseconds: number): DateTime;
    static local(year?: number, month?: number, day?: number, hour?: number, minute?: number, second?: number, millisecond?: number): DateTime;
    static utc(year?: number, month?: number, day?: number, hour?: number, minute?: number, second?: number, millisecond?: number): DateTime;
    static fromIsoString(isoString: string, opts?: DateTimeOptions): DateTime;
    toJsDate(): Date;
    valueOf(): number;
    equals(other: DateTime): boolean;
    diff(other: DateTime): import("luxon").Duration<boolean>;
    toTimeString(): string;
    toIsoString(): string;
    toLocalIsoString(): string | null;
    toFormat(formatString: string): string;
    add(object: any): DateTime;
    unsignedSubtractDays(other: DateTime): number;
    unsignedSubstractMinutes(other: DateTime): number;
    stripTime(): DateTime;
    toString(): void;
    toIntlFormat(): string;
}
//# sourceMappingURL=DateTime.d.ts.map