import { scroll } from './internal/scroll';
var scrollElement = function scrollElement(element, change) {
  element.scrollBy(change.x, change.y);
};
var scrollWindow = function scrollWindow(change) {
  window.scrollBy(change.x, change.y);
};
export var createAutoScroller = function createAutoScroller() {
  var dragging = null;
  function tryScroll(fakeScrollCallback) {
    if (dragging == null) {
      return;
    }
    scroll({
      input: dragging.latestInput,
      dragStartTime: dragging.dragStartTime,
      shouldUseTimeDampening: dragging.shouldUseTimeDampening,
      behavior: dragging.behavior,
      scrollElement: fakeScrollCallback !== null && fakeScrollCallback !== void 0 ? fakeScrollCallback : scrollElement,
      scrollWindow: fakeScrollCallback !== null && fakeScrollCallback !== void 0 ? fakeScrollCallback : scrollWindow
    });
  }

  // Every animation frame use the latest user input to scroll
  // We do this loop manually rather than in response to `onDrag`
  // events as `onDrag` can drop to 50-100ms between events when
  // the user is not actively moving their pointer
  function loop() {
    if (!dragging) {
      return;
    }
    dragging.loopFrameId = requestAnimationFrame(function () {
      tryScroll();
      loop();
    });
  }
  var start = function start(_ref) {
    var input = _ref.input,
      _ref$behavior = _ref.behavior,
      behavior = _ref$behavior === void 0 ? 'window-then-container' : _ref$behavior;
    var dragStartTime = Date.now();
    dragging = {
      dragStartTime: dragStartTime,
      latestInput: input,
      loopFrameId: null,
      shouldUseTimeDampening: false,
      behavior: behavior
    };

    // we only use time dampening when auto scrolling starts on lift.
    var fakeScrollCallback = function fakeScrollCallback() {
      if (dragging) {
        dragging.shouldUseTimeDampening = true;
      }
    };
    tryScroll(fakeScrollCallback);
    loop();
  };
  function updateInput(_ref2) {
    var input = _ref2.input;
    if (!dragging) {
      return;
    }
    dragging.latestInput = input;
  }
  var stop = function stop() {
    // can be called defensively
    if (!dragging) {
      return;
    }
    if (dragging.loopFrameId) {
      cancelAnimationFrame(dragging.loopFrameId);
    }
    dragging = null;
  };
  return {
    start: start,
    updateInput: updateInput,
    stop: stop
  };
};
export var autoScroller = createAutoScroller();