/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util.office;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.Helper;
import com.sun.jna.platform.win32.COM.util.Factory;
import com.sun.jna.platform.win32.COM.util.office.excel.Borders;
import com.sun.jna.platform.win32.COM.util.office.excel.Chart;
import com.sun.jna.platform.win32.COM.util.office.excel.ComExcel_Application;
import com.sun.jna.platform.win32.COM.util.office.excel.ComIApplication;
import com.sun.jna.platform.win32.COM.util.office.excel.ComIRange;
import com.sun.jna.platform.win32.COM.util.office.excel.ComIWorkbook;
import com.sun.jna.platform.win32.COM.util.office.excel.ComIWorksheet;
import com.sun.jna.platform.win32.COM.util.office.excel.Shape;
import com.sun.jna.platform.win32.COM.util.office.excel.XlBorderWeight;
import com.sun.jna.platform.win32.COM.util.office.excel.XlChartLocation;
import com.sun.jna.platform.win32.COM.util.office.excel.XlLineStyle;
import com.sun.jna.platform.win32.COM.util.office.excel.XlRowCol;
import com.sun.jna.platform.win32.COM.util.office.office.XlChartType;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class Excelautomation_KB_219151_Mod {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Ole32.INSTANCE.CoInitializeEx(Pointer.NULL, 0);
        Factory fact = new Factory();
        fact.setLCID(new WinDef.LCID(1033L));
        try {
            ComExcel_Application excel = fact.createObject(ComExcel_Application.class);
            ComIApplication excelApp = excel.queryInterface(ComIApplication.class);
            excelApp.setVisible(true);
            Helper.sleep(5);
            ComIWorkbook wb = excelApp.getWorkbooks().Add();
            ComIWorksheet sheet = wb.getActiveSheet();
            sheet.getCells().getItem(1, 1).setValue("First Name");
            sheet.getCells().getItem(1, 2).setValue("Last Name");
            sheet.getCells().getItem(1, 3).setValue("Full Name");
            sheet.getCells().getItem(1, 4).setValue("Salary");
            OaIdl.SAFEARRAY saNames = Excelautomation_KB_219151_Mod.safeVariantArrayFromJava(new String[][]{{"John", "Smith"}, {"Tom", "Brown"}, {"Sue", "Thomas"}, {"Jane", "Jones"}, {"Adam", "Johnson"}});
            Variant.VARIANT valueHolder = new Variant.VARIANT();
            valueHolder.setValue(8204, (Object)saNames);
            sheet.getRange("A2", "B6").setValue(valueHolder);
            saNames.destroy();
            sheet.getRange("C2", "C6").setFormula("= A2 & \" \" & B2");
            sheet.getRange("D2", "D6").setFormula("=RAND()*100000");
            sheet.getRange("D2", "D6").setNumberFormat("$0.00");
            sheet.getRange("A1", "D2").getEntireColumn().AutoFit();
            Excelautomation_KB_219151_Mod.displayQuaterlySales(sheet);
            File tempFile = Helper.createNotExistingFile("exceloutput", ".xlsx");
            System.out.println("Writing output to: " + tempFile.getAbsolutePath());
            wb.SaveAs(tempFile.getAbsolutePath());
            excelApp.setUserControl(true);
        }
        finally {
            fact.disposeAll();
            Ole32.INSTANCE.CoUninitialize();
        }
        System.exit(0);
    }

    private static void displayQuaterlySales(ComIWorksheet sheet) {
        int iNumQtrs;
        for (iNumQtrs = 4; iNumQtrs >= 2; --iNumQtrs) {
            JOptionPane pane = new JOptionPane(String.format("Enter sales data for %d quarter(s)?", iNumQtrs), 3);
            pane.setOptionType(0);
            JDialog dialog = pane.createDialog("Input...");
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            if ((Integer)pane.getValue() == 0) break;
        }
        JOptionPane.showMessageDialog(null, String.format("Displaying data for %d quarter(s).", iNumQtrs));
        ComIRange oResizeRange = sheet.getRange("E1", "E1").getResize(Variant.VARIANT.VARIANT_MISSING, iNumQtrs);
        oResizeRange.setFormula("=\"Q\" & COLUMN() - 4 & CHAR(10) & \"Sales\"");
        oResizeRange.setOrientation(38);
        oResizeRange.setWrapText(true);
        oResizeRange.getInterior().setColorIndex(36);
        oResizeRange = sheet.getRange("E2", "E6").getResize(Variant.VARIANT.VARIANT_MISSING, iNumQtrs);
        oResizeRange.setFormula("=RAND()*100");
        oResizeRange.setNumberFormat("$0.00");
        oResizeRange = sheet.getRange("E1", "E6").getResize(Variant.VARIANT.VARIANT_MISSING, iNumQtrs);
        oResizeRange.getBorders().setWeight(XlBorderWeight.xlThin);
        oResizeRange = sheet.getRange("E8", "E8").getResize(Variant.VARIANT.VARIANT_MISSING, iNumQtrs);
        oResizeRange.setFormula("=SUM(E2:E6)");
        Borders oResizeRangeBorders = oResizeRange.getBorders();
        oResizeRangeBorders.setLineStyle(XlLineStyle.xlDouble);
        oResizeRangeBorders.setWeight(XlBorderWeight.xlThick);
        oResizeRange = sheet.getRange("E2:E6").getResize(Variant.VARIANT.VARIANT_MISSING, iNumQtrs);
        Chart chart = sheet.getParent().getCharts().Add(Variant.VARIANT.VARIANT_MISSING, Variant.VARIANT.VARIANT_MISSING, Variant.VARIANT.VARIANT_MISSING, Variant.VARIANT.VARIANT_MISSING);
        chart.ChartWizard(oResizeRange, XlChartType.xl3DColumn, Variant.VARIANT.VARIANT_MISSING, XlRowCol.xlColumns, null, null, null, null, null, null, null);
        chart.SeriesCollection(1).setXValues(sheet.getRange("C2", "C6"));
        for (int i = 1; i <= iNumQtrs; ++i) {
            chart.SeriesCollection(i).setName("=\"Q" + Integer.toString(i) + "\"");
        }
        chart.Location(XlChartLocation.xlLocationAsObject, sheet.getName());
        Shape shape = sheet.getShapes().Item(1);
        shape.setTop(sheet.getRows(10).getTop());
        shape.setLeft(sheet.getColumns(2).getLeft());
    }

    private static OaIdl.SAFEARRAY safeVariantArrayFromJava(String[][] data) {
        OaIdl.SAFEARRAY.ByReference wrapped = OaIdl.SAFEARRAY.createSafeArray(data[0].length, data.length);
        Variant.VARIANT var = new Variant.VARIANT();
        for (int i = 0; i < data.length; ++i) {
            int j = 0;
            while (j < data[0].length) {
                var.setValue(8, (Object)new WTypes.BSTR(data[i][j]));
                wrapped.putElement(var, j++, i);
            }
        }
        return wrapped;
    }
}

