/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;

public class TldLocationsCache {
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private Hashtable mappings;
    private Hashtable tlds;
    private boolean initialized;
    private ServletContext ctxt;

    public TldLocationsCache(ServletContext ctxt) {
        this.ctxt = ctxt;
        this.mappings = new Hashtable();
        this.tlds = new Hashtable();
        this.initialized = false;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        try {
            this.processWebDotXml();
            this.processJars();
            this.processTldsInFileSystem("/WEB-INF/");
            this.initialized = true;
        }
        catch (JasperException ex) {
            Constants.message((String)"jsp.error.internal.tldinit", (Object[])new Object[]{ex.getMessage()}, (int)1);
        }
    }

    private void processWebDotXml() throws JasperException {
        InputStream is = this.ctxt.getResourceAsStream(WEB_XML);
        if (is == null) {
            Constants.message((String)"jsp.error.internal.filenotfound", (Object[])new Object[]{WEB_XML}, (int)2);
            return;
        }
        TreeNode webtld = new ParserUtils().parseXMLDocument(WEB_XML, is);
        Iterator taglibs = webtld.findChildren("taglib");
        while (taglibs.hasNext()) {
            TreeNode taglib = (TreeNode)taglibs.next();
            String tagUri = null;
            String tagLoc = null;
            TreeNode child = taglib.findChild("taglib-uri");
            if (child != null) {
                tagUri = child.getBody();
            }
            if ((child = taglib.findChild("taglib-location")) != null) {
                tagLoc = child.getBody();
            }
            if (tagLoc == null) continue;
            if (TldLocationsCache.uriType(tagLoc) == 2) {
                tagLoc = "/WEB-INF/" + tagLoc;
            }
            String tagLoc2 = null;
            if (tagLoc.endsWith(".jar")) {
                tagLoc2 = "META-INF/taglib.tld";
            }
            this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
        }
    }

    private void processJars() throws JasperException {
        Set libSet = this.ctxt.getResourcePaths("/WEB-INF/lib");
        if (libSet != null) {
            Iterator it = libSet.iterator();
            while (it.hasNext()) {
                String resourcePath = (String)it.next();
                if (!resourcePath.endsWith(".jar")) continue;
                this.processTldsInJar(resourcePath);
            }
        }
    }

    private void processTldsInJar(String resourcePath) throws JasperException {
        ZipFile jarFile = null;
        InputStream stream = null;
        try {
            URL url = this.ctxt.getResource(resourcePath);
            if (url == null) {
                return;
            }
            url = new URL("jar:" + url.toString() + "!/");
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                String uri;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld") || (uri = this.getUriFromTld(resourcePath, stream = ((JarFile)jarFile).getInputStream(entry))) == null || this.mappings.get(uri) != null) continue;
                this.mappings.put(uri, new String[]{resourcePath, name});
            }
        }
        catch (Exception ex) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw new JasperException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTldsInFileSystem(String startPath) throws JasperException {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList == null) return;
        Iterator it = dirList.iterator();
        while (true) {
            String uri;
            String path;
            block8: {
                Throwable t2;
                Object var8_7;
                if (!it.hasNext()) {
                    return;
                }
                path = (String)it.next();
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                InputStream stream = this.ctxt.getResourceAsStream(path);
                uri = null;
                try {
                    uri = this.getUriFromTld(path, stream);
                    var8_7 = null;
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Throwable t2) {}
                stream.close();
            }
            if (uri == null || this.mappings.get(uri) != null) continue;
            this.mappings.put(uri, new String[]{path, null});
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    public String[] getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return (String[])this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    public TagLibraryInfo getTagLibraryInfo(String uri) {
        if (!this.initialized) {
            this.init();
        }
        return (TagLibraryInfo)this.tlds.get(uri);
    }

    public void addTagLibraryInfo(String uri, TagLibraryInfo tld) {
        if (!this.initialized) {
            this.init();
        }
        this.tlds.put(uri, tld);
    }
}

