/***************************************************************************
*	Copyright (C) 2004 by karye												*
*	karye@users.sourceforge.net												*
*																			*
*	This program is free software; you can redistribute it and/or modify	*
*	it under the terms of the GNU General Public License as published by	*
*	the Free Software Foundation; either version 2 of the License, or		*
*	(at your option) any later version.										*
*																			*
*	This program is distributed in the hope that it will be useful,			*
*	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
*	GNU General Public License for more details.							*
*																			*
*	You should have received a copy of the GNU General Public License		*
*	along with this program; if not, write to the							*
*	Free Software Foundation, Inc.,											*
*	59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.				*
***************************************************************************/

#include <kio/filecopyjob.h>   // for file_copy
#include <kio/job_base.h>      // for operator|, HideProgressInfo, Overwrite
#include <klocalizedstring.h>  // for i18n
#include <kmessagebox.h>       // for enableAllMessages
#include <qcheckbox.h>         // for QCheckBox
#include <qdatetime.h>         // for QDateTime
#include <qglobal.h>           // for foreach, QGlobalStatic
#include <qlabel.h>            // for QLabel
#include <qurl.h>              // for QUrl

#include "global.h"            // for kurooDir
#include "introdlg.h"
#include "settings.h"          // for KurooConfig

/**
 * @class IntroDlg
 * @short Kuroo introduction wizard.
 */
IntroDlg::IntroDlg( QWidget* parent ) : QWizard( parent )
{
	setupUi( this );
	setWindowTitle( QStringLiteral("Kuroo-") + KurooConfig::hardVersion() );
	setOption( NoBackButtonOnStartPage, true );
	setButtonText( FinishButton, i18n("Ok") );
	setOption( HaveHelpButton, false );

	introText->setText(QStringLiteral("<h2>Kuroo-%1</h2><p>%2").arg( KurooConfig::hardVersion().section( u'_', 0, 0 ),
				i18n("Kuroo - A KDE Portage frontend that allows you to do most common software maintenance tasks on gentoo systems</p>")));

	//TODO: convert to QStringBuilder
	QString backupFilesText = QStringLiteral("<qt><table width=100%><tr><td>");
	backupFilesText += i18n("Make copies into %1backup/ of following files:", kurooDir);
	backupFilesText += QStringLiteral("</td></tr>");
	// declaring a local const container prevents detaching and the attendant clazy warning
	// In C++20 the range for can do this in the loop declaration https://www.kdab.com/blog-qasconst-and-stdas_const/
	const QStringList keywords = KurooConfig::filePackageKeywords();
	const QStringList unmask = KurooConfig::filePackageUserUnMask();
	const QStringList mask = KurooConfig::filePackageUserMask();
	const QStringList use = KurooConfig::filePackageUserUse();
	for(const QString& f : keywords)
		backupFilesText += QStringLiteral("<tr><td>%1</td></tr>").arg( f );
	for(const QString& f : unmask)
		backupFilesText += QStringLiteral("<tr><td>%1</td></tr>").arg( f );
	for(const QString& f : mask)
		backupFilesText += QStringLiteral("<tr><td>%1</td></tr>").arg( f );
	for(const QString& f : use)
		backupFilesText += QStringLiteral("<tr><td>%1</td></tr>").arg( f );
	backupFilesText += QStringLiteral("<tr><td>%1</td></tr><tr><td>%2</td></tr></table></qt>").
							arg( KurooConfig::fileWorld(), KurooConfig::fileMakeConf() );

	backupFiles->setText(backupFilesText);
	adjustSize();
}

IntroDlg::~IntroDlg() = default;

void IntroDlg::accept()
{
	// Backup all portage files changeable by kuroo
	if ( cbBackup->isChecked() ) {
		QString dt = u' ' + QDateTime::currentDateTime().toString( QStringLiteral("yyyyMMdd_hhmm") );
		//QString filePackageKeywords( KurooConfig::filePackageKeywords() );
		// declaring a local const container prevents detaching and the attendant clazy warning
		// In C++20 the range for can do this in the loop declaration https://www.kdab.com/blog-qasconst-and-stdas_const/
		const QStringList keywords = KurooConfig::filePackageKeywords();
		const QStringList unmask = KurooConfig::filePackageUserUnMask();
		const QStringList mask = KurooConfig::filePackageUserMask();
		const QStringList use = KurooConfig::filePackageUserUse();
		for(const QString& f : keywords)
			KIO::file_copy( QUrl::fromLocalFile( f ), QUrl::fromLocalFile( kurooDir % QStringLiteral("backup/package.keywords-") % f.section( u'/', -1 ) % dt ),
					-1, KIO::Overwrite | KIO::HideProgressInfo);
		//QString filePackageUserUnMask( KurooConfig::filePackageUserUnMask() );
		for(const QString& f : unmask)
			KIO::file_copy( QUrl::fromLocalFile( f ), QUrl::fromLocalFile( kurooDir % QStringLiteral("backup/package.unmask-") % f.section( u'/', -1 ) % dt ),
					-1, KIO::Overwrite | KIO::HideProgressInfo );
		//QString filePackageUserMask( KurooConfig::filePackageUserMask() );
		for(const QString& f : mask)
			KIO::file_copy( QUrl::fromLocalFile( f ), QUrl::fromLocalFile( kurooDir % QStringLiteral("backup/package.mask-") % f.section( u'/', -1 ) % dt ),
					-1, KIO::Overwrite | KIO::HideProgressInfo );
		//QString filePackageUserUse( KurooConfig::filePackageUserUse() );
		for(const QString& f : use)
			KIO::file_copy( QUrl::fromLocalFile( f ), QUrl::fromLocalFile( kurooDir % QStringLiteral("backup/package.use-") % f.section( u'/', -1 ) % dt ),
					-1, KIO::Overwrite | KIO::HideProgressInfo );
		QString fileWorld( KurooConfig::fileWorld() );
		KIO::file_copy( QUrl::fromLocalFile( fileWorld ), QUrl::fromLocalFile( kurooDir % QStringLiteral("backup/") % fileWorld.section( u'/', -1 ) % dt ),
				-1, KIO::Overwrite | KIO::HideProgressInfo );
		QString fileMakeConf( KurooConfig::fileMakeConf() );
		KIO::file_copy( QUrl::fromLocalFile( fileMakeConf ), QUrl::fromLocalFile( kurooDir % QStringLiteral("backup/") % fileMakeConf.section( u'/', -1 ) % dt ),
				-1, KIO::Overwrite | KIO::HideProgressInfo );
	}

	KMessageBox::enableAllMessages();
	QWizard::accept();
}


