/*
* wmacpimon v0.2.1
* (C) 2002 Costantino Pistagna (valvoline@vrlteam.org)
* wmacpimon homepage: http://www.vlrteam.org/wmacpimon
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#include <X11/xpm.h>
#define ver "0.2.1"

#ifndef _WMACPI_H_
#define _WMACPI_H_

typedef enum {
    REMAIN,
    TIMER
} DspMode;

typedef enum {
    BLINK,
    OFF
} Mode;

typedef struct {
    int percentage;		/* battery percentage (-1 if no battery) */
    char speed[5];      /* processor speed */
	int cooling;        /* cooling CPU on/off */
	int crit_level;		/* anything below this is critical low */
	int state;			/* thermal_zone_state */
	int batt;			/* battery (0) or AC adapter (1) */
	int load;           /* system load average */
	int charge;         /* charging (0), discharging (1), full (2) */
	int remain;			/* battery remain (percentage) */
	int currcap;        /* current capacity */
} ACPInfo;

typedef struct {
    Display *display;	/* X11 display struct */
    int screen;			/* current screen */
    Window root;		/* root window */
    Window win;			/* one window */
    Window iconwin;		/* another one */
    Pixmap pixmap;		/* UI pixmap, window pixmap */
    Pixmap mask;		/* mask pixmap for shape */
    GC gc;			    /* main drawing GC */
    Pixmap text;		/* pixmap for bottom text */
    int tw;			    /* text width inside text pixmap */
    int update;			/* need to redraw? */
    int pressed;		/* is the button pressed? */
    DspMode dspmode;	/* time remaining or battery timer */
    Mode blink;			/* should we blink the LED? (critical battery) */
} Dockapp;


/* detect plugin events */
void process_plugin_timer(void);
/* check if apm/acpi is enabled, etc */
int power_init(void);
/* fill APMInfo with data */
void acquire_info(void);
void acquire_info2(void);
void init_acpinfo(void);
#endif /* _WMACPI_H_ */
