# snoRNAs.sql was originally generated by the autoSql program, which also 
# generated snoRNAs.c and snoRNAs.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#C/D box snoRNA genes
CREATE TABLE snoRNAs (
    bin int unsigned not null, 
    chrom varchar(255) not null,	# Reference sequence chromosome or scaffold
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# snoRNA RNA gene name
    score int unsigned not null,	# Score from 900-1000.  1000 is best
    strand char(1) not null,	# Value should be + or -
    snoScore float not null,	# snoscan score
    targetList varchar(255) not null,	# Target RNAs
    orthologs varchar(255) not null,	# Possible gene orthologs in closely-related species
    guideLen varchar(255) not null,	# Length of guide region
    guideStr longblob not null,	# Guide region string
    guideScore varchar(255) not null,	# Guide region score
    cBox varchar(255) not null,	# C box feature
    dBox varchar(255) not null,	# D box feature
    cpBox varchar(255) not null,	# C' box feature
    dpBox varchar(255) not null,	# D' box feature
    hmmScore float not null,	# score to HMM snoRNA model
    snoscanOutput longblob not null,	# Full snoscan output for snoRNA
              #Indices
    PRIMARY KEY(name)
);
