table netAlign
"Database representation of a net of alignments."
(
uint level;       "Level of alignment"
string tName;     "Target chromosome"
uint tStart;      "Start on target"
uint tEnd;        "End on target"
char[1] strand;   "Orientation of query. + or -"
string qName;     "Query chromosome"
uint qStart;      "Start on query"
uint qEnd;        "End on query"
uint chainId;     "Associated chain Id with alignment details"
uint ali;         "Bases in gap-free alignments"
double score;     "Score - a number proportional to 100x matching bases"
int qOver;        "Overlap with parent gap on query side. -1 for undefined"
int qFar;         "Distance from parent gap on query side. -1 for undefined"
int qDup;         "Bases with two or more copies in query. -1 for undefined"
string type;      "Syntenic type: gap/top/syn/nonsyn/inv"
int tN;           "Unsequenced bases on target. -1 for undefined"
int qN;           "Unsequenced bases on query. -1 for undefined"
int tR;           "RepeatMasker bases on target. -1 for undefined"
int qR;           "RepeatMasker bases on query. -1 for undefined"
int tNewR;        "Lineage specific repeats on target. -1 for undefined"
int qNewR;        "Lineage specific repeats on query. -1 for undefined"
int tOldR;        "Bases of ancient repeats on target. -1 for undefined"
int qOldR;        "Bases of ancient repeats on query. -1 for undefined"
int tTrf;         "Bases of tandem repeats on target. -1 for undefined"
int qTrf;         "Bases of tandem repeats on query. -1 for undefined"
)
