/* flyreg.c was originally generated by the autoSql program, which also 
 * generated flyreg.h and flyreg.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "flyreg.h"


void flyregStaticLoad(char **row, struct flyreg *ret)
/* Load a row from flyreg table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->target = row[4];
ret->pmid = sqlUnsigned(row[5]);
}

struct flyreg *flyregLoad(char **row)
/* Load a flyreg from row fetched with select * from flyreg
 * from database.  Dispose of this with flyregFree(). */
{
struct flyreg *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->target = cloneString(row[4]);
ret->pmid = sqlUnsigned(row[5]);
return ret;
}

struct flyreg *flyregLoadAll(char *fileName) 
/* Load all flyreg from a whitespace-separated file.
 * Dispose of this with flyregFreeList(). */
{
struct flyreg *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = flyregLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct flyreg *flyregLoadAllByChar(char *fileName, char chopper) 
/* Load all flyreg from a chopper separated file.
 * Dispose of this with flyregFreeList(). */
{
struct flyreg *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = flyregLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct flyreg *flyregCommaIn(char **pS, struct flyreg *ret)
/* Create a flyreg out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new flyreg */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->target = sqlStringComma(&s);
ret->pmid = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void flyregFree(struct flyreg **pEl)
/* Free a single dynamically allocated flyreg such as created
 * with flyregLoad(). */
{
struct flyreg *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->target);
freez(pEl);
}

void flyregFreeList(struct flyreg **pList)
/* Free a list of dynamically allocated flyreg's */
{
struct flyreg *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    flyregFree(&el);
    }
*pList = NULL;
}

void flyregOutput(struct flyreg *el, FILE *f, char sep, char lastSep) 
/* Print out flyreg.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->target);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->pmid);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

