/* sanger22extra.h was originally generated by the autoSql program, which also 
 * generated sanger22extra.c and sanger22extra.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef SANGER22EXTRA_H
#define SANGER22EXTRA_H

struct sanger22extra
/* Table with additional information about a Sanger 22 gene */
    {
    struct sanger22extra *next;  /* Next in singly linked list. */
    char *name;	/* Transcript name */
    char *locus;	/* Possibly biological short name */
    char *description;	/* Description from Sanger gene GFFs */
    char *geneType;	/* Type field from Sanger gene GFFs */
    char *cdsType;	/* Type field from Sanger CDS GFFs */
    };

void sanger22extraStaticLoad(char **row, struct sanger22extra *ret);
/* Load a row from sanger22extra table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct sanger22extra *sanger22extraLoad(char **row);
/* Load a sanger22extra from row fetched with select * from sanger22extra
 * from database.  Dispose of this with sanger22extraFree(). */

struct sanger22extra *sanger22extraLoadAll(char *fileName);
/* Load all sanger22extra from a tab-separated file.
 * Dispose of this with sanger22extraFreeList(). */

struct sanger22extra *sanger22extraCommaIn(char **pS, struct sanger22extra *ret);
/* Create a sanger22extra out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sanger22extra */

void sanger22extraFree(struct sanger22extra **pEl);
/* Free a single dynamically allocated sanger22extra such as created
 * with sanger22extraLoad(). */

void sanger22extraFreeList(struct sanger22extra **pList);
/* Free a list of dynamically allocated sanger22extra's */

void sanger22extraOutput(struct sanger22extra *el, FILE *f, char sep, char lastSep);
/* Print out sanger22extra.  Separate fields with sep. Follow last field with lastSep. */

#define sanger22extraTabOut(el,f) sanger22extraOutput(el,f,'\t','\n');
/* Print out sanger22extra as a line in a tab-separated file. */

#define sanger22extraCommaOut(el,f) sanger22extraOutput(el,f,',',',');
/* Print out sanger22extra as a comma separated list including final comma. */

/* ---------- End of AutoSQL generated code ---------------- */

extern char *sanger22extraCreate;

#endif /* SANGER22EXTRA_H */

