/*
 * Decompiled with CFR 0.152.
 */
package net.humblestar.gcalcdemo.calculus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.models.ColoredModel;
import net.gcalc.calc.models.Model;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.calc.parser.Token;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.gui.PropertiesPanel;
import net.gcalc.plugin.gui.SimpleColorChooser;
import net.gcalc.plugin.plane.CartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.plane.gui.FlagPanel;
import net.gcalc.plugin.plane.gui.ModelListPanel;
import net.gcalc.plugin.properties.GraphProperties;

public class FunctionGymnastics
extends CartesianGraphPlugin {
    private Function f = null;
    private FunctionGymnasticsPanel fgp;
    private ValueTable vt = new ValueTable();

    public FunctionGymnastics() {
        this.graph = new FunctionGymnasticsGraph(this);
        this.fgp = new FunctionGymnasticsPanel();
    }

    protected void initPropertiesPanel() {
        JPanel flagPanel = this.makeFlagPanel();
        Box viewPanel = SwingGUI.wrap(this.makeViewPanel());
        this.colorChooser = new SimpleColorChooser(this.firstColor());
        PropertiesPanel propertiesPanel = this.getPropertiesPanel();
        propertiesPanel.addTab("Properties", flagPanel);
        propertiesPanel.addTab("View", viewPanel);
        propertiesPanel.addTab("Screen", this.makeGraphDimensionPanel());
        propertiesPanel.addTab("Parameters", this.makeParametersPanel());
    }

    protected JPanel makeFlagPanel() {
        return new FlagPanel(this.graph.getProperties(), 5, 2, new String[]{GraphProperties.H_GRID, GraphProperties.V_GRID, GraphProperties.H_AXIS, GraphProperties.V_AXIS, GraphProperties.H_LABEL, GraphProperties.V_LABEL, GraphProperties.H_SCALE, GraphProperties.V_SCALE, GraphProperties.H_TITLE, GraphProperties.V_TITLE});
    }

    protected JPanel makeModelListPanel() {
        return new ModelListPanel(this.graph.getProperties(), false, true);
    }

    protected JPanel makeParametersPanel() {
        return this.fgp;
    }

    public String getDescription() {
        return "<p>Shows the effects of various parameters on a function.</p><p>Examples:</p><p>f(x)=m*x+b<br>f(x)=A sin(B*(x-C))<br><p>";
    }

    public String getPluginName() {
        return "Function Gymnastics";
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.ip) {
            String[] values = this.ip.getValues();
            String s1 = values[0].trim();
            this.f = null;
            try {
                this.f = FunctionFactory.getFunction(s1);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s1 + "'!\n" + e.getMessage(), 0);
                return;
            }
            this.fgp.reset();
            this.graph.clearModelList();
            this.graph.redrawAll();
            this.drawGraph(new ColoredModel(this.f, s1, this.getNewColor()));
            this.statusBar.setText("Graphing: " + s1);
        }
    }

    protected void drawGraph(ColoredModel model) {
        this.graph.draw((Model)model);
        this.ip.addCurrentValuesToHistory();
    }

    class FunctionGymnasticsGraph
    extends CartesianGraph {
        public FunctionGymnasticsGraph(AbstractCartesianGraphPlugin plugin) {
            super(plugin);
        }

        public Dimension defaultDimension() {
            return new Dimension(425, 425);
        }

        protected void draw(Function F, Color color, Graphics gr) {
            this.draw(F, color, gr, FunctionGymnastics.this.vt);
        }
    }

    class FunctionGymnasticsPanel
    extends JPanel {
        public FunctionGymnasticsPanel() {
            super(new BorderLayout());
            this.reset();
        }

        public void reset() {
            this.removeAll();
            Box box = Box.createHorizontalBox();
            JScrollPane jsp = new JScrollPane(box, 21, 32);
            Vector v = new Vector();
            if (FunctionGymnastics.this.f != null) {
                v = FunctionGymnastics.this.f.getVars();
            }
            System.out.println(v);
            FunctionGymnastics.this.vt = new ValueTable();
            int count = 0;
            int i = 0;
            while (i < v.size()) {
                Token t = (Token)v.elementAt(i);
                if (!FunctionGymnastics.this.vt.containsVariable(t) && !t.getName().equals("x")) {
                    ++count;
                    FunctionGymnastics.this.vt.setValue(t, 0.0);
                    box.add(new DoubleScale(t, -10.0, 10.0));
                }
                ++i;
            }
            box.add(Box.createVerticalGlue());
            jsp.setPreferredSize(new Dimension(250, 350));
            this.add("North", jsp);
            System.out.println(this);
            this.repaint();
        }
    }

    class DoubleScale
    extends JPanel
    implements AdjustmentListener,
    ActionListener {
        JLabel value;
        JTextField minTF;
        JTextField maxTF;
        JScrollBar scrollbar;
        Token tok;

        public DoubleScale(Token s, double min, double max) {
            super(new BorderLayout());
            this.tok = s;
            this.value = new JLabel(" ");
            this.minTF = new JTextField("" + min);
            this.maxTF = new JTextField("" + max);
            this.minTF.addActionListener(this);
            this.maxTF.addActionListener(this);
            this.scrollbar = new JScrollBar(1, 500, 0, 0, 1000);
            this.scrollbar.addAdjustmentListener(this);
            Box sbp = Box.createHorizontalBox();
            sbp.add(Box.createHorizontalGlue());
            sbp.add("East", this.scrollbar);
            sbp.add(Box.createHorizontalGlue());
            JPanel panel = new JPanel(new BorderLayout());
            panel.add("North", this.maxTF);
            panel.add("Center", sbp);
            panel.add("South", this.minTF);
            this.add("North", new JLabel(this.tok.getName(), 0));
            this.add("Center", panel);
            this.add("South", this.value);
            this.setPreferredSize(new Dimension(70, 200));
            this.somethingChanged();
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            this.somethingChanged();
        }

        public void actionPerformed(ActionEvent e) {
            this.somethingChanged();
        }

        public void somethingChanged() {
            double min = Double.parseDouble(this.minTF.getText());
            double max = Double.parseDouble(this.maxTF.getText());
            double val = max - (double)this.scrollbar.getValue() / 1000.0 * (max - min);
            this.value.setText(this.tok + "=" + (float)val);
            FunctionGymnastics.this.vt.setValue(this.tok, val);
            this.scrollbar.setToolTipText("" + val);
            FunctionGymnastics.this.graph.redrawAll();
        }
    }
}

