/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.properties;

import java.util.Observable;

public class Range
extends Observable {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int SCALE = 2;
    private double min;
    private double max;
    private double scl;

    public Range() {
        this(0.0, 1.0, 0.1);
    }

    public Range(double l, double r) {
        this(l, r, Double.MAX_VALUE);
    }

    public Range(double l, double r, double s) {
        this.set(l, r, s);
    }

    private void set(double l, double r, double s) {
        if (!Range.isValid(l, r, s)) {
            throw new IllegalArgumentException();
        }
        this.min = l;
        this.max = r;
        this.scl = s;
    }

    public static boolean isValid(double l, double r, double s) {
        return !Double.isNaN(l) && !Double.isNaN(r) && !Double.isNaN(s) && l < r && s > 0.0;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getScale() {
        return this.scl;
    }

    public double getWidth() {
        return Math.abs(this.max - this.min);
    }

    public double getCenter() {
        return (this.max + this.min) / 2.0;
    }

    public String toString() {
        return "[" + this.min + " to " + this.max + " by " + this.scl + "]";
    }
}

