/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.models.ColoredModel;
import net.gcalc.calc.models.Model;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.gui.CopyGraphAction;
import net.gcalc.plugin.gui.InputPanel;
import net.gcalc.plugin.gui.PrintGraphAction;
import net.gcalc.plugin.gui.PropertiesPanel;
import net.gcalc.plugin.gui.SaveGraphAction;
import net.gcalc.plugin.gui.SimpleColorChooser;
import net.gcalc.plugin.gui.TextInputPanel;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.plane.gui.AboutPluginAction;
import net.gcalc.plugin.plane.gui.ClosePluginAction;
import net.gcalc.plugin.plane.gui.CoordinatePanel;
import net.gcalc.plugin.plane.gui.FlagPanel;
import net.gcalc.plugin.plane.gui.GraphDimensionPanel;
import net.gcalc.plugin.plane.gui.ModelListPanel;
import net.gcalc.plugin.plane.gui.ShowPropertiesPanelAction;
import net.gcalc.plugin.plane.gui.ViewPanel;
import net.gcalc.plugin.plane.gui.ZoomPanel;
import net.gcalc.plugin.properties.GraphProperties;

public class CartesianGraphPlugin
extends AbstractCartesianGraphPlugin
implements ActionListener {
    protected InputPanel ip;
    protected CartesianGraph graph = new CartesianGraph(this);
    protected SimpleColorChooser colorChooser;
    protected JLabel statusBar;

    protected JPanel makeGraphDimensionPanel() {
        return new GraphDimensionPanel(this.graph.getProperties());
    }

    protected JPanel makeFlagPanel() {
        return new FlagPanel(this.graph.getProperties(), 7, 2, new String[]{GraphProperties.TRACE, GraphProperties.THICK_GRAPH, GraphProperties.H_GRID, GraphProperties.V_GRID, GraphProperties.H_AXIS, GraphProperties.V_AXIS, GraphProperties.H_LABEL, GraphProperties.V_LABEL, GraphProperties.H_SCALE, GraphProperties.V_SCALE, GraphProperties.H_TITLE, GraphProperties.V_TITLE, GraphProperties.SHOW_CONCAVITY, GraphProperties.SHOW_MONOTONICITY});
    }

    protected JPanel makeViewPanel() {
        return new ViewPanel(this.graph.getProperties());
    }

    protected JPanel makeZoomPanel() {
        return new ZoomPanel(this.graph.getProperties());
    }

    protected JPanel makeModelListPanel() {
        return new ModelListPanel(this.graph.getProperties());
    }

    protected Color firstColor() {
        return Color.black;
    }

    protected void initPropertiesPanel() {
        JPanel flagPanel = this.makeFlagPanel();
        Box viewPanel = SwingGUI.wrap(this.makeViewPanel());
        JPanel functionListPanel = this.makeModelListPanel();
        this.colorChooser = new SimpleColorChooser(this.firstColor());
        PropertiesPanel propertiesPanel = this.getPropertiesPanel();
        propertiesPanel.addTab("Graphs", functionListPanel);
        propertiesPanel.addTab("Properties", flagPanel);
        propertiesPanel.addTab("View", viewPanel);
        propertiesPanel.addTab("Screen", this.makeGraphDimensionPanel());
    }

    protected void initMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu plugin = new JMenu("Plugin");
        JMenu edit = new JMenu("Edit");
        JMenu help = new JMenu("Help");
        JMenuItem save = new JMenuItem(new SaveGraphAction(this, this.graph));
        JMenuItem print = new JMenuItem(new PrintGraphAction(this, this.graph));
        JMenuItem quit = new JMenuItem(new ClosePluginAction(this));
        JMenuItem showProperties = new JMenuItem(new ShowPropertiesPanelAction(this));
        JMenuItem about = new JMenuItem(new AboutPluginAction(this));
        JMenuItem copy = new JMenuItem(new CopyGraphAction(this, this.graph));
        menuBar.add(plugin);
        menuBar.add(edit);
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(help);
        plugin.add(save);
        plugin.addSeparator();
        plugin.add(print);
        plugin.addSeparator();
        plugin.add(quit);
        help.add(about);
        edit.add(copy);
        edit.addSeparator();
        edit.add(showProperties);
        this.setJMenuBar(menuBar);
    }

    protected InputPanel getInputPanel() {
        return new TextInputPanel("Input", this.getModelLabels(), null);
    }

    protected Component getCenter() {
        this.ip = this.getInputPanel();
        if (this.ip != null) {
            this.ip.addActionListener(this);
        }
        CoordinatePanel cp = new CoordinatePanel(2);
        this.graph.setCoordinatePanel(cp);
        Box graphBox = Box.createVerticalBox();
        graphBox.add(this.graph);
        graphBox.add(cp);
        Box mainBox = Box.createVerticalBox();
        if (this.ip != null) {
            mainBox.add(this.ip);
        }
        mainBox.add(SwingGUI.wrapTitledBorder(graphBox, "Graph"));
        JPanel uberBox = new JPanel(new BorderLayout());
        uberBox.add((Component)mainBox, "North");
        uberBox.add((Component)new JPanel(), "Center");
        return uberBox;
    }

    public void init() {
        this.initPropertiesPanel();
        this.initMenuBar();
        this.statusBar = new JLabel(" ");
        this.statusBar.setBorder(new EtchedBorder(1));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add("Center", this.getCenter());
        this.getContentPane().add("South", this.statusBar);
        this.showPropertiesPanel(true);
        this.setTitle(this.getPluginName());
        this.pack();
        this.setInitialized(true);
    }

    public String getCreatorName() {
        return "Jiho Kim (jiho@gcalc.net)";
    }

    public String getDescription() {
        return "<p>Simple Graph plugin.</p>";
    }

    public String getPluginName() {
        return "Graph Plugin";
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.ip) {
            String s = this.ip.getValues()[0].trim();
            Function f = null;
            try {
                f = FunctionFactory.getFunction(s);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s + "'!\n" + e.getMessage(), 0);
                return;
            }
            if (f != null) {
                this.drawGraph(f, s);
                this.statusBar.setText("Graphing: " + s);
            }
        }
    }

    protected void drawGraph(Function f, String s) {
        Color color = this.getNewColor();
        this.graph.draw((Model)new ColoredModel(f, s, color));
        this.ip.addCurrentValuesToHistory();
        this.ip.clear();
    }

    protected Color getNewColor() {
        Color color = this.colorChooser.getColor();
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsb[0] = hsb[0] + 0.2857143f;
        if (hsb[0] > 1.0f) {
            hsb[0] = hsb[0] - 1.0f;
        }
        this.colorChooser.setColor(Color.getHSBColor(hsb[0], 0.9f, 0.8f));
        return color;
    }
}

