/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdException;
import org.jrobin.mrtg.MrtgConstants;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.server.Config;
import org.jrobin.mrtg.server.Device;
import org.jrobin.mrtg.server.DeviceList;
import org.jrobin.mrtg.server.Listener;
import org.jrobin.mrtg.server.Plotter;
import org.jrobin.mrtg.server.RrdWriter;
import org.jrobin.mrtg.server.Timer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Server
implements MrtgConstants {
    private static Server instance;
    private DeviceList deviceList;
    private Date startDate;
    private Timer timer;
    private RrdWriter rrdWriter;
    private Listener listener;
    private boolean active = false;

    public static synchronized Server getInstance() {
        if (instance == null) {
            instance = new Server();
        }
        return instance;
    }

    private Server() {
        RrdDb.setLockMode((int)0);
        RrdDbPool.getInstance().setCapacity(100);
    }

    public synchronized void start(String[] stringArray) throws MrtgException {
        if (this.active) {
            throw new MrtgException("Cannot start Server, already started");
        }
        try {
            RrdDb.setDefaultFactory((String)"NIO");
        }
        catch (RrdException rrdException) {
            throw new MrtgException("Inavlide backend factory (NIO)");
        }
        try {
            this.createXmlTemplateIfNecessary(Config.getRrdTemplateFile(), "<rrd_def>                                 \n    <path>${path}</path>                  \n    <step>300</step>                      \n    <datasource>                          \n        <name>in</name>                   \n        <type>COUNTER</type>              \n        <heartbeat>6000</heartbeat>       \n        <min>U</min>                      \n        <max>U</max>                      \n    </datasource>                         \n    <datasource>                          \n        <name>out</name>                  \n        <type>COUNTER</type>              \n        <heartbeat>6000</heartbeat>       \n        <min>U</min>                      \n        <max>U</max>                      \n    </datasource>                         \n    <archive>                             \n        <cf>AVERAGE</cf>                  \n        <xff>0.5</xff>                    \n        <steps>1</steps>                  \n        <rows>600</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>AVERAGE</cf>                  \n        <xff>0.5</xff>                    \n        <steps>6</steps>                  \n        <rows>700</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>AVERAGE</cf>                  \n        <xff>0.5</xff>                    \n        <steps>24</steps>                 \n        <rows>775</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>AVERAGE</cf>                  \n        <xff>0.5</xff>                    \n        <steps>288</steps>                \n        <rows>797</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>MAX</cf>                      \n        <xff>0.5</xff>                    \n        <steps>1</steps>                  \n        <rows>600</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>MAX</cf>                      \n        <xff>0.5</xff>                    \n        <steps>6</steps>                  \n        <rows>700</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>MAX</cf>                      \n        <xff>0.5</xff>                    \n        <steps>24</steps>                 \n        <rows>775</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>MAX</cf>                      \n        <xff>0.5</xff>                    \n        <steps>288</steps>                \n        <rows>797</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>MIN</cf>                      \n        <xff>0.5</xff>                    \n        <steps>1</steps>                  \n        <rows>600</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>MIN</cf>                      \n        <xff>0.5</xff>                    \n        <steps>6</steps>                  \n        <rows>700</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>MIN</cf>                      \n        <xff>0.5</xff>                    \n        <steps>24</steps>                 \n        <rows>775</rows>                  \n    </archive>                            \n    <archive>                             \n        <cf>MIN</cf>                      \n        <xff>0.5</xff>                    \n        <steps>288</steps>                \n        <rows>797</rows>                  \n    </archive>                            \n</rrd_def>                                ");
            this.createXmlTemplateIfNecessary(Config.getGraphTemplateFile(), "<rrd_graph_def>                                                          \n    <span>                                                               \n        <start>${start}</start>                                          \n        <end>${end}</end>                                                \n    </span>                                                              \n    <options>                                                            \n        <anti_aliasing>off</anti_aliasing>                               \n        <border>                                                         \n            <color>#FFFFFF</color>                                       \n            <width>0</width>                                             \n        </border>                                                        \n        <title>${interface} at ${host}</title>                           \n        <vertical_label>transfer speed [bits/sec]</vertical_label>       \n    </options>                                                           \n    <datasources>                                                        \n        <def>                                                            \n            <name>in</name>                                              \n            <rrd>${rrd}</rrd>                                            \n            <source>in</source>                                          \n            <cf>AVERAGE</cf>                                             \n        </def>                                                           \n        <def>                                                            \n            <name>out</name>                                             \n            <rrd>${rrd}</rrd>                                            \n            <source>out</source>                                         \n            <cf>AVERAGE</cf>                                             \n        </def>                                                           \n        <def>                                                            \n            <name>in8</name>                                             \n            <rpn>in,8,*</rpn>                                            \n        </def>                                                           \n        <def>                                                            \n            <name>out8</name>                                            \n            <rpn>out,8,*</rpn>                                           \n        </def>                                                           \n    </datasources>                                                       \n    <graph>                                                              \n        <area>                                                           \n            <datasource>out8</datasource>                                \n            <color>#00FF00</color>                                       \n            <legend>output traffic</legend>                              \n        </area>                                                          \n        <line>                                                           \n            <datasource>in8</datasource>                                 \n            <color>#0000FF</color>                                       \n            <legend>input traffic@l</legend>                             \n        </line>                                                          \n        <gprint>                                                         \n            <datasource>out8</datasource>                                \n            <cf>AVERAGE</cf>                                             \n            <format>Average output:@7.2 @sbits/s</format>                \n        </gprint>                                                        \n        <gprint>                                                         \n            <datasource>out8</datasource>                                \n            <cf>MAX</cf>                                                 \n            <format>Maximum output:@7.2 @Sbits/s</format>                \n        </gprint>                                                        \n        <gprint>                                                         \n            <datasource>out</datasource>                                 \n            <cf>TOTAL</cf>                                               \n            <format>Total output:@7.2 @sbytes@l</format>                 \n            <base>1024</base>                                            \n        </gprint>                                                        \n        <gprint>                                                         \n            <datasource>in8</datasource>                                 \n            <cf>AVERAGE</cf>                                             \n            <format>Average input: @7.2 @sbits/s</format>                \n        </gprint>                                                        \n        <gprint>                                                         \n            <datasource>in8</datasource>                                 \n            <cf>MAX</cf>                                                 \n            <format>Maximum input: @7.2 @Sbits/s</format>                \n        </gprint>                                                        \n        <gprint>                                                         \n            <datasource>in</datasource>                                  \n            <cf>TOTAL</cf>                                               \n            <format>Total input :@7.2 @sbytes@l</format>                 \n            <base>1024</base>                                            \n        </gprint>                                                        \n        <comment>@l</comment>                                            \n        <comment>Description on device: ${alias}@l</comment>             \n        <comment>[${date_start}] -- [${date_end}]</comment>              \n    </graph>                                                             \n</rrd_graph_def>                                                         ");
        }
        catch (IOException iOException) {
            throw new MrtgException(iOException);
        }
        String string = Config.getHardwareFile();
        if (new File(string).exists()) {
            this.loadHardware();
        } else {
            this.saveHardware();
        }
        this.rrdWriter = new RrdWriter();
        this.timer = new Timer();
        this.listener = new Listener(stringArray);
        this.startDate = new Date();
        this.active = true;
    }

    private void createXmlTemplateIfNecessary(String string, String string2) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            FileWriter fileWriter = new FileWriter(string, false);
            fileWriter.write(string2);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    public synchronized void stop() throws MrtgException {
        if (!this.active) {
            throw new MrtgException("Cannot stop Server, not started");
        }
        this.rrdWriter.terminate();
        this.timer.terminate();
        this.listener.terminate();
        this.active = false;
        try {
            RrdDbPool.getInstance().reset();
        }
        catch (IOException iOException) {
            throw new MrtgException(iOException);
        }
    }

    void saveHardware() throws MrtgException {
        if (this.deviceList == null) {
            this.deviceList = new DeviceList();
        }
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("mrtg");
            document.appendChild(element);
            Vector vector = this.deviceList.getRouters();
            for (int i = 0; i < vector.size(); ++i) {
                object = (Device)vector.get(i);
                ((Device)object).appendXml(element);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            object = transformerFactory.newTransformer();
            ((Transformer)object).setOutputProperty("omit-xml-declaration", "no");
            ((Transformer)object).setOutputProperty("method", "xml");
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).setOutputProperty("media-type", "text/xml");
            ((Transformer)object).setOutputProperty("standalone", "yes");
            DOMSource dOMSource = new DOMSource(element);
            FileOutputStream fileOutputStream = new FileOutputStream(Config.getHardwareFile());
            StreamResult streamResult = new StreamResult(fileOutputStream);
            ((Transformer)object).transform(dOMSource, streamResult);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new MrtgException(exception);
        }
    }

    private void loadHardware() throws MrtgException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(Config.getHardwareFile()));
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("router");
            this.deviceList = new DeviceList();
            Vector vector = this.deviceList.getRouters();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                vector.add(new Device(nodeList.item(i)));
            }
        }
        catch (Exception exception) {
            throw new MrtgException(exception);
        }
    }

    public String toString() {
        return this.deviceList.toString();
    }

    synchronized int addRouter(String string, String string2, String string3, boolean bl) throws MrtgException {
        int n = this.deviceList.addRouter(string, string2, string3, bl);
        if (n == 0) {
            this.saveHardware();
        }
        return n;
    }

    synchronized int updateRouter(String string, String string2, String string3, boolean bl) throws MrtgException {
        int n = this.deviceList.updateRouter(string, string2, string3, bl);
        if (n == 0) {
            this.saveHardware();
        }
        return n;
    }

    synchronized int removeRouter(String string) throws MrtgException {
        int n = this.deviceList.removeRouter(string);
        if (n == 0) {
            this.saveHardware();
        }
        return n;
    }

    synchronized int addLink(String string, String string2, String string3, int n, boolean bl) throws MrtgException {
        int n2 = this.deviceList.addLink(string, string2, string3, n, bl);
        if (n2 == 0) {
            this.saveHardware();
        }
        return n2;
    }

    synchronized int updateLink(String string, String string2, String string3, int n, boolean bl) throws MrtgException {
        int n2 = this.deviceList.updateLink(string, string2, string3, n, bl);
        if (n2 == 0) {
            this.saveHardware();
        }
        return n2;
    }

    synchronized int removeLink(String string, String string2) throws MrtgException {
        int n = this.deviceList.removeLink(string, string2);
        if (n == 0) {
            this.saveHardware();
            String string3 = RrdWriter.getRrdFilename(string, string2);
            new File(string3).delete();
        }
        return n;
    }

    synchronized byte[] getPngGraph(String string, String string2, long l, long l2) throws MrtgException {
        Plotter plotter = new Plotter(string, string2);
        return plotter.getPngGraphBytes(l, l2);
    }

    synchronized Device[] getRouters() {
        return this.deviceList.getRouters().toArray(new Device[0]);
    }

    String[] getAvailableLinks(String string) throws MrtgException {
        Device device = this.deviceList.getRouterByHost(string);
        try {
            if (device != null) {
                return device.getAvailableLinks();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new MrtgException(iOException);
        }
    }

    DeviceList getDeviceList() {
        return this.deviceList;
    }

    RrdWriter getRrdWriter() {
        return this.rrdWriter;
    }

    Date getStartDate() {
        return this.startDate;
    }

    Hashtable getServerInfo() {
        Hashtable<String, Comparable<Integer>> hashtable = new Hashtable<String, Comparable<Integer>>();
        hashtable.put("sampleCount", new Integer(this.rrdWriter.getSampleCount()));
        hashtable.put("savesCount", new Integer(this.rrdWriter.getSavesCount()));
        hashtable.put("goodSavesCount", new Integer(this.rrdWriter.getGoodSavesCount()));
        hashtable.put("badSavesCount", new Integer(this.rrdWriter.getBadSavesCount()));
        hashtable.put("startDate", this.startDate);
        hashtable.put("poolEfficency", new Double(RrdDbPool.getInstance().getPoolEfficency()));
        return hashtable;
    }

    public static void main(String[] stringArray) throws Exception {
        Server server = Server.getInstance();
        server.start(stringArray);
    }
}

