// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/scheduler/v1/cloudscheduler.proto

#include "google/cloud/scheduler/v1/internal/cloud_scheduler_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/scheduler/v1/cloudscheduler.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace scheduler_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudSchedulerLogging::CloudSchedulerLogging(
    std::shared_ptr<CloudSchedulerStub> child, TracingOptions tracing_options,
    std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::scheduler::v1::ListJobsResponse>
CloudSchedulerLogging::ListJobs(
    grpc::ClientContext& context,
    google::cloud::scheduler::v1::ListJobsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::scheduler::v1::ListJobsRequest const& request) {
        return child_->ListJobs(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::scheduler::v1::Job> CloudSchedulerLogging::GetJob(
    grpc::ClientContext& context,
    google::cloud::scheduler::v1::GetJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::scheduler::v1::GetJobRequest const& request) {
        return child_->GetJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::scheduler::v1::Job> CloudSchedulerLogging::CreateJob(
    grpc::ClientContext& context,
    google::cloud::scheduler::v1::CreateJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::scheduler::v1::CreateJobRequest const& request) {
        return child_->CreateJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::scheduler::v1::Job> CloudSchedulerLogging::UpdateJob(
    grpc::ClientContext& context,
    google::cloud::scheduler::v1::UpdateJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::scheduler::v1::UpdateJobRequest const& request) {
        return child_->UpdateJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status CloudSchedulerLogging::DeleteJob(
    grpc::ClientContext& context,
    google::cloud::scheduler::v1::DeleteJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::scheduler::v1::DeleteJobRequest const& request) {
        return child_->DeleteJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::scheduler::v1::Job> CloudSchedulerLogging::PauseJob(
    grpc::ClientContext& context,
    google::cloud::scheduler::v1::PauseJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::scheduler::v1::PauseJobRequest const& request) {
        return child_->PauseJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::scheduler::v1::Job> CloudSchedulerLogging::ResumeJob(
    grpc::ClientContext& context,
    google::cloud::scheduler::v1::ResumeJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::scheduler::v1::ResumeJobRequest const& request) {
        return child_->ResumeJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::scheduler::v1::Job> CloudSchedulerLogging::RunJob(
    grpc::ClientContext& context,
    google::cloud::scheduler::v1::RunJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::scheduler::v1::RunJobRequest const& request) {
        return child_->RunJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace scheduler_v1_internal
}  // namespace cloud
}  // namespace google
