// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

#include "google/cloud/migrationcenter/v1/internal/migration_center_option_defaults.h"
#include "google/cloud/migrationcenter/v1/migration_center_connection.h"
#include "google/cloud/migrationcenter/v1/migration_center_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace migrationcenter_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options MigrationCenterDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_MIGRATION_CENTER_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_MIGRATION_CENTER_AUTHORITY",
      "migrationcenter.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<migrationcenter_v1::MigrationCenterRetryPolicyOption>()) {
    options.set<migrationcenter_v1::MigrationCenterRetryPolicyOption>(
        migrationcenter_v1::MigrationCenterLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<migrationcenter_v1::MigrationCenterBackoffPolicyOption>()) {
    options.set<migrationcenter_v1::MigrationCenterBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<migrationcenter_v1::MigrationCenterPollingPolicyOption>()) {
    options.set<migrationcenter_v1::MigrationCenterPollingPolicyOption>(
        GenericPollingPolicy<
            migrationcenter_v1::MigrationCenterRetryPolicyOption::Type,
            migrationcenter_v1::MigrationCenterBackoffPolicyOption::Type>(
            options.get<migrationcenter_v1::MigrationCenterRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<migrationcenter_v1::
                       MigrationCenterConnectionIdempotencyPolicyOption>()) {
    options.set<
        migrationcenter_v1::MigrationCenterConnectionIdempotencyPolicyOption>(
        migrationcenter_v1::
            MakeDefaultMigrationCenterConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace migrationcenter_v1_internal
}  // namespace cloud
}  // namespace google
