// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/config/v1/config.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIG_V1_INTERNAL_CONFIG_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIG_V1_INTERNAL_CONFIG_TRACING_CONNECTION_H

#include "google/cloud/config/v1/config_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace config_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ConfigTracingConnection : public config_v1::ConfigConnection {
 public:
  ~ConfigTracingConnection() override = default;

  explicit ConfigTracingConnection(
      std::shared_ptr<config_v1::ConfigConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::config::v1::Deployment> ListDeployments(
      google::cloud::config::v1::ListDeploymentsRequest request) override;

  StatusOr<google::cloud::config::v1::Deployment> GetDeployment(
      google::cloud::config::v1::GetDeploymentRequest const& request) override;

  future<StatusOr<google::cloud::config::v1::Deployment>> CreateDeployment(
      google::cloud::config::v1::CreateDeploymentRequest const& request)
      override;

  future<StatusOr<google::cloud::config::v1::Deployment>> UpdateDeployment(
      google::cloud::config::v1::UpdateDeploymentRequest const& request)
      override;

  future<StatusOr<google::cloud::config::v1::Deployment>> DeleteDeployment(
      google::cloud::config::v1::DeleteDeploymentRequest const& request)
      override;

  StreamRange<google::cloud::config::v1::Revision> ListRevisions(
      google::cloud::config::v1::ListRevisionsRequest request) override;

  StatusOr<google::cloud::config::v1::Revision> GetRevision(
      google::cloud::config::v1::GetRevisionRequest const& request) override;

  StatusOr<google::cloud::config::v1::Resource> GetResource(
      google::cloud::config::v1::GetResourceRequest const& request) override;

  StreamRange<google::cloud::config::v1::Resource> ListResources(
      google::cloud::config::v1::ListResourcesRequest request) override;

  StatusOr<google::cloud::config::v1::Statefile> ExportDeploymentStatefile(
      google::cloud::config::v1::ExportDeploymentStatefileRequest const&
          request) override;

  StatusOr<google::cloud::config::v1::Statefile> ExportRevisionStatefile(
      google::cloud::config::v1::ExportRevisionStatefileRequest const& request)
      override;

  StatusOr<google::cloud::config::v1::Statefile> ImportStatefile(
      google::cloud::config::v1::ImportStatefileRequest const& request)
      override;

  Status DeleteStatefile(
      google::cloud::config::v1::DeleteStatefileRequest const& request)
      override;

  future<StatusOr<google::cloud::config::v1::Deployment>> LockDeployment(
      google::cloud::config::v1::LockDeploymentRequest const& request) override;

  future<StatusOr<google::cloud::config::v1::Deployment>> UnlockDeployment(
      google::cloud::config::v1::UnlockDeploymentRequest const& request)
      override;

  StatusOr<google::cloud::config::v1::LockInfo> ExportLockInfo(
      google::cloud::config::v1::ExportLockInfoRequest const& request) override;

 private:
  std::shared_ptr<config_v1::ConfigConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<config_v1::ConfigConnection> MakeConfigTracingConnection(
    std::shared_ptr<config_v1::ConfigConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace config_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIG_V1_INTERNAL_CONFIG_TRACING_CONNECTION_H
