// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/llm_utility_service.proto

#include "google/cloud/aiplatform/v1/llm_utility_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

LlmUtilityServiceClient::LlmUtilityServiceClient(
    std::shared_ptr<LlmUtilityServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
LlmUtilityServiceClient::~LlmUtilityServiceClient() = default;

StatusOr<google::cloud::aiplatform::v1::CountTokensResponse>
LlmUtilityServiceClient::CountTokens(
    std::string const& endpoint,
    std::vector<google::protobuf::Value> const& instances, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CountTokensRequest request;
  request.set_endpoint(endpoint);
  *request.mutable_instances() = {instances.begin(), instances.end()};
  return connection_->CountTokens(request);
}

StatusOr<google::cloud::aiplatform::v1::CountTokensResponse>
LlmUtilityServiceClient::CountTokens(
    google::cloud::aiplatform::v1::CountTokensRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CountTokens(request);
}

StatusOr<google::cloud::aiplatform::v1::ComputeTokensResponse>
LlmUtilityServiceClient::ComputeTokens(
    std::string const& endpoint,
    std::vector<google::protobuf::Value> const& instances, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ComputeTokensRequest request;
  request.set_endpoint(endpoint);
  *request.mutable_instances() = {instances.begin(), instances.end()};
  return connection_->ComputeTokens(request);
}

StatusOr<google::cloud::aiplatform::v1::ComputeTokensResponse>
LlmUtilityServiceClient::ComputeTokens(
    google::cloud::aiplatform::v1::ComputeTokensRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ComputeTokens(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
