// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/extension_feed_item.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An extension feed item.
type ExtensionFeedItem struct {
	// Immutable. The resource name of the extension feed item.
	// Extension feed item resource names have the form:
	//
	// `customers/{customer_id}/extensionFeedItems/{feed_item_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of this feed item. Read-only.
	Id *wrappers.Int64Value `protobuf:"bytes,24,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The extension type of the extension feed item.
	// This field is read-only.
	ExtensionType enums.ExtensionTypeEnum_ExtensionType `protobuf:"varint,13,opt,name=extension_type,json=extensionType,proto3,enum=google.ads.googleads.v2.enums.ExtensionTypeEnum_ExtensionType" json:"extension_type,omitempty"`
	// Start time in which this feed item is effective and can begin serving. The
	// time is in the customer's time zone.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	StartDateTime *wrappers.StringValue `protobuf:"bytes,5,opt,name=start_date_time,json=startDateTime,proto3" json:"start_date_time,omitempty"`
	// End time in which this feed item is no longer effective and will stop
	// serving. The time is in the customer's time zone.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	EndDateTime *wrappers.StringValue `protobuf:"bytes,6,opt,name=end_date_time,json=endDateTime,proto3" json:"end_date_time,omitempty"`
	// List of non-overlapping schedules specifying all time intervals
	// for which the feed item may serve. There can be a maximum of 6 schedules
	// per day.
	AdSchedules []*common.AdScheduleInfo `protobuf:"bytes,16,rep,name=ad_schedules,json=adSchedules,proto3" json:"ad_schedules,omitempty"`
	// The targeted device.
	Device enums.FeedItemTargetDeviceEnum_FeedItemTargetDevice `protobuf:"varint,17,opt,name=device,proto3,enum=google.ads.googleads.v2.enums.FeedItemTargetDeviceEnum_FeedItemTargetDevice" json:"device,omitempty"`
	// The targeted geo target constant.
	TargetedGeoTargetConstant *wrappers.StringValue `protobuf:"bytes,20,opt,name=targeted_geo_target_constant,json=targetedGeoTargetConstant,proto3" json:"targeted_geo_target_constant,omitempty"`
	// The targeted keyword.
	TargetedKeyword *common.KeywordInfo `protobuf:"bytes,22,opt,name=targeted_keyword,json=targetedKeyword,proto3" json:"targeted_keyword,omitempty"`
	// Output only. Status of the feed item.
	// This field is read-only.
	Status enums.FeedItemStatusEnum_FeedItemStatus `protobuf:"varint,4,opt,name=status,proto3,enum=google.ads.googleads.v2.enums.FeedItemStatusEnum_FeedItemStatus" json:"status,omitempty"`
	// Extension type.
	//
	// Types that are valid to be assigned to Extension:
	//	*ExtensionFeedItem_SitelinkFeedItem
	//	*ExtensionFeedItem_StructuredSnippetFeedItem
	//	*ExtensionFeedItem_AppFeedItem
	//	*ExtensionFeedItem_CallFeedItem
	//	*ExtensionFeedItem_CalloutFeedItem
	//	*ExtensionFeedItem_TextMessageFeedItem
	//	*ExtensionFeedItem_PriceFeedItem
	//	*ExtensionFeedItem_PromotionFeedItem
	//	*ExtensionFeedItem_LocationFeedItem
	//	*ExtensionFeedItem_AffiliateLocationFeedItem
	//	*ExtensionFeedItem_HotelCalloutFeedItem
	Extension isExtensionFeedItem_Extension `protobuf_oneof:"extension"`
	// Targeting at either the campaign or ad group level. Feed items that target
	// a campaign or ad group will only serve with that resource.
	//
	// Types that are valid to be assigned to ServingResourceTargeting:
	//	*ExtensionFeedItem_TargetedCampaign
	//	*ExtensionFeedItem_TargetedAdGroup
	ServingResourceTargeting isExtensionFeedItem_ServingResourceTargeting `protobuf_oneof:"serving_resource_targeting"`
	XXX_NoUnkeyedLiteral     struct{}                                     `json:"-"`
	XXX_unrecognized         []byte                                       `json:"-"`
	XXX_sizecache            int32                                        `json:"-"`
}

func (m *ExtensionFeedItem) Reset()         { *m = ExtensionFeedItem{} }
func (m *ExtensionFeedItem) String() string { return proto.CompactTextString(m) }
func (*ExtensionFeedItem) ProtoMessage()    {}
func (*ExtensionFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_84144755971e2200, []int{0}
}

func (m *ExtensionFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExtensionFeedItem.Unmarshal(m, b)
}
func (m *ExtensionFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExtensionFeedItem.Marshal(b, m, deterministic)
}
func (m *ExtensionFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtensionFeedItem.Merge(m, src)
}
func (m *ExtensionFeedItem) XXX_Size() int {
	return xxx_messageInfo_ExtensionFeedItem.Size(m)
}
func (m *ExtensionFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtensionFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_ExtensionFeedItem proto.InternalMessageInfo

func (m *ExtensionFeedItem) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *ExtensionFeedItem) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *ExtensionFeedItem) GetExtensionType() enums.ExtensionTypeEnum_ExtensionType {
	if m != nil {
		return m.ExtensionType
	}
	return enums.ExtensionTypeEnum_UNSPECIFIED
}

func (m *ExtensionFeedItem) GetStartDateTime() *wrappers.StringValue {
	if m != nil {
		return m.StartDateTime
	}
	return nil
}

func (m *ExtensionFeedItem) GetEndDateTime() *wrappers.StringValue {
	if m != nil {
		return m.EndDateTime
	}
	return nil
}

func (m *ExtensionFeedItem) GetAdSchedules() []*common.AdScheduleInfo {
	if m != nil {
		return m.AdSchedules
	}
	return nil
}

func (m *ExtensionFeedItem) GetDevice() enums.FeedItemTargetDeviceEnum_FeedItemTargetDevice {
	if m != nil {
		return m.Device
	}
	return enums.FeedItemTargetDeviceEnum_UNSPECIFIED
}

func (m *ExtensionFeedItem) GetTargetedGeoTargetConstant() *wrappers.StringValue {
	if m != nil {
		return m.TargetedGeoTargetConstant
	}
	return nil
}

func (m *ExtensionFeedItem) GetTargetedKeyword() *common.KeywordInfo {
	if m != nil {
		return m.TargetedKeyword
	}
	return nil
}

func (m *ExtensionFeedItem) GetStatus() enums.FeedItemStatusEnum_FeedItemStatus {
	if m != nil {
		return m.Status
	}
	return enums.FeedItemStatusEnum_UNSPECIFIED
}

type isExtensionFeedItem_Extension interface {
	isExtensionFeedItem_Extension()
}

type ExtensionFeedItem_SitelinkFeedItem struct {
	SitelinkFeedItem *common.SitelinkFeedItem `protobuf:"bytes,2,opt,name=sitelink_feed_item,json=sitelinkFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_StructuredSnippetFeedItem struct {
	StructuredSnippetFeedItem *common.StructuredSnippetFeedItem `protobuf:"bytes,3,opt,name=structured_snippet_feed_item,json=structuredSnippetFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_AppFeedItem struct {
	AppFeedItem *common.AppFeedItem `protobuf:"bytes,7,opt,name=app_feed_item,json=appFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_CallFeedItem struct {
	CallFeedItem *common.CallFeedItem `protobuf:"bytes,8,opt,name=call_feed_item,json=callFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_CalloutFeedItem struct {
	CalloutFeedItem *common.CalloutFeedItem `protobuf:"bytes,9,opt,name=callout_feed_item,json=calloutFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_TextMessageFeedItem struct {
	TextMessageFeedItem *common.TextMessageFeedItem `protobuf:"bytes,10,opt,name=text_message_feed_item,json=textMessageFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_PriceFeedItem struct {
	PriceFeedItem *common.PriceFeedItem `protobuf:"bytes,11,opt,name=price_feed_item,json=priceFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_PromotionFeedItem struct {
	PromotionFeedItem *common.PromotionFeedItem `protobuf:"bytes,12,opt,name=promotion_feed_item,json=promotionFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_LocationFeedItem struct {
	LocationFeedItem *common.LocationFeedItem `protobuf:"bytes,14,opt,name=location_feed_item,json=locationFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_AffiliateLocationFeedItem struct {
	AffiliateLocationFeedItem *common.AffiliateLocationFeedItem `protobuf:"bytes,15,opt,name=affiliate_location_feed_item,json=affiliateLocationFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_HotelCalloutFeedItem struct {
	HotelCalloutFeedItem *common.HotelCalloutFeedItem `protobuf:"bytes,23,opt,name=hotel_callout_feed_item,json=hotelCalloutFeedItem,proto3,oneof"`
}

func (*ExtensionFeedItem_SitelinkFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_StructuredSnippetFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_AppFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_CallFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_CalloutFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_TextMessageFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_PriceFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_PromotionFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_LocationFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_AffiliateLocationFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_HotelCalloutFeedItem) isExtensionFeedItem_Extension() {}

func (m *ExtensionFeedItem) GetExtension() isExtensionFeedItem_Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

func (m *ExtensionFeedItem) GetSitelinkFeedItem() *common.SitelinkFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_SitelinkFeedItem); ok {
		return x.SitelinkFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetStructuredSnippetFeedItem() *common.StructuredSnippetFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_StructuredSnippetFeedItem); ok {
		return x.StructuredSnippetFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetAppFeedItem() *common.AppFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_AppFeedItem); ok {
		return x.AppFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetCallFeedItem() *common.CallFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_CallFeedItem); ok {
		return x.CallFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetCalloutFeedItem() *common.CalloutFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_CalloutFeedItem); ok {
		return x.CalloutFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetTextMessageFeedItem() *common.TextMessageFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_TextMessageFeedItem); ok {
		return x.TextMessageFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetPriceFeedItem() *common.PriceFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_PriceFeedItem); ok {
		return x.PriceFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetPromotionFeedItem() *common.PromotionFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_PromotionFeedItem); ok {
		return x.PromotionFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetLocationFeedItem() *common.LocationFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_LocationFeedItem); ok {
		return x.LocationFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetAffiliateLocationFeedItem() *common.AffiliateLocationFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_AffiliateLocationFeedItem); ok {
		return x.AffiliateLocationFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetHotelCalloutFeedItem() *common.HotelCalloutFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_HotelCalloutFeedItem); ok {
		return x.HotelCalloutFeedItem
	}
	return nil
}

type isExtensionFeedItem_ServingResourceTargeting interface {
	isExtensionFeedItem_ServingResourceTargeting()
}

type ExtensionFeedItem_TargetedCampaign struct {
	TargetedCampaign *wrappers.StringValue `protobuf:"bytes,18,opt,name=targeted_campaign,json=targetedCampaign,proto3,oneof"`
}

type ExtensionFeedItem_TargetedAdGroup struct {
	TargetedAdGroup *wrappers.StringValue `protobuf:"bytes,19,opt,name=targeted_ad_group,json=targetedAdGroup,proto3,oneof"`
}

func (*ExtensionFeedItem_TargetedCampaign) isExtensionFeedItem_ServingResourceTargeting() {}

func (*ExtensionFeedItem_TargetedAdGroup) isExtensionFeedItem_ServingResourceTargeting() {}

func (m *ExtensionFeedItem) GetServingResourceTargeting() isExtensionFeedItem_ServingResourceTargeting {
	if m != nil {
		return m.ServingResourceTargeting
	}
	return nil
}

func (m *ExtensionFeedItem) GetTargetedCampaign() *wrappers.StringValue {
	if x, ok := m.GetServingResourceTargeting().(*ExtensionFeedItem_TargetedCampaign); ok {
		return x.TargetedCampaign
	}
	return nil
}

func (m *ExtensionFeedItem) GetTargetedAdGroup() *wrappers.StringValue {
	if x, ok := m.GetServingResourceTargeting().(*ExtensionFeedItem_TargetedAdGroup); ok {
		return x.TargetedAdGroup
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExtensionFeedItem) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExtensionFeedItem_SitelinkFeedItem)(nil),
		(*ExtensionFeedItem_StructuredSnippetFeedItem)(nil),
		(*ExtensionFeedItem_AppFeedItem)(nil),
		(*ExtensionFeedItem_CallFeedItem)(nil),
		(*ExtensionFeedItem_CalloutFeedItem)(nil),
		(*ExtensionFeedItem_TextMessageFeedItem)(nil),
		(*ExtensionFeedItem_PriceFeedItem)(nil),
		(*ExtensionFeedItem_PromotionFeedItem)(nil),
		(*ExtensionFeedItem_LocationFeedItem)(nil),
		(*ExtensionFeedItem_AffiliateLocationFeedItem)(nil),
		(*ExtensionFeedItem_HotelCalloutFeedItem)(nil),
		(*ExtensionFeedItem_TargetedCampaign)(nil),
		(*ExtensionFeedItem_TargetedAdGroup)(nil),
	}
}

func init() {
	proto.RegisterType((*ExtensionFeedItem)(nil), "google.ads.googleads.v2.resources.ExtensionFeedItem")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/extension_feed_item.proto", fileDescriptor_84144755971e2200)
}

var fileDescriptor_84144755971e2200 = []byte{
	// 1091 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xdd, 0x6e, 0xdc, 0x44,
	0x14, 0x66, 0x37, 0x34, 0xd0, 0xd9, 0x6c, 0x7e, 0x26, 0x55, 0xea, 0x84, 0x15, 0x24, 0x45, 0x41,
	0x11, 0xb4, 0x76, 0xd9, 0x46, 0x48, 0x6c, 0x04, 0xaa, 0x37, 0x29, 0x49, 0xa0, 0xa0, 0x74, 0x13,
	0xa5, 0x12, 0x4a, 0x65, 0x26, 0x9e, 0xb3, 0xce, 0x34, 0xf6, 0x8c, 0xf1, 0x8c, 0xd3, 0x44, 0xa5,
	0x17, 0xc0, 0x3d, 0x0f, 0xc1, 0x25, 0x8f, 0xc2, 0x53, 0xf4, 0xba, 0x8f, 0x90, 0x2b, 0xb4, 0xe3,
	0x9f, 0xf5, 0x66, 0xb3, 0xf1, 0x72, 0x37, 0x73, 0xe6, 0x7c, 0xdf, 0x77, 0xfc, 0xf9, 0xcc, 0xe8,
	0xa0, 0x0d, 0x4f, 0x08, 0xcf, 0x07, 0x8b, 0x50, 0x69, 0x25, 0xcb, 0xde, 0xea, 0xac, 0x69, 0x45,
	0x20, 0x45, 0x1c, 0xb9, 0x20, 0x2d, 0x38, 0x57, 0xc0, 0x25, 0x13, 0xdc, 0xe9, 0x02, 0x50, 0x87,
	0x29, 0x08, 0xcc, 0x30, 0x12, 0x4a, 0xe0, 0x95, 0x04, 0x61, 0x12, 0x2a, 0xcd, 0x1c, 0x6c, 0x9e,
	0x35, 0xcd, 0x1c, 0xbc, 0xf4, 0x60, 0x14, 0xbf, 0x2b, 0x82, 0x40, 0x70, 0xcb, 0x8d, 0x98, 0x82,
	0x88, 0x91, 0x84, 0x71, 0xc9, 0x2a, 0x49, 0xcf, 0x6b, 0x91, 0x29, 0xa0, 0x39, 0x0a, 0x00, 0x3c,
	0x0e, 0x8a, 0xb5, 0xab, 0x8b, 0x10, 0x52, 0xcc, 0xfa, 0xcd, 0x98, 0xfc, 0x2b, 0x1d, 0xa9, 0x88,
	0x8a, 0x33, 0xa5, 0x8d, 0x71, 0x51, 0x8a, 0x44, 0x1e, 0x28, 0x87, 0xc2, 0x19, 0x73, 0x33, 0xc9,
	0x4f, 0x32, 0x70, 0xc8, 0xac, 0x2e, 0x03, 0x9f, 0x3a, 0xc7, 0x70, 0x42, 0xce, 0x98, 0x88, 0xd2,
	0x84, 0xc5, 0x42, 0x42, 0xe6, 0x5e, 0x7a, 0xf4, 0x71, 0x7a, 0xa4, 0x77, 0xc7, 0x71, 0xd7, 0x7a,
	0x15, 0x91, 0x30, 0x84, 0x28, 0x2b, 0xac, 0x51, 0x80, 0x12, 0xce, 0x85, 0x22, 0xaa, 0x6f, 0xd0,
	0xbd, 0x3f, 0xe6, 0xd1, 0xdc, 0x93, 0xcc, 0x85, 0xef, 0x00, 0xe8, 0xae, 0x82, 0x00, 0x3f, 0x47,
	0xf5, 0x4c, 0xc5, 0xe1, 0x24, 0x00, 0xa3, 0xb2, 0x5c, 0x59, 0xbb, 0xdd, 0x6e, 0xbe, 0xb5, 0x6f,
	0x5d, 0xda, 0xf7, 0xd1, 0xe7, 0xfd, 0xbf, 0x99, 0xae, 0x42, 0x26, 0x4d, 0x57, 0x04, 0xd6, 0x10,
	0x55, 0x67, 0x2a, 0x23, 0xfa, 0x89, 0x04, 0x80, 0x1f, 0xa2, 0x2a, 0xa3, 0x86, 0xb1, 0x5c, 0x59,
	0xab, 0x35, 0x3f, 0x4a, 0xc1, 0x66, 0x56, 0xb9, 0xb9, 0xcb, 0xd5, 0x57, 0xeb, 0x87, 0xc4, 0x8f,
	0xa1, 0x3d, 0xf1, 0xd6, 0x9e, 0xe8, 0x54, 0x19, 0xc5, 0x2f, 0xd1, 0xf4, 0xe0, 0x5f, 0x32, 0xea,
	0xcb, 0x95, 0xb5, 0xe9, 0xe6, 0xb7, 0xe6, 0xa8, 0xee, 0xd2, 0x86, 0x9b, 0x79, 0x25, 0x07, 0x17,
	0x21, 0x3c, 0xe1, 0x71, 0x30, 0x18, 0x49, 0x04, 0xea, 0x50, 0x8c, 0xe1, 0x2d, 0x34, 0x23, 0x15,
	0x89, 0x94, 0x43, 0x89, 0x02, 0x47, 0xb1, 0x00, 0x8c, 0x5b, 0xba, 0xd4, 0xc6, 0x50, 0xa9, 0xfb,
	0x2a, 0x62, 0xdc, 0xd3, 0xb5, 0x76, 0xea, 0x1a, 0xb4, 0x45, 0x14, 0x1c, 0xb0, 0x00, 0xf0, 0x63,
	0x54, 0x07, 0x4e, 0x0b, 0x1c, 0x93, 0x63, 0x70, 0xd4, 0x80, 0xd3, 0x9c, 0xe1, 0x19, 0x9a, 0x22,
	0xd4, 0x91, 0xee, 0x09, 0xd0, 0xd8, 0x07, 0x69, 0xcc, 0x2e, 0x4f, 0xac, 0xd5, 0x9a, 0xe6, 0xc8,
	0x2f, 0x4e, 0xba, 0xdf, 0xb4, 0xe9, 0x7e, 0x0a, 0xd9, 0xe5, 0x5d, 0xd1, 0xa9, 0x91, 0x7c, 0x2f,
	0x31, 0x45, 0x93, 0x49, 0xc7, 0x19, 0x73, 0xda, 0xbe, 0xa7, 0x25, 0xf6, 0x65, 0xff, 0xef, 0x40,
	0x77, 0xeb, 0x96, 0x86, 0x6a, 0x17, 0xaf, 0x3b, 0xe8, 0xa4, 0xdc, 0xf8, 0xaf, 0x0a, 0x6a, 0x24,
	0xfd, 0x0d, 0xd4, 0xf1, 0x40, 0x64, 0xcd, 0xee, 0x0a, 0x2e, 0x15, 0xe1, 0xca, 0xb8, 0x53, 0x6e,
	0x45, 0xdb, 0xba, 0xb9, 0xc5, 0xb6, 0x41, 0x24, 0xda, 0x9b, 0x29, 0x69, 0x67, 0x31, 0x93, 0x1c,
	0x3a, 0xc2, 0x87, 0x68, 0x36, 0xaf, 0xe7, 0x14, 0x2e, 0x5e, 0x89, 0x88, 0x1a, 0x0b, 0xba, 0x86,
	0x2f, 0xca, 0xdc, 0xfc, 0x21, 0x49, 0xd7, 0x56, 0xce, 0x64, 0x24, 0x69, 0x10, 0xbf, 0x40, 0x93,
	0xc9, 0xed, 0x37, 0xde, 0xd7, 0x76, 0x3e, 0x1e, 0xd3, 0xce, 0x7d, 0x0d, 0x1a, 0x30, 0x32, 0x09,
	0x25, 0xfd, 0x98, 0x92, 0xe2, 0x5f, 0x10, 0x96, 0x4c, 0x81, 0xcf, 0xf8, 0x69, 0xff, 0x55, 0x35,
	0xaa, 0xba, 0xf0, 0x87, 0x65, 0x85, 0xef, 0xa7, 0xc8, 0x4c, 0x60, 0xe7, 0xbd, 0xce, 0xac, 0xbc,
	0x12, 0xc3, 0xbf, 0xa1, 0x86, 0x54, 0x51, 0xec, 0xaa, 0x38, 0x02, 0xea, 0x48, 0xce, 0xc2, 0x10,
	0x54, 0x41, 0x6b, 0x42, 0x6b, 0x7d, 0x5d, 0xaa, 0x95, 0x73, 0xec, 0x27, 0x14, 0x05, 0xd1, 0x45,
	0x39, 0xea, 0x10, 0x3f, 0x43, 0x75, 0x12, 0x86, 0x05, 0xb9, 0x0f, 0xc6, 0xfb, 0x27, 0x76, 0x18,
	0x16, 0x04, 0x6a, 0xa4, 0xbf, 0xc5, 0x07, 0x68, 0xda, 0x25, 0xbe, 0x5f, 0xe0, 0xfc, 0x50, 0x73,
	0xde, 0x2f, 0xe3, 0xdc, 0x24, 0xbe, 0x5f, 0x20, 0x9d, 0x72, 0x0b, 0x7b, 0xfc, 0x02, 0xcd, 0xf5,
	0xf6, 0x22, 0x2e, 0x7a, 0x73, 0x5b, 0x13, 0x5b, 0xe3, 0x10, 0x8b, 0xb8, 0xe8, 0xc8, 0x8c, 0x3b,
	0x18, 0xc2, 0x2f, 0xd1, 0x82, 0x82, 0x73, 0xe5, 0x04, 0x20, 0x25, 0xf1, 0xa0, 0xa0, 0x81, 0xb4,
	0xc6, 0xa3, 0x32, 0x8d, 0x03, 0x38, 0x57, 0x3f, 0x26, 0xe0, 0x82, 0xce, 0xbc, 0x1a, 0x0e, 0xe3,
	0xe7, 0x68, 0x26, 0x8c, 0x98, 0x5b, 0x14, 0xa9, 0x69, 0x91, 0x07, 0x65, 0x22, 0x7b, 0x3d, 0x58,
	0x81, 0xbe, 0x1e, 0x16, 0x03, 0xd8, 0x45, 0xf3, 0x61, 0x24, 0x02, 0xa1, 0x06, 0x66, 0x00, 0x63,
	0x4a, 0x93, 0x7f, 0x59, 0x4e, 0x9e, 0x42, 0x0b, 0x02, 0x73, 0xe1, 0xd5, 0x20, 0x06, 0x84, 0x7d,
	0xe1, 0x92, 0x2b, 0x1a, 0xd3, 0xe3, 0xdd, 0x88, 0xa7, 0x29, 0x32, 0x63, 0xd3, 0x97, 0xad, 0x77,
	0x2d, 0xfc, 0x2b, 0x07, 0xf8, 0xf7, 0x0a, 0x6a, 0x90, 0x6e, 0x97, 0xf9, 0xac, 0xf7, 0x7a, 0x5f,
	0xa3, 0x38, 0x33, 0xde, 0xbd, 0xb0, 0x33, 0x8e, 0x51, 0xd2, 0x8b, 0x64, 0x54, 0x06, 0x0e, 0xd0,
	0xdd, 0x13, 0xa1, 0xc0, 0x77, 0x86, 0x3b, 0xef, 0xae, 0x56, 0x5f, 0x2f, 0x53, 0xdf, 0xe9, 0xc1,
	0x87, 0xdb, 0xef, 0xce, 0xc9, 0x35, 0x71, 0x2c, 0xd1, 0x5c, 0xfe, 0x44, 0xba, 0x24, 0x08, 0x09,
	0xf3, 0xb8, 0x81, 0xc7, 0x78, 0xa7, 0x3f, 0xbb, 0xb4, 0x3f, 0x45, 0x2b, 0x23, 0xdf, 0xe9, 0xcd,
	0x94, 0x6b, 0xa7, 0xd2, 0xc9, 0xdf, 0xe0, 0x2c, 0x86, 0x7f, 0x2d, 0x88, 0x12, 0xea, 0x78, 0x91,
	0x88, 0x43, 0x63, 0x7e, 0x0c, 0xd1, 0xd5, 0x4b, 0xfb, 0x1e, 0x5a, 0x1e, 0x29, 0x6a, 0xd3, 0xed,
	0x1e, 0xd5, 0x4e, 0xa5, 0xff, 0x64, 0xa7, 0xa1, 0x16, 0x7f, 0x67, 0x9f, 0xfe, 0x9f, 0xc9, 0x05,
	0x7f, 0xe3, 0xc6, 0x52, 0x89, 0x00, 0x22, 0x69, 0xbd, 0xce, 0x96, 0x6f, 0xfa, 0x23, 0x63, 0x96,
	0x27, 0xad, 0xd7, 0xd7, 0x8c, 0xc0, 0x6f, 0xda, 0x35, 0x74, 0x3b, 0x8f, 0xb7, 0x1b, 0x68, 0x49,
	0x42, 0x74, 0xc6, 0xb8, 0xe7, 0xe4, 0x83, 0x55, 0x52, 0x20, 0xe3, 0x5e, 0xfb, 0xcf, 0x2a, 0x5a,
	0x75, 0x45, 0x60, 0x96, 0xce, 0xcb, 0xed, 0x85, 0xa1, 0x32, 0xf7, 0x7a, 0x2e, 0xed, 0x55, 0x7e,
	0xfe, 0x3e, 0x05, 0x7b, 0xc2, 0x27, 0xdc, 0x33, 0x45, 0xe4, 0x59, 0x1e, 0x70, 0xed, 0xa1, 0xd5,
	0xff, 0xd4, 0x1b, 0x06, 0xf9, 0x8d, 0x7c, 0xf5, 0x77, 0x75, 0x62, 0xdb, 0xb6, 0xff, 0xa9, 0xae,
	0x6c, 0x27, 0x94, 0x36, 0x95, 0x66, 0xb2, 0xec, 0xad, 0x0e, 0x9b, 0x66, 0x27, 0xcb, 0xfc, 0x37,
	0xcb, 0x39, 0xb2, 0xa9, 0x3c, 0xca, 0x73, 0x8e, 0x0e, 0x9b, 0x47, 0x79, 0xce, 0xbb, 0xea, 0x6a,
	0x72, 0xd0, 0x6a, 0xd9, 0x54, 0xb6, 0x5a, 0x79, 0x56, 0xab, 0x75, 0xd8, 0x6c, 0xb5, 0xf2, 0xbc,
	0xe3, 0x49, 0x5d, 0xec, 0xa3, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x28, 0x62, 0xde, 0xe0, 0x74,
	0x0c, 0x00, 0x00,
}
