/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.ActiveItem;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemBuilder;
import org.openhab.core.items.ItemFactory;

@NonNullByDefault
public class ItemBuilderImpl
implements ItemBuilder {
    private final Set<ItemFactory> itemFactories;
    private final String itemType;
    private final String name;
    private @Nullable String category;
    private List<String> groups = List.of();
    private @Nullable String label;
    private @Nullable Item baseItem;
    private @Nullable GroupFunction groupFunction;
    private Set<String> tags = Set.of();

    public ItemBuilderImpl(Set<ItemFactory> itemFactories, Item item) {
        this.itemFactories = itemFactories;
        this.itemType = item.getType();
        this.name = item.getName();
        this.category = item.getCategory();
        this.groups = item.getGroupNames();
        this.label = item.getLabel();
        this.tags = item.getTags();
        if (item instanceof GroupItem) {
            GroupItem groupItem = (GroupItem)item;
            this.baseItem = groupItem.getBaseItem();
            this.groupFunction = groupItem.getFunction();
        }
    }

    public ItemBuilderImpl(Set<ItemFactory> itemFactories, String itemType, String itemName) {
        this.itemFactories = itemFactories;
        this.itemType = itemType;
        this.name = itemName;
    }

    @Override
    public ItemBuilder withLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    @Override
    public ItemBuilder withGroups(@Nullable Collection<String> groups) {
        this.groups = groups != null ? new LinkedList<String>(groups) : List.of();
        return this;
    }

    @Override
    public ItemBuilder withCategory(@Nullable String category) {
        this.category = category;
        return this;
    }

    @Override
    public ItemBuilder withBaseItem(@Nullable Item item) {
        if (item != null && !"Group".equals(this.itemType)) {
            throw new IllegalArgumentException("Only group items can have a base item");
        }
        this.baseItem = item;
        return this;
    }

    @Override
    public ItemBuilder withGroupFunction(@Nullable GroupFunction function) {
        if (function != null && !"Group".equals(this.itemType)) {
            throw new IllegalArgumentException("Only group items can have a base item");
        }
        this.groupFunction = function;
        return this;
    }

    @Override
    public ItemBuilder withTags(@Nullable Set<String> tags) {
        this.tags = tags != null ? Set.copyOf(tags) : Set.of();
        return this;
    }

    @Override
    public Item build() {
        Item item = null;
        if ("Group".equals(this.itemType)) {
            item = new GroupItem(this.name, this.baseItem, this.groupFunction);
        } else {
            for (ItemFactory itemFactory : this.itemFactories) {
                item = itemFactory.createItem(this.itemType, this.name);
                if (item != null) break;
            }
        }
        if (item == null) {
            throw new IllegalStateException("No item factory could handle type " + this.itemType);
        }
        if (item instanceof ActiveItem) {
            ActiveItem activeItem = item;
            activeItem.setLabel(this.label);
            activeItem.setCategory(this.category);
            activeItem.addGroupNames(this.groups);
            activeItem.addTags(this.tags);
        }
        return item;
    }
}

