.\" $NCDId: @(#)AuMElImW.man,v 1.1 1994/09/27 00:32:21 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id$
.TH AuMakeElementImportWaveFrom 3 "1.2" "audiolib - element initialization"
.SH \fBName\fP
\fBAuMakeElementImportWaveForm\fP \- initialize an ImportWaveForm element
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
\fBAuMakeElementImportWaveForm\fP(\fIelement\fP, \fIsample_rate\fP, \fIwave_form\fP, \fInum_samples\fP, \fIfreq\fP, \fInum_actions\fP, \fIactions\fP)
.br
    \fBAuElement\fP *\fIelement\fP; /* \fBRETURN\fP */
.br
    unsigned short \fIsample_rate\fP;
.br
    int \fIwave_form\fP;
.br
    \fBAuInt32\fP \fIfreq\fP;
.br
    \fBAuInt32\fP \fInum_samples\fP;
.br
    int \fInum_actions\fP;
.br
    \fBAuElementAction\fP *\fIactions\fP;
.SH \fBArguments\fP
.IP \fIelement\fP 1i
Returns the initialized element.
.IP \fIsample_rate\fP 1i
Specifies the sample rate of the audio data.
.IP \fIwave_form\fP 1i
Specifies the waveform to use.
Currently, the following waveforms are defined: \fBAuWaveFormSquare\fP, \fBAuWaveFormSine\fP, \fBAuWaveFormSaw\fP, and \fBAuWaveFormConstant.
.IP \fIfreq\fP 1i
Specifies the frequency of the waveform.
.IP \fInum_samples\fP 1i
Specifies the number of samples to read.
Use \fBAuUnlimitedSamples\fP to indicate an unlimited number of samples.
.IP \fInum_actions\fP 1i
Specifies the number of actions in \fIactions\fP.
.IP \fIactions\fP 1i
Specifies the list of actions to associate with this element.
Entries in this list can be initialized with \fBAuMakeChangeStateAction\fP, \fBAuMakeSendNotifyAction\fP, and \fBAuMakeNoopAction\fP.
May be NULL.
.SH \fBDescription\fP
\fBAuMakeElementImportWaveForm\fP sets the \fItype\fP member of \fIelement\fP to \fBAuElementTypeImportWaveForm\fP and initializes the \fIimportwaveform\fP member of \fIelement\fP with the remaining arguments.
.LP
\fBAuMakeElementImportWaveForm\fP is implemented as a macro.
.SH \fBNote\fPS
A server might not support all the waveforms currently defined.
.SH \fBSee Also\fP
\fBAuMakeElementAddConstant\fP,
\fBAuMakeElementBundle\fP,
\fBAuMakeElementExportBucket\fP,
\fBAuMakeElementExportClient\fP,
\fBAuMakeElementExportDevice\fP,
\fBAuMakeElementExportMonitor\fP
\fBAuMakeElementImportBucket\fP,
\fBAuMakeElementImportClient\fP,
\fBAuMakeElementImportDevice\fP,
\fBAuMakeElementMultiplyConstant\fP,
\fBAuMakeElementSum\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
