# add our macro directory to cmake search path
set (CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} ${CMAKE_SOURCE_DIR}/cmake)

include (ACGCommon)
find_package(CoMISo)

#find_package(MUMPS)
if (MUMPS_FOUND )
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${MUMPS_INCLUDE_DIR} )
  list( APPEND COMISO_LINK_LIBRARIES ${MUMPS_LIBRARY} )
endif ()

#find_package (IPOPT)
if (IPOPT_FOUND AND MUMPS_FOUND)
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${IPOPT_INCLUDE_DIR} )
  list( APPEND COMISO_LINK_DIRECTORIES ${IPOPT_LIBRARY_DIR} )
  list( APPEND COMISO_LINK_LIBRARIES ${IPOPT_LIBRARY} )
endif ()

#find_package(LAPACK)
#find_package(Taucs)
if(LAPACK_FOUND AND TAUCS_FOUND)
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${TAUCS_INCLUDE_DIR} )
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${LAPACK_INCLUDE_DIR} )
  list( APPEND COMISO_LINK_DIRECTORIES    ${LAPACK_LIBRARY_DIR} )
  list( APPEND COMISO_LINK_LIBRARIES  ${TAUCS_LIBRARY} )
  list( APPEND COMISO_LINK_LIBRARIES  ${LAPACK_LIBRARIES} )
endif()

#find_package(GUROBI)
if( GUROBI_FOUND)
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${GUROBI_INCLUDE_DIR} )
  list( APPEND COMISO_LINK_DIRECTORIES    ${GUROBI_LIBRARY_DIR} )
  list( APPEND COMISO_LINK_LIBRARIES  ${GUROBI_LIBRARY} )
endif()

#find_package(ARPACK)
if( ARPACK_FOUND)
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${ARPACK_INCLUDE_DIR} )
  list( APPEND COMISO_LINK_LIBRARIES  ${ARPACK_LIBRARIES} )
endif()

#FIND_PACKAGE( Boost 1.42.0 COMPONENTS system filesystem regex)
if( Boost_FOUND)
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${Boost_INCLUDE_DIR} )
  list( APPEND COMISO_LINK_DIRECTORIES  ${Boost_LIBRARY_DIRS} )
  list( APPEND COMISO_LINK_LIBRARIES  ${Boost_LIBRARIES} )
endif()

#FIND_PACKAGE( MPI)
if( MPI_FOUND)
  list( APPEND COMISO_LINK_LIBRARIES  ${MPI_CXX_LIBRARIES} )
endif()

#FIND_PACKAGE( PETSC)
if( PETSC_FOUND)
  list( APPEND COMISO_LINK_LIBRARIES  ${PETSC_LIBRARY} )
  list( APPEND COMISO_LINK_LIBRARIES  ${TAO_LIBRARY} )
  list( APPEND COMISO_LINK_DIRECTORIES ${PETSC_LIBRARY_DIR} )
endif()

#FIND_PACKAGE( TAO)
if( TAO_FOUND)
  list( APPEND COMISO_LINK_DIRECTORIES ${TAO_LIBRARY_DIR})
endif()

#FIND_PACKAGE( SUITESPARSE)
if(SUITESPARSE_FOUND)
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${SUITESPARSE_INCLUDE_DIRS})
  list( APPEND COMISO_LINK_LIBRARIES  ${SUITESPARSE_LIBRARIES} )
  list( APPEND COMISO_LINK_DIRECTORIES ${SUITESPARSE_LIBRARY_DIRS} )
endif()

#FIND_PACKAGE( EIGEN3)
if(EIGEN3_FOUND)
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${EIGEN3_INCLUDE_DIR})
endif()

if (CGAL_FOUND)
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${CGAL_INCLUDE_DIR} )
  list( APPEND COMISO_LINK_DIRECTORIES   ${CGAL_LIBRARY_DIR} )
  list( APPEND COMISO_LINK_LIBRARIES  ${CGAL_LIBRARIES} )
endif()

if (CPLEX_FOUND)
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${CPLEX_INCLUDE_DIRS} )
  list( APPEND COMISO_LINK_LIBRARIES  ${CPLEX_LIBRARIES} )
  #enable c++ support
   add_definitions(-DIL_STD)
endif()

if (GUROBI_FOUND )
  list( APPEND COMISO_INCLUDE_DIRECTORIES ${GUROBI_INCLUDE_DIRS} )
  list( APPEND COMISO_LINK_LIBRARIES  ${GUROBI_LIBRARIES} )
endif ()

#MESSAGE( ${COMISO_LINK_LIBRARIES})

#ToDo:
#list( APPEND COMISO_LINK_LIBRARIES  "pthread" )

include_directories (
  ..
  ${CMAKE_SOURCE_DIR}
  ${CMAKE_CURRENT_SOURCE_DIR}
  ${CMAKE_CURRENT_BINARY_DIR}
  ${COMISO_INCLUDE_DIR}
  ${COMISO_INCLUDE_DIRECTORIES}
)

link_directories (
  ${COMISO_LINK_DIRECTORIES}
)

# source code directories
set (directories 
  ${CMAKE_CURRENT_SOURCE_DIR} 
)

# collect all header and source files
set(headers "")
set(sources "")
acg_append_files (headers "*.hh" ${directories})
acg_append_files (sources "*.cc" ${directories})

# remove template cc files from source file list
acg_drop_templates (sources)
