/* squasher
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __SQUASHER_H__
#define __SQUASHER_H__

extern tree squash_outer_scope;

/* forward for general squash */
tree squash_node(tree p, tree scope);

/* must this operator be squashed? */
boolean is_simple_op(tree p, tree t);

/* squash a (right-hand) reference */
tree squash_ref(tree p, tree scope);

tree squash_assign(tree p, tree scope);

tree squash_for(tree p, tree scope);

/* remove the implementation pointer for primitive operations */
void squash_buildins(tree p);

tree squash_op(tree p, tree scope);

tree squash_chain(tree p, tree scope);

tree squash_node(tree p, tree scope);

void squash(tree * p);

#endif
