/* code generator
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __CODEGEN_H__
#define __CODEGEN_H__

/* return the page bits for the indicated target */
int page_bits(int address);

/* return the number of instructions occupied by a page 'instruction' */
int page_instruction_size(int address, boolean sacred);

/* w value re-use */

extern tree current_w_value;
extern int current_w_offset;

void load_w(tree x);

void forget_w(void);

boolean w_is(tree x);

/* the pic flags */
extern tree pic_flags, pic_pclath, pic_flag_zero, pic_flag_carry, pic_flag_digit_carry;

/* report whether t is used in p */
boolean uses(tree t, tree p);

/* copy master address when needed */
void copy_master_address(tree q);

/* types are compatible ? */
boolean code_type_is(tree p, tree t);

/* last pages routines gathered during coding */
extern tree first_page_routines;

/* transfer administration */
extern int transfer_count;
#define transfer_size   256
extern tree transfers[transfer_size];
extern tree transfer_label;
extern int transfer_address;

void make_transfer(tree p);

tree one_transfer(tree p);

tree make_asm_bit(opcode_t opcode, int file, int bit);

tree code_transfers(tree transfer_label);

/* codes generated for a boolean expression depends on:
 *    true_next == the true label is the very next location
 *    true_one  == the true part is just one instruction
 *    idem for false_next and false_one
 * these arguments must be passed on through all calls..
 */
#define formal_args tree p, \
   tree true_label,  boolean true_next,  boolean true_one, \
   tree false_label, boolean false_next, boolean false_one
#define my_args true_label, true_next, true_one, \
   false_label, false_next, false_one

/* forward: the main coder routine */
tree code_node(formal_args);

tree code_store(formal_args);

tree code_jump(loc_t loc, formal_args);

tree try_clrf(tree p);

tree try_file_op2(tree p, int op, int val, int opcode1, int opcode2);

#define try_file_op( p, op, val, code1, code2 ) { \
   tree q = try_file_op2( p, op, val, code1, code2 ); \
   if( q != NULL ) return q; \
}

tree code_skip(loc_t loc, boolean invert, tree flag);

tree code_boolean(formal_args);

tree code_byte_op(formal_args);

tree code_op(formal_args);

/* generate code for the referenced object */
tree code_ref(formal_args);

tree code_if(formal_args);

tree code_while(formal_args);

tree code_bit_assign(formal_args);

tree code_byte_assign(formal_args);

tree code_assign(formal_args);

#define max_virtual_routines 1000
extern int n_virtual_routines;
extern tree virtual_routines[max_virtual_routines];
extern tree call_vectors;

tree code_procedure(formal_args);

tree code_node(formal_args);

tree code_tree(tree p);

tree code_interrupt(void);

#define cv( x ) new_const ( new_value( type_universal, x ) )

tree code_interrupt_header(tree target);

tree code_interrupt_trailer(void);

/* depends on the size of the code_interrupt_header */
int transfer_start(void);

void code(tree * p);

/********** page optimizations ***********/

#define phase_mark_linear   (-3)
#define phase_mark_targets  (-2)
#define phase_remove        (-1)
#define unknown             (-2)
#define no_bank             (-1)
extern int current_bank;

int bank_from_argument(tree q);

void opt_bank(tree p, int phase);

void optimize_bank(tree * p);

/******************************************************************************
*
* page instruction elimination
*
* This phase removes redundant page instructions, and replaces the remaining
* page instructions with the appropriate target-specific instructions.
*
* call:
*    void eliminate_page( tree *p )
*
* Four sweeps are done:
* kill:      All non-sacred page instructions are marked fizzle.
* mark:      The location_counter location for all instructions
*            is is determined and (for labels) stored in p->x.
* restore:   Each page instruction that turns out to be needed
*            (determined from the p->x of the target label)
*            is restored by removing the fizzle.
* replace:   The non-fizzled page instructions are replaced
*            by their implementation on the target chip.
*
* The mark and restore sweeps are repeated untill no more page
* instructions need to be resurrected.
*
* A (not fizzeled) page N is translated to
* the following number of instructions:
* - 0 for 16c84, 16f84, 12c508   (generates no code at all)
* - 1 for sx18, sx28             (native bank instruction)
* - 1 for 12c509                 (bcf/bsf)
* - 1 for 16f877 when N == 0     (clrf)
* - 2 for 16f877 when N != 0     (2 * bcf/bsf)
*
* The restore sweep maintains the current page like this:
* - the current page starts as 0
* - a page instruction sets the current page
* - a conditional skip instruction makes the next instruction conditional
* - an unconditional jump sets the current page <free>
* - a label, with the current page <free>, sets the current page
* - a call sets the current page <unknown>
* A page instruction is restored when it refers to a label that has
* a page that is not equal to the current page.
*
******************************************************************************/

/* the sweeps */
#define page_sweep_kill       (-1)
#define page_sweep_mark       (-2)
#define page_sweep_restore    (-3)
#define page_sweep_replace    (-4)

/* the current setting of the page bits */
#define page_is_free          (-1)
#define page_is_unknown       (-2)
extern int page_current_page;

extern int page_location_counter;
extern int page_instructions_restored;
extern boolean page_conditional;

extern tree inval;



/* return the instruction(s) that implement the page on the target */
tree page_instructions(tree p);


/*
 * traverse the entire tree
 * and perform the operations of the indicated sweep
 * as described in the introduction
 *
 * Actually most work is done regardless of the current sweep.
 */
tree eliminate_page_visit_node(tree p, int sweep);

void eliminate_page(tree * p);

#endif
