/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

type RestoreApi interface {

	/*
	 * PostRestoreBucketID Overwrite storage metadata for a bucket with shard info from a backup.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param bucketID The bucket ID.
	 * @return ApiPostRestoreBucketIDRequest
	 */
	PostRestoreBucketID(ctx _context.Context, bucketID string) ApiPostRestoreBucketIDRequest

	/*
	 * PostRestoreBucketIDExecute executes the request
	 * @return string
	 */
	PostRestoreBucketIDExecute(r ApiPostRestoreBucketIDRequest) (string, error)

	/*
	 * PostRestoreBucketIDExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return string
	 */
	PostRestoreBucketIDExecuteWithHttpInfo(r ApiPostRestoreBucketIDRequest) (string, *_nethttp.Response, error)

	/*
	 * PostRestoreBucketMetadata Create a new bucket pre-seeded with shard info from a backup.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiPostRestoreBucketMetadataRequest
	 */
	PostRestoreBucketMetadata(ctx _context.Context) ApiPostRestoreBucketMetadataRequest

	/*
	 * PostRestoreBucketMetadataExecute executes the request
	 * @return RestoredBucketMappings
	 */
	PostRestoreBucketMetadataExecute(r ApiPostRestoreBucketMetadataRequest) (RestoredBucketMappings, error)

	/*
	 * PostRestoreBucketMetadataExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return RestoredBucketMappings
	 */
	PostRestoreBucketMetadataExecuteWithHttpInfo(r ApiPostRestoreBucketMetadataRequest) (RestoredBucketMappings, *_nethttp.Response, error)

	/*
	 * PostRestoreKV Overwrite the embedded KV store on the server with a backed-up snapshot.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiPostRestoreKVRequest
	 */
	PostRestoreKV(ctx _context.Context) ApiPostRestoreKVRequest

	/*
	 * PostRestoreKVExecute executes the request
	 * @return PostRestoreKVResponse
	 */
	PostRestoreKVExecute(r ApiPostRestoreKVRequest) (PostRestoreKVResponse, error)

	/*
	 * PostRestoreKVExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return PostRestoreKVResponse
	 */
	PostRestoreKVExecuteWithHttpInfo(r ApiPostRestoreKVRequest) (PostRestoreKVResponse, *_nethttp.Response, error)

	/*
	 * PostRestoreSQL Overwrite the embedded SQL store on the server with a backed-up snapshot.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiPostRestoreSQLRequest
	 */
	PostRestoreSQL(ctx _context.Context) ApiPostRestoreSQLRequest

	/*
	 * PostRestoreSQLExecute executes the request
	 */
	PostRestoreSQLExecute(r ApiPostRestoreSQLRequest) error

	/*
	 * PostRestoreSQLExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 */
	PostRestoreSQLExecuteWithHttpInfo(r ApiPostRestoreSQLRequest) (*_nethttp.Response, error)

	/*
	 * PostRestoreShardId Restore a TSM snapshot into a shard.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param shardID The shard ID.
	 * @return ApiPostRestoreShardIdRequest
	 */
	PostRestoreShardId(ctx _context.Context, shardID string) ApiPostRestoreShardIdRequest

	/*
	 * PostRestoreShardIdExecute executes the request
	 */
	PostRestoreShardIdExecute(r ApiPostRestoreShardIdRequest) error

	/*
	 * PostRestoreShardIdExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 */
	PostRestoreShardIdExecuteWithHttpInfo(r ApiPostRestoreShardIdRequest) (*_nethttp.Response, error)
}

// RestoreApiService RestoreApi service
type RestoreApiService service

type ApiPostRestoreBucketIDRequest struct {
	ctx          _context.Context
	ApiService   RestoreApi
	bucketID     string
	body         []byte
	zapTraceSpan *string
	contentType  *string
}

func (r ApiPostRestoreBucketIDRequest) BucketID(bucketID string) ApiPostRestoreBucketIDRequest {
	r.bucketID = bucketID
	return r
}
func (r ApiPostRestoreBucketIDRequest) GetBucketID() string {
	return r.bucketID
}

func (r ApiPostRestoreBucketIDRequest) Body(body []byte) ApiPostRestoreBucketIDRequest {
	r.body = body
	return r
}
func (r ApiPostRestoreBucketIDRequest) GetBody() []byte {
	return r.body
}

func (r ApiPostRestoreBucketIDRequest) ZapTraceSpan(zapTraceSpan string) ApiPostRestoreBucketIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostRestoreBucketIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostRestoreBucketIDRequest) ContentType(contentType string) ApiPostRestoreBucketIDRequest {
	r.contentType = &contentType
	return r
}
func (r ApiPostRestoreBucketIDRequest) GetContentType() *string {
	return r.contentType
}

func (r ApiPostRestoreBucketIDRequest) Execute() (string, error) {
	return r.ApiService.PostRestoreBucketIDExecute(r)
}

func (r ApiPostRestoreBucketIDRequest) ExecuteWithHttpInfo() (string, *_nethttp.Response, error) {
	return r.ApiService.PostRestoreBucketIDExecuteWithHttpInfo(r)
}

/*
 * PostRestoreBucketID Overwrite storage metadata for a bucket with shard info from a backup.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param bucketID The bucket ID.
 * @return ApiPostRestoreBucketIDRequest
 */
func (a *RestoreApiService) PostRestoreBucketID(ctx _context.Context, bucketID string) ApiPostRestoreBucketIDRequest {
	return ApiPostRestoreBucketIDRequest{
		ApiService: a,
		ctx:        ctx,
		bucketID:   bucketID,
	}
}

/*
 * Execute executes the request
 * @return string
 */
func (a *RestoreApiService) PostRestoreBucketIDExecute(r ApiPostRestoreBucketIDRequest) (string, error) {
	returnVal, _, err := a.PostRestoreBucketIDExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return string
 */
func (a *RestoreApiService) PostRestoreBucketIDExecuteWithHttpInfo(r ApiPostRestoreBucketIDRequest) (string, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RestoreApiService.PostRestoreBucketID")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/restore/buckets/{bucketID}"
	localVarPath = strings.Replace(localVarPath, "{"+"bucketID"+"}", _neturl.PathEscape(parameterToString(r.bucketID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.body == nil {
		return localVarReturnValue, nil, reportError("body is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"text/plain"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	if r.contentType != nil {
		localVarHeaderParams["Content-Type"] = parameterToString(*r.contentType, "")
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPostRestoreBucketMetadataRequest struct {
	ctx                    _context.Context
	ApiService             RestoreApi
	bucketMetadataManifest *BucketMetadataManifest
	zapTraceSpan           *string
}

func (r ApiPostRestoreBucketMetadataRequest) BucketMetadataManifest(bucketMetadataManifest BucketMetadataManifest) ApiPostRestoreBucketMetadataRequest {
	r.bucketMetadataManifest = &bucketMetadataManifest
	return r
}
func (r ApiPostRestoreBucketMetadataRequest) GetBucketMetadataManifest() *BucketMetadataManifest {
	return r.bucketMetadataManifest
}

func (r ApiPostRestoreBucketMetadataRequest) ZapTraceSpan(zapTraceSpan string) ApiPostRestoreBucketMetadataRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostRestoreBucketMetadataRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostRestoreBucketMetadataRequest) Execute() (RestoredBucketMappings, error) {
	return r.ApiService.PostRestoreBucketMetadataExecute(r)
}

func (r ApiPostRestoreBucketMetadataRequest) ExecuteWithHttpInfo() (RestoredBucketMappings, *_nethttp.Response, error) {
	return r.ApiService.PostRestoreBucketMetadataExecuteWithHttpInfo(r)
}

/*
 * PostRestoreBucketMetadata Create a new bucket pre-seeded with shard info from a backup.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostRestoreBucketMetadataRequest
 */
func (a *RestoreApiService) PostRestoreBucketMetadata(ctx _context.Context) ApiPostRestoreBucketMetadataRequest {
	return ApiPostRestoreBucketMetadataRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RestoredBucketMappings
 */
func (a *RestoreApiService) PostRestoreBucketMetadataExecute(r ApiPostRestoreBucketMetadataRequest) (RestoredBucketMappings, error) {
	returnVal, _, err := a.PostRestoreBucketMetadataExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return RestoredBucketMappings
 */
func (a *RestoreApiService) PostRestoreBucketMetadataExecuteWithHttpInfo(r ApiPostRestoreBucketMetadataRequest) (RestoredBucketMappings, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  RestoredBucketMappings
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RestoreApiService.PostRestoreBucketMetadata")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/restore/bucketMetadata"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.bucketMetadataManifest == nil {
		return localVarReturnValue, nil, reportError("bucketMetadataManifest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.bucketMetadataManifest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPostRestoreKVRequest struct {
	ctx             _context.Context
	ApiService      RestoreApi
	body            _io.ReadCloser
	zapTraceSpan    *string
	contentEncoding *string
	contentType     *string
}

func (r ApiPostRestoreKVRequest) Body(body _io.ReadCloser) ApiPostRestoreKVRequest {
	r.body = body
	return r
}
func (r ApiPostRestoreKVRequest) GetBody() _io.ReadCloser {
	return r.body
}

func (r ApiPostRestoreKVRequest) ZapTraceSpan(zapTraceSpan string) ApiPostRestoreKVRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostRestoreKVRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostRestoreKVRequest) ContentEncoding(contentEncoding string) ApiPostRestoreKVRequest {
	r.contentEncoding = &contentEncoding
	return r
}
func (r ApiPostRestoreKVRequest) GetContentEncoding() *string {
	return r.contentEncoding
}

func (r ApiPostRestoreKVRequest) ContentType(contentType string) ApiPostRestoreKVRequest {
	r.contentType = &contentType
	return r
}
func (r ApiPostRestoreKVRequest) GetContentType() *string {
	return r.contentType
}

func (r ApiPostRestoreKVRequest) Execute() (PostRestoreKVResponse, error) {
	return r.ApiService.PostRestoreKVExecute(r)
}

func (r ApiPostRestoreKVRequest) ExecuteWithHttpInfo() (PostRestoreKVResponse, *_nethttp.Response, error) {
	return r.ApiService.PostRestoreKVExecuteWithHttpInfo(r)
}

/*
 * PostRestoreKV Overwrite the embedded KV store on the server with a backed-up snapshot.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostRestoreKVRequest
 */
func (a *RestoreApiService) PostRestoreKV(ctx _context.Context) ApiPostRestoreKVRequest {
	return ApiPostRestoreKVRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return PostRestoreKVResponse
 */
func (a *RestoreApiService) PostRestoreKVExecute(r ApiPostRestoreKVRequest) (PostRestoreKVResponse, error) {
	returnVal, _, err := a.PostRestoreKVExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return PostRestoreKVResponse
 */
func (a *RestoreApiService) PostRestoreKVExecuteWithHttpInfo(r ApiPostRestoreKVRequest) (PostRestoreKVResponse, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  PostRestoreKVResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RestoreApiService.PostRestoreKV")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/restore/kv"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.body == nil {
		return localVarReturnValue, nil, reportError("body is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"text/plain"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	if r.contentEncoding != nil {
		localVarHeaderParams["Content-Encoding"] = parameterToString(*r.contentEncoding, "")
	}
	if r.contentType != nil {
		localVarHeaderParams["Content-Type"] = parameterToString(*r.contentType, "")
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPostRestoreSQLRequest struct {
	ctx             _context.Context
	ApiService      RestoreApi
	body            _io.ReadCloser
	zapTraceSpan    *string
	contentEncoding *string
	contentType     *string
}

func (r ApiPostRestoreSQLRequest) Body(body _io.ReadCloser) ApiPostRestoreSQLRequest {
	r.body = body
	return r
}
func (r ApiPostRestoreSQLRequest) GetBody() _io.ReadCloser {
	return r.body
}

func (r ApiPostRestoreSQLRequest) ZapTraceSpan(zapTraceSpan string) ApiPostRestoreSQLRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostRestoreSQLRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostRestoreSQLRequest) ContentEncoding(contentEncoding string) ApiPostRestoreSQLRequest {
	r.contentEncoding = &contentEncoding
	return r
}
func (r ApiPostRestoreSQLRequest) GetContentEncoding() *string {
	return r.contentEncoding
}

func (r ApiPostRestoreSQLRequest) ContentType(contentType string) ApiPostRestoreSQLRequest {
	r.contentType = &contentType
	return r
}
func (r ApiPostRestoreSQLRequest) GetContentType() *string {
	return r.contentType
}

func (r ApiPostRestoreSQLRequest) Execute() error {
	return r.ApiService.PostRestoreSQLExecute(r)
}

func (r ApiPostRestoreSQLRequest) ExecuteWithHttpInfo() (*_nethttp.Response, error) {
	return r.ApiService.PostRestoreSQLExecuteWithHttpInfo(r)
}

/*
 * PostRestoreSQL Overwrite the embedded SQL store on the server with a backed-up snapshot.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostRestoreSQLRequest
 */
func (a *RestoreApiService) PostRestoreSQL(ctx _context.Context) ApiPostRestoreSQLRequest {
	return ApiPostRestoreSQLRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 */
func (a *RestoreApiService) PostRestoreSQLExecute(r ApiPostRestoreSQLRequest) error {
	_, err := a.PostRestoreSQLExecuteWithHttpInfo(r)
	return err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 */
func (a *RestoreApiService) PostRestoreSQLExecuteWithHttpInfo(r ApiPostRestoreSQLRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RestoreApiService.PostRestoreSQL")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/restore/sql"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.body == nil {
		return nil, reportError("body is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"text/plain"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	if r.contentEncoding != nil {
		localVarHeaderParams["Content-Encoding"] = parameterToString(*r.contentEncoding, "")
	}
	if r.contentType != nil {
		localVarHeaderParams["Content-Type"] = parameterToString(*r.contentType, "")
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiPostRestoreShardIdRequest struct {
	ctx             _context.Context
	ApiService      RestoreApi
	shardID         string
	body            _io.ReadCloser
	zapTraceSpan    *string
	contentEncoding *string
	contentType     *string
}

func (r ApiPostRestoreShardIdRequest) ShardID(shardID string) ApiPostRestoreShardIdRequest {
	r.shardID = shardID
	return r
}
func (r ApiPostRestoreShardIdRequest) GetShardID() string {
	return r.shardID
}

func (r ApiPostRestoreShardIdRequest) Body(body _io.ReadCloser) ApiPostRestoreShardIdRequest {
	r.body = body
	return r
}
func (r ApiPostRestoreShardIdRequest) GetBody() _io.ReadCloser {
	return r.body
}

func (r ApiPostRestoreShardIdRequest) ZapTraceSpan(zapTraceSpan string) ApiPostRestoreShardIdRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostRestoreShardIdRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostRestoreShardIdRequest) ContentEncoding(contentEncoding string) ApiPostRestoreShardIdRequest {
	r.contentEncoding = &contentEncoding
	return r
}
func (r ApiPostRestoreShardIdRequest) GetContentEncoding() *string {
	return r.contentEncoding
}

func (r ApiPostRestoreShardIdRequest) ContentType(contentType string) ApiPostRestoreShardIdRequest {
	r.contentType = &contentType
	return r
}
func (r ApiPostRestoreShardIdRequest) GetContentType() *string {
	return r.contentType
}

func (r ApiPostRestoreShardIdRequest) Execute() error {
	return r.ApiService.PostRestoreShardIdExecute(r)
}

func (r ApiPostRestoreShardIdRequest) ExecuteWithHttpInfo() (*_nethttp.Response, error) {
	return r.ApiService.PostRestoreShardIdExecuteWithHttpInfo(r)
}

/*
 * PostRestoreShardId Restore a TSM snapshot into a shard.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param shardID The shard ID.
 * @return ApiPostRestoreShardIdRequest
 */
func (a *RestoreApiService) PostRestoreShardId(ctx _context.Context, shardID string) ApiPostRestoreShardIdRequest {
	return ApiPostRestoreShardIdRequest{
		ApiService: a,
		ctx:        ctx,
		shardID:    shardID,
	}
}

/*
 * Execute executes the request
 */
func (a *RestoreApiService) PostRestoreShardIdExecute(r ApiPostRestoreShardIdRequest) error {
	_, err := a.PostRestoreShardIdExecuteWithHttpInfo(r)
	return err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 */
func (a *RestoreApiService) PostRestoreShardIdExecuteWithHttpInfo(r ApiPostRestoreShardIdRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RestoreApiService.PostRestoreShardId")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/restore/shards/{shardID}"
	localVarPath = strings.Replace(localVarPath, "{"+"shardID"+"}", _neturl.PathEscape(parameterToString(r.shardID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.body == nil {
		return nil, reportError("body is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"text/plain"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	if r.contentEncoding != nil {
		localVarHeaderParams["Content-Encoding"] = parameterToString(*r.contentEncoding, "")
	}
	if r.contentType != nil {
		localVarHeaderParams["Content-Type"] = parameterToString(*r.contentType, "")
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}
