/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the SearchCertificatesRestResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &SearchCertificatesRestResponse{}

// SearchCertificatesRestResponse struct for SearchCertificatesRestResponse
type SearchCertificatesRestResponse struct {
	Certificates         []CertificateRestResponse `json:"certificates,omitempty"`
	MoreResults          *bool                     `json:"more_results,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _SearchCertificatesRestResponse SearchCertificatesRestResponse

// NewSearchCertificatesRestResponse instantiates a new SearchCertificatesRestResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSearchCertificatesRestResponse() *SearchCertificatesRestResponse {
	this := SearchCertificatesRestResponse{}
	return &this
}

// NewSearchCertificatesRestResponseWithDefaults instantiates a new SearchCertificatesRestResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSearchCertificatesRestResponseWithDefaults() *SearchCertificatesRestResponse {
	this := SearchCertificatesRestResponse{}
	return &this
}

// GetCertificates returns the Certificates field value if set, zero value otherwise.
func (o *SearchCertificatesRestResponse) GetCertificates() []CertificateRestResponse {
	if o == nil || isNil(o.Certificates) {
		var ret []CertificateRestResponse
		return ret
	}
	return o.Certificates
}

// GetCertificatesOk returns a tuple with the Certificates field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchCertificatesRestResponse) GetCertificatesOk() ([]CertificateRestResponse, bool) {
	if o == nil || isNil(o.Certificates) {
		return nil, false
	}
	return o.Certificates, true
}

// HasCertificates returns a boolean if a field has been set.
func (o *SearchCertificatesRestResponse) HasCertificates() bool {
	if o != nil && !isNil(o.Certificates) {
		return true
	}

	return false
}

// SetCertificates gets a reference to the given []CertificateRestResponse and assigns it to the Certificates field.
func (o *SearchCertificatesRestResponse) SetCertificates(v []CertificateRestResponse) {
	o.Certificates = v
}

// GetMoreResults returns the MoreResults field value if set, zero value otherwise.
func (o *SearchCertificatesRestResponse) GetMoreResults() bool {
	if o == nil || isNil(o.MoreResults) {
		var ret bool
		return ret
	}
	return *o.MoreResults
}

// GetMoreResultsOk returns a tuple with the MoreResults field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchCertificatesRestResponse) GetMoreResultsOk() (*bool, bool) {
	if o == nil || isNil(o.MoreResults) {
		return nil, false
	}
	return o.MoreResults, true
}

// HasMoreResults returns a boolean if a field has been set.
func (o *SearchCertificatesRestResponse) HasMoreResults() bool {
	if o != nil && !isNil(o.MoreResults) {
		return true
	}

	return false
}

// SetMoreResults gets a reference to the given bool and assigns it to the MoreResults field.
func (o *SearchCertificatesRestResponse) SetMoreResults(v bool) {
	o.MoreResults = &v
}

func (o SearchCertificatesRestResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o SearchCertificatesRestResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.Certificates) {
		toSerialize["certificates"] = o.Certificates
	}
	if !isNil(o.MoreResults) {
		toSerialize["more_results"] = o.MoreResults
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *SearchCertificatesRestResponse) UnmarshalJSON(bytes []byte) (err error) {
	varSearchCertificatesRestResponse := _SearchCertificatesRestResponse{}

	if err = json.Unmarshal(bytes, &varSearchCertificatesRestResponse); err == nil {
		*o = SearchCertificatesRestResponse(varSearchCertificatesRestResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "certificates")
		delete(additionalProperties, "more_results")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableSearchCertificatesRestResponse struct {
	value *SearchCertificatesRestResponse
	isSet bool
}

func (v NullableSearchCertificatesRestResponse) Get() *SearchCertificatesRestResponse {
	return v.value
}

func (v *NullableSearchCertificatesRestResponse) Set(val *SearchCertificatesRestResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableSearchCertificatesRestResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableSearchCertificatesRestResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSearchCertificatesRestResponse(val *SearchCertificatesRestResponse) *NullableSearchCertificatesRestResponse {
	return &NullableSearchCertificatesRestResponse{value: val, isSet: true}
}

func (v NullableSearchCertificatesRestResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSearchCertificatesRestResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
