/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the CertificateProfileInfoRestResponseV2 type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CertificateProfileInfoRestResponseV2{}

// CertificateProfileInfoRestResponseV2 struct for CertificateProfileInfoRestResponseV2
type CertificateProfileInfoRestResponseV2 struct {
	AvailableKeyAlgs     []string `json:"available_key_algs,omitempty"`
	AvailableBitLenghts  []int32  `json:"available_bit_lenghts,omitempty"`
	AvailableEcdsaCurves []string `json:"available_ecdsa_curves,omitempty"`
	AvailableCas         []string `json:"available_cas,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CertificateProfileInfoRestResponseV2 CertificateProfileInfoRestResponseV2

// NewCertificateProfileInfoRestResponseV2 instantiates a new CertificateProfileInfoRestResponseV2 object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCertificateProfileInfoRestResponseV2() *CertificateProfileInfoRestResponseV2 {
	this := CertificateProfileInfoRestResponseV2{}
	return &this
}

// NewCertificateProfileInfoRestResponseV2WithDefaults instantiates a new CertificateProfileInfoRestResponseV2 object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCertificateProfileInfoRestResponseV2WithDefaults() *CertificateProfileInfoRestResponseV2 {
	this := CertificateProfileInfoRestResponseV2{}
	return &this
}

// GetAvailableKeyAlgs returns the AvailableKeyAlgs field value if set, zero value otherwise.
func (o *CertificateProfileInfoRestResponseV2) GetAvailableKeyAlgs() []string {
	if o == nil || isNil(o.AvailableKeyAlgs) {
		var ret []string
		return ret
	}
	return o.AvailableKeyAlgs
}

// GetAvailableKeyAlgsOk returns a tuple with the AvailableKeyAlgs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateProfileInfoRestResponseV2) GetAvailableKeyAlgsOk() ([]string, bool) {
	if o == nil || isNil(o.AvailableKeyAlgs) {
		return nil, false
	}
	return o.AvailableKeyAlgs, true
}

// HasAvailableKeyAlgs returns a boolean if a field has been set.
func (o *CertificateProfileInfoRestResponseV2) HasAvailableKeyAlgs() bool {
	if o != nil && !isNil(o.AvailableKeyAlgs) {
		return true
	}

	return false
}

// SetAvailableKeyAlgs gets a reference to the given []string and assigns it to the AvailableKeyAlgs field.
func (o *CertificateProfileInfoRestResponseV2) SetAvailableKeyAlgs(v []string) {
	o.AvailableKeyAlgs = v
}

// GetAvailableBitLenghts returns the AvailableBitLenghts field value if set, zero value otherwise.
func (o *CertificateProfileInfoRestResponseV2) GetAvailableBitLenghts() []int32 {
	if o == nil || isNil(o.AvailableBitLenghts) {
		var ret []int32
		return ret
	}
	return o.AvailableBitLenghts
}

// GetAvailableBitLenghtsOk returns a tuple with the AvailableBitLenghts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateProfileInfoRestResponseV2) GetAvailableBitLenghtsOk() ([]int32, bool) {
	if o == nil || isNil(o.AvailableBitLenghts) {
		return nil, false
	}
	return o.AvailableBitLenghts, true
}

// HasAvailableBitLenghts returns a boolean if a field has been set.
func (o *CertificateProfileInfoRestResponseV2) HasAvailableBitLenghts() bool {
	if o != nil && !isNil(o.AvailableBitLenghts) {
		return true
	}

	return false
}

// SetAvailableBitLenghts gets a reference to the given []int32 and assigns it to the AvailableBitLenghts field.
func (o *CertificateProfileInfoRestResponseV2) SetAvailableBitLenghts(v []int32) {
	o.AvailableBitLenghts = v
}

// GetAvailableEcdsaCurves returns the AvailableEcdsaCurves field value if set, zero value otherwise.
func (o *CertificateProfileInfoRestResponseV2) GetAvailableEcdsaCurves() []string {
	if o == nil || isNil(o.AvailableEcdsaCurves) {
		var ret []string
		return ret
	}
	return o.AvailableEcdsaCurves
}

// GetAvailableEcdsaCurvesOk returns a tuple with the AvailableEcdsaCurves field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateProfileInfoRestResponseV2) GetAvailableEcdsaCurvesOk() ([]string, bool) {
	if o == nil || isNil(o.AvailableEcdsaCurves) {
		return nil, false
	}
	return o.AvailableEcdsaCurves, true
}

// HasAvailableEcdsaCurves returns a boolean if a field has been set.
func (o *CertificateProfileInfoRestResponseV2) HasAvailableEcdsaCurves() bool {
	if o != nil && !isNil(o.AvailableEcdsaCurves) {
		return true
	}

	return false
}

// SetAvailableEcdsaCurves gets a reference to the given []string and assigns it to the AvailableEcdsaCurves field.
func (o *CertificateProfileInfoRestResponseV2) SetAvailableEcdsaCurves(v []string) {
	o.AvailableEcdsaCurves = v
}

// GetAvailableCas returns the AvailableCas field value if set, zero value otherwise.
func (o *CertificateProfileInfoRestResponseV2) GetAvailableCas() []string {
	if o == nil || isNil(o.AvailableCas) {
		var ret []string
		return ret
	}
	return o.AvailableCas
}

// GetAvailableCasOk returns a tuple with the AvailableCas field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateProfileInfoRestResponseV2) GetAvailableCasOk() ([]string, bool) {
	if o == nil || isNil(o.AvailableCas) {
		return nil, false
	}
	return o.AvailableCas, true
}

// HasAvailableCas returns a boolean if a field has been set.
func (o *CertificateProfileInfoRestResponseV2) HasAvailableCas() bool {
	if o != nil && !isNil(o.AvailableCas) {
		return true
	}

	return false
}

// SetAvailableCas gets a reference to the given []string and assigns it to the AvailableCas field.
func (o *CertificateProfileInfoRestResponseV2) SetAvailableCas(v []string) {
	o.AvailableCas = v
}

func (o CertificateProfileInfoRestResponseV2) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CertificateProfileInfoRestResponseV2) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.AvailableKeyAlgs) {
		toSerialize["available_key_algs"] = o.AvailableKeyAlgs
	}
	if !isNil(o.AvailableBitLenghts) {
		toSerialize["available_bit_lenghts"] = o.AvailableBitLenghts
	}
	if !isNil(o.AvailableEcdsaCurves) {
		toSerialize["available_ecdsa_curves"] = o.AvailableEcdsaCurves
	}
	if !isNil(o.AvailableCas) {
		toSerialize["available_cas"] = o.AvailableCas
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CertificateProfileInfoRestResponseV2) UnmarshalJSON(bytes []byte) (err error) {
	varCertificateProfileInfoRestResponseV2 := _CertificateProfileInfoRestResponseV2{}

	if err = json.Unmarshal(bytes, &varCertificateProfileInfoRestResponseV2); err == nil {
		*o = CertificateProfileInfoRestResponseV2(varCertificateProfileInfoRestResponseV2)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "available_key_algs")
		delete(additionalProperties, "available_bit_lenghts")
		delete(additionalProperties, "available_ecdsa_curves")
		delete(additionalProperties, "available_cas")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCertificateProfileInfoRestResponseV2 struct {
	value *CertificateProfileInfoRestResponseV2
	isSet bool
}

func (v NullableCertificateProfileInfoRestResponseV2) Get() *CertificateProfileInfoRestResponseV2 {
	return v.value
}

func (v *NullableCertificateProfileInfoRestResponseV2) Set(val *CertificateProfileInfoRestResponseV2) {
	v.value = val
	v.isSet = true
}

func (v NullableCertificateProfileInfoRestResponseV2) IsSet() bool {
	return v.isSet
}

func (v *NullableCertificateProfileInfoRestResponseV2) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCertificateProfileInfoRestResponseV2(val *CertificateProfileInfoRestResponseV2) *NullableCertificateProfileInfoRestResponseV2 {
	return &NullableCertificateProfileInfoRestResponseV2{value: val, isSet: true}
}

func (v NullableCertificateProfileInfoRestResponseV2) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCertificateProfileInfoRestResponseV2) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
