/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.TransferRequest;
import org.eso.util.dal.TransferRequestDAO;
import org.eso.util.dal.TransferRequestValidator;
import org.eso.util.filesystem.FileSystemOperations;

public class TransferRequestDAOFile
implements TransferRequestDAO {
    static final Logger logger = Logger.getLogger(TransferRequestDAOFile.class);
    private static final String classLogName = "TransferRequestDAOFile";
    private static final String BEGIN = "TRANSFER.REQUEST.BEGIN";
    private static final String END = "TRANSFER.REQUEST.END";
    private static final String EOL = System.getProperty("line.separator");
    Map<TransferRequest.Status, File> statusDirMap = null;
    final String FILEID = "FILEID";
    final String FILENAME = "FILENAME";
    final String UNCOMPRESSED_FILENAME = "UNCOMPRESSED.FILENAME";
    final String TRANSFER_METHOD = "TRANSFER.METHOD";
    final String TRANSFER_PRIORITY = "TRANSFER.PRIORITY";
    final String COMPRESSION_METHOD = "COMPRESSION.METHOD";
    final String SIZE = "SIZE";
    final String UNCOMPRESSED_SIZE = "UNCOMPRESSED.SIZE";
    final String CHECKSUM = "CHECKSUM";
    final String TRANSFER_CATG = "TRANSFER.CATG";
    final String USER = "USER";
    final String DESTDIR = "DESTDIR";
    final String MULTI_FILE_COMPONENTS = "MULTI.FILE.COMPONENTS";
    final String CREATION_TIME = "CREATION.TIME";
    final File incomingDirectory;
    final File processingDirectory;
    final File processedDirectory;
    final File rejectedDirectory;
    String transferRequestExtension;
    TransferRequestValidator transferRequestValidator = null;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public TransferRequestDAOFile(File incomingDirectory, File processingDirectory, File processedDirectory, File rejectedDirectory, String transferRequestExtension, TransferRequestValidator transferRequestValidator) throws DAOException {
        if (incomingDirectory == null || processingDirectory == null || processedDirectory == null || rejectedDirectory == null || transferRequestExtension == null || transferRequestValidator == null) {
            String message = "Missing parameter to instantiate a TransferRequestDAOFile object";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if (!incomingDirectory.exists() || !incomingDirectory.isDirectory()) {
            String message = incomingDirectory + " does not exist ";
            logger.error(message);
            throw new DAOException(message);
        }
        if (!processingDirectory.exists() || !processingDirectory.isDirectory()) {
            String message = processingDirectory + " does not exist ";
            logger.error(message);
            throw new DAOException(message);
        }
        if (!processedDirectory.exists() || !processedDirectory.isDirectory()) {
            String message = processedDirectory + " does not exist ";
            logger.error(message);
            throw new DAOException(message);
        }
        if (!rejectedDirectory.exists() || !rejectedDirectory.isDirectory()) {
            String message = rejectedDirectory + " does not exist ";
            logger.error(message);
            throw new DAOException(message);
        }
        this.incomingDirectory = incomingDirectory;
        this.processingDirectory = processingDirectory;
        this.processedDirectory = processedDirectory;
        this.rejectedDirectory = rejectedDirectory;
        this.transferRequestValidator = transferRequestValidator;
        this.statusDirMap = new HashMap<TransferRequest.Status, File>();
        this.statusDirMap.put(TransferRequest.Status.INCOMING, incomingDirectory);
        this.statusDirMap.put(TransferRequest.Status.PROCESSING, processingDirectory);
        this.statusDirMap.put(TransferRequest.Status.PROCESSED, processedDirectory);
        this.statusDirMap.put(TransferRequest.Status.REJECTED, rejectedDirectory);
        this.transferRequestExtension = transferRequestExtension;
    }

    public TransferRequestDAOFile(File incomingDirectory, String transferRequestExtension, TransferRequestValidator transferRequestValidator) throws DAOException {
        if (incomingDirectory == null || transferRequestExtension == null) {
            String message = "Missing parameter to instantiate a TransferRequestDAOFile object";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if (!incomingDirectory.exists() || !incomingDirectory.isDirectory()) {
            String message = incomingDirectory + " does not exist ";
            logger.error(message);
            throw new DAOException(message);
        }
        this.incomingDirectory = incomingDirectory;
        this.processingDirectory = null;
        this.processedDirectory = null;
        this.rejectedDirectory = null;
        this.statusDirMap = new HashMap<TransferRequest.Status, File>();
        this.statusDirMap.put(TransferRequest.Status.INCOMING, incomingDirectory);
        this.transferRequestExtension = transferRequestExtension;
        this.transferRequestValidator = transferRequestValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TransferRequest> findByStatus(TransferRequest.Status status) throws DAOException {
        String methodLogName = "TransferRequestDAOFile::findByStatus()";
        logger.trace("TransferRequestDAOFile::findByStatus()");
        if (status == null) {
            String message = "Status is missing";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean accepted = file.getName().endsWith(TransferRequestDAOFile.this.transferRequestExtension);
                if (accepted && !file.canRead()) {
                    logger.warn("TransferRequestDAOFile::findByStatus() - Can not read file " + file.getAbsolutePath());
                    accepted = false;
                }
                return accepted;
            }
        };
        File statusDir = this.statusDirMap.get((Object)status);
        if (statusDir == null) {
            String message = "TransferRequestDAOFile::findByStatus() - No directory associated to status " + (Object)((Object)status);
            logger.error(message);
            throw new DAOException(message);
        }
        File[] fileArray = statusDir.listFiles(filter);
        ArrayList<TransferRequest> listFile = new ArrayList<TransferRequest>();
        TransferRequest curTransferRequest = null;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                curTransferRequest = this.load(fileArray[i]);
                continue;
            }
            catch (DAOException daoe) {
                curTransferRequest = null;
                continue;
            }
            finally {
                if (curTransferRequest != null) {
                    curTransferRequest.setStatus(status);
                    listFile.add(curTransferRequest);
                } else {
                    logger.error("Could not build a transfer request from " + fileArray[i]);
                    File destDir = this.statusDirMap.get((Object)TransferRequest.Status.REJECTED);
                    if (destDir == null) {
                        String message = "No directory associated to " + (Object)((Object)TransferRequest.Status.REJECTED);
                        logger.error(message);
                        throw new DAOException(message);
                    }
                    if (FileSystemOperations.moveToDir(fileArray[i], destDir)) {
                        logger.info("TransferRequestDAOFile::findByStatus() - " + fileArray[i] + " moved to " + this.statusDirMap.get((Object)TransferRequest.Status.REJECTED));
                    } else {
                        logger.error("TransferRequestDAOFile::findByStatus() -  Could not move " + fileArray[i].getAbsolutePath() + "to " + this.statusDirMap.get((Object)TransferRequest.Status.REJECTED));
                    }
                }
            }
        }
        return listFile;
    }

    @Override
    public int updateStatus(TransferRequest transferRequest, TransferRequest.Status status) throws DAOException {
        String methodLogName = "TransferRequestDAOFile::updateStatus()";
        logger.trace("TransferRequestDAOFile::updateStatus()");
        int nbUpdatedFiles = 0;
        if (transferRequest == null) {
            String message = "TransferRequestDAOFile::updateStatus() No transfer request available";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if (status == null) {
            String message = "No status value available";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if (transferRequest.getRequestId() == null) {
            String message = "Transfer request should get an identifier";
            logger.error(message);
            throw new DAOException(message);
        }
        String trFileName = transferRequest.getRequestId();
        TransferRequest.Status trStatus = transferRequest.getStatus();
        if (trStatus == null) {
            String message = "No status associated to transfer request " + trFileName;
            logger.error(message);
            throw new DAOException(message);
        }
        File currentDir = transferRequest.getLocation();
        if (currentDir == null) {
            currentDir = this.statusDirMap.get((Object)trStatus);
        }
        if (currentDir == null) {
            String message = "Location of transfer request " + trFileName + " is unknown";
            logger.error(message);
            throw new DAOException(message);
        }
        File transferRequestFile = new File(currentDir.getAbsolutePath() + File.separatorChar + trFileName);
        if (!transferRequestFile.exists()) {
            String message = transferRequestFile + " does not exist";
            logger.error(message);
            throw new DAOException(message);
        }
        File destDir = this.statusDirMap.get((Object)status);
        if (destDir == null) {
            String message = "No directory associated to " + (Object)((Object)status);
            logger.error(message);
            throw new DAOException(message);
        }
        if (FileSystemOperations.moveToDir(transferRequestFile, destDir)) {
            transferRequest.setStatus(status);
            logger.debug("TransferRequestDAOFile::updateStatus() - " + transferRequestFile.getAbsolutePath() + " moved to " + this.statusDirMap.get((Object)status));
            nbUpdatedFiles = 1;
        } else {
            logger.error("TransferRequestDAOFile::updateStatus() -  Could not move " + transferRequestFile.getAbsolutePath() + " to " + this.statusDirMap.get((Object)status));
            nbUpdatedFiles = 0;
        }
        return nbUpdatedFiles;
    }

    @Override
    public int save(TransferRequest transferRequest) throws DAOException {
        String TEMP_FILE_EXT = ".tmp";
        String methodLogName = "TransferRequestDAOFile::save()";
        int nbSavedTransferRequest = 0;
        if (transferRequest == null) {
            throw new IllegalArgumentException(methodLogName + " - transferRequest must not be null");
        }
        if (!this.transferRequestValidator.isValid(transferRequest)) {
            String message = methodLogName + " - Cannot save a non valid TransferRequest.";
            logger.error(message);
            throw new DAOException(message);
        }
        File trDir = this.statusDirMap.get((Object)TransferRequest.Status.INCOMING);
        String fileName = transferRequest.getFileName();
        if (fileName == null) {
            String message = "Could not build a file name as file name field is null";
            logger.error(message);
            throw new DAOException(message);
        }
        File proviFile = new File(fileName);
        fileName = trDir.getAbsolutePath() + File.separatorChar + proviFile.getName() + this.transferRequestExtension;
        String tempFileName = fileName + ".tmp";
        try {
            String currentCard;
            String value;
            String key;
            FileWriter trFileWriter = new FileWriter(new File(tempFileName));
            trFileWriter.write(BEGIN);
            trFileWriter.write(EOL);
            if (transferRequest.getFileId() != null) {
                key = "FILEID";
                value = transferRequest.getFileId();
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getFileName() != null) {
                key = "FILENAME";
                value = transferRequest.getFileName();
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getUncompressedFileName() != null) {
                key = "UNCOMPRESSED.FILENAME";
                value = transferRequest.getUncompressedFileName();
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getTransferMethod() != null) {
                key = "TRANSFER.METHOD";
                value = transferRequest.getTransferMethod();
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getTransferPriority() != null) {
                key = "TRANSFER.PRIORITY";
                value = String.valueOf(transferRequest.getTransferPriority());
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getCompressionMethod() != null) {
                key = "COMPRESSION.METHOD";
                value = transferRequest.getCompressionMethod();
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getSize() != null) {
                key = "SIZE";
                value = String.valueOf(transferRequest.getSize());
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getUncompressedSize() != null) {
                key = "UNCOMPRESSED.SIZE";
                value = String.valueOf(transferRequest.getUncompressedSize());
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getChecksum() != null) {
                key = "CHECKSUM";
                value = String.valueOf(transferRequest.getChecksum());
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getTransferCatg() != null) {
                key = "TRANSFER.CATG";
                value = transferRequest.getTransferCatg();
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getUser() != null) {
                key = "USER";
                value = transferRequest.getUser();
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getDestDir() != null) {
                key = "DESTDIR";
                value = transferRequest.getDestDir();
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            if (transferRequest.getMultiFileComponents() != null) {
                key = "MULTI.FILE.COMPONENTS";
                value = transferRequest.getMultiFileComponents();
                currentCard = key + " = " + value;
                trFileWriter.write(currentCard);
                trFileWriter.write(EOL);
            }
            key = "CREATION.TIME";
            Long creationTime = System.currentTimeMillis();
            currentCard = key + " = " + this.dateFormat.format(creationTime);
            trFileWriter.write(currentCard);
            transferRequest.setCreationTime(creationTime);
            trFileWriter.write(EOL);
            trFileWriter.write(END);
            trFileWriter.close();
        }
        catch (IOException ioe) {
            String message = "Could not open TRQ temporary file " + tempFileName + " IOException " + ioe.getMessage();
            logger.error(message);
            throw new DAOException(message);
        }
        File transferRequestFile = new File(tempFileName);
        File destFile = new File(fileName);
        if (!transferRequestFile.renameTo(destFile)) {
            String message = "Could not rename " + tempFileName + " to " + fileName;
            logger.error(message);
            transferRequest.setStatus(TransferRequest.Status.REJECTED);
            throw new DAOException(message);
        }
        transferRequest.setStatus(TransferRequest.Status.INCOMING);
        transferRequest.setRequestId(destFile.getName());
        logger.debug(destFile.getAbsolutePath() + " successfully created");
        nbSavedTransferRequest = 1;
        return nbSavedTransferRequest;
    }

    @Override
    public int delete(TransferRequest transferRequest) throws DAOException {
        String thisMethod = "TransferRequestDAOFile::delete()";
        int nbDeletedTransferRequests = 0;
        if (transferRequest == null) {
            throw new IllegalArgumentException(thisMethod + " - transferRequest must not be null");
        }
        File trDir = this.statusDirMap.get((Object)transferRequest.getStatus());
        if (trDir == null) {
            String message = thisMethod + " - Status not valid for transfer request";
            logger.error(message);
            throw new DAOException(message);
        }
        String fileName = transferRequest.getRequestId();
        if (fileName == null) {
            String message = "No identifier for the transfer request";
            logger.error(message);
            throw new DAOException(message);
        }
        File trFile = new File(trDir.getAbsolutePath() + File.separatorChar + fileName);
        if (!trFile.exists()) {
            String message = thisMethod + " - file " + trFile + " does not exist";
            logger.error(message);
            throw new DAOException(message);
        }
        if (!FileSystemOperations.delete(trFile)) {
            String message = "Could not delete " + trFile;
            logger.error(message);
            throw new DAOException(message);
        }
        logger.debug(trFile + " successfully deleted");
        nbDeletedTransferRequests = 1;
        return nbDeletedTransferRequests;
    }

    @Override
    public Boolean isValid(TransferRequest transferRequest) {
        String methodLogName = "TransferRequestDAOFile::isValid";
        if (transferRequest == null) {
            throw new IllegalArgumentException(methodLogName + " - transferRequest must not be null");
        }
        return this.transferRequestValidator.isValid(transferRequest);
    }

    private TransferRequest load(File transferRequestFile) throws DAOException {
        BufferedReader trFileReader;
        String methodLogName = "TransferRequestDAOFile::load";
        logger.trace(methodLogName);
        TransferRequest transferRequest = new TransferRequest();
        transferRequest.setRequestId(transferRequestFile.getName());
        try {
            logger.debug(methodLogName + " - Opening file " + transferRequestFile);
            trFileReader = new BufferedReader(new FileReader(transferRequestFile));
        }
        catch (FileNotFoundException fnfe) {
            String message = "Could not open file " + transferRequestFile + " : " + fnfe.getMessage();
            logger.error(methodLogName + " - " + message);
            throw new DAOException(message);
        }
        boolean endKeywordFound = false;
        try {
            String currentLine = trFileReader.readLine();
            if (currentLine == null) {
                String message = "File " + transferRequestFile + " is empty.";
                logger.error(methodLogName + " - " + message);
                throw new DAOException(message);
            }
            if (!currentLine.equals(BEGIN)) {
                String message = "File " + transferRequestFile + " is not a valid TransferRequest" + " because it doesn't start with '" + BEGIN + "'.";
                logger.error(methodLogName + " - " + message);
                throw new DAOException(message);
            }
            while ((currentLine = trFileReader.readLine()) != null) {
                logger.debug(methodLogName + " - Parsing line: " + currentLine);
                if (endKeywordFound) {
                    String message = "File '" + transferRequestFile + "' is not a valid TransferRequest" + " because it doesn't end with '" + END + "'.";
                    logger.error(methodLogName + " - " + message);
                    throw new DAOException(message);
                }
                if (currentLine.equals(END)) {
                    endKeywordFound = true;
                    continue;
                }
                if (currentLine.trim().equals("")) continue;
                String[] currentCard = currentLine.split("=");
                if (currentCard.length != 2) {
                    String message = "Could not parse line " + currentLine;
                    logger.error(methodLogName + " - " + message);
                    throw new DAOException(message);
                }
                if (this.setTrField(transferRequest, currentCard[0].trim(), currentCard[1].trim()) == 0) continue;
                String message = "Failed to set value " + currentCard[1] + " associated to " + currentCard[0] + " from " + transferRequestFile;
                logger.error(message);
                throw new DAOException(message);
            }
            if (!endKeywordFound) {
                String message = "File '" + transferRequestFile + "' is not a valid TransferRequest" + " because it doesn't end with '" + END + "'.";
                logger.error(methodLogName + " - " + message);
                throw new DAOException(message);
            }
        }
        catch (IOException ioe) {
            String message = "An IO error occurred whilst reading from TRQ file '" + transferRequestFile + "' : " + ioe.getMessage();
            logger.error(methodLogName + " - " + message);
            throw new DAOException(message);
        }
        finally {
            try {
                logger.debug(methodLogName + " - Closing file " + transferRequestFile);
                trFileReader.close();
            }
            catch (IOException ioe) {
                String message = "Could not close file " + transferRequestFile + " : " + ioe.getMessage();
                logger.error(methodLogName + " - " + message);
                throw new DAOException(message);
            }
        }
        return transferRequest;
    }

    private int setTrField(TransferRequest transferRequest, String key, String value) {
        int retStatus = 0;
        try {
            if (key.compareTo("FILEID") == 0) {
                transferRequest.setFileId(value);
            } else if (key.compareTo("FILENAME") == 0) {
                transferRequest.setFileName(value);
            } else if (key.compareTo("UNCOMPRESSED.FILENAME") == 0) {
                transferRequest.setUncompressedFileName(value);
            } else if (key.compareTo("TRANSFER.METHOD") == 0) {
                transferRequest.setTransferMethod(value);
            } else if (key.compareTo("TRANSFER.PRIORITY") == 0) {
                transferRequest.setTransferPriority(Integer.valueOf(value));
            } else if (key.compareTo("COMPRESSION.METHOD") == 0) {
                transferRequest.setCompressionMethod(value);
            } else if (key.compareTo("SIZE") == 0) {
                transferRequest.setSize(Long.valueOf(value));
            } else if (key.compareTo("UNCOMPRESSED.SIZE") == 0) {
                transferRequest.setUncompressedSize(Long.valueOf(value));
            } else if (key.compareTo("CHECKSUM") == 0) {
                transferRequest.setChecksum(value);
            } else if (key.compareTo("TRANSFER.CATG") == 0) {
                transferRequest.setTransferCatg(value);
            } else if (key.compareTo("USER") == 0) {
                transferRequest.setUser(value);
            } else if (key.compareTo("DESTDIR") == 0) {
                transferRequest.setDestDir(value);
            } else if (key.compareTo("MULTI.FILE.COMPONENTS") == 0) {
                transferRequest.setMultiFileComponents(value);
            } else if (key.compareTo("CREATION.TIME") == 0) {
                transferRequest.setCreationTime(new Long(this.dateFormat.parse(value).getTime()));
            } else {
                logger.error(key + " is not a valid keyword");
                retStatus = -1;
            }
        }
        catch (NumberFormatException ne) {
            logger.error("NumberFormatException raised for " + key + " Bad value : " + value);
            retStatus = -1;
        }
        catch (ParseException e2) {
            logger.error("ParseException raised for " + key + " Bad value : " + value);
            retStatus = -1;
        }
        return retStatus;
    }

    @Override
    public List<TransferRequest> findByDateGreaterThan(Date startDate, String instrumentList, TransferRequest.Status status, TransferRequest.FIELDS orderBy, TransferRequestDAO.SortingOrder sortingOrder) throws DAOException {
        String methodLogName = "TransferRequestDAOFile::findByDateGreaterThan()";
        ArrayList<TransferRequest> emptyList = new ArrayList<TransferRequest>();
        logger.warn("TransferRequestDAOFile::findByDateGreaterThan() - Method not implemented");
        return emptyList;
    }

    @Override
    public List<TransferRequest> findByDate(Date obsDate, String instrumentList, List<TransferRequest.Status> statusList, String fileType, List<TransferRequest.FIELDS> orderByList, TransferRequestDAO.SortingOrder sortingOrder) throws DAOException {
        String methodLogName = "TransferRequestDAOFile::findByDate()";
        ArrayList<TransferRequest> emptyList = new ArrayList<TransferRequest>();
        logger.warn("TransferRequestDAOFile::findByDate() - Method not implemented");
        return emptyList;
    }

    @Override
    public void deleteByStatus(TransferRequest.Status status) throws DAOException {
        String methodLogName = "TransferRequestDAOFile::deleteByStatus()";
        logger.trace("TransferRequestDAOFile::deleteByStatus()");
        if (status == null) {
            String message = "Status is missing";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        File statusDir = this.statusDirMap.get((Object)status);
        List<TransferRequest> trqs = this.findByStatus(status);
        for (TransferRequest trq : trqs) {
            File trqFile = new File(statusDir.getAbsolutePath() + System.getProperty("file.separator") + trq.getRequestId());
            if (trqFile.delete()) {
                logger.info(trqFile.getAbsolutePath() + " successfully deleted");
                continue;
            }
            throw new DAOException("unable to delete " + trqFile.getAbsolutePath());
        }
    }
}

