/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.SimpleNode;

public class ASTProduct
extends SimpleNode {
    public String name;
    static Logger logger = Logger.getLogger(ASTProduct.class);

    public ASTProduct(int id) {
        super(id);
    }

    public ASTProduct(OcaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        String proExt;
        logger.trace("interpret() called.");
        state.symtab = new Hashtable();
        int k = this.jjtGetNumChildren();
        for (int i = 0; i < k; ++i) {
            this.jjtGetChild(i).interpret(state);
        }
        Hashtable<String, String> virtualProduct = new Hashtable<String, String>(state.inputFileSymtab);
        virtualProduct.putAll(state.symtab);
        virtualProduct.put("VIRTUAL", "");
        String dpId = (String)state.inputFileSymtab.get("DP.ID");
        String proCatg = (String)state.symtab.get("PRO.CATG");
        if (proCatg == null) {
            logger.warn("PRO.CATG is not defined for product " + this.name);
        }
        if ((proExt = (String)state.symtab.get("PRO.EXT")) == null) {
            logger.warn("PRO.EXT is not defined for product " + this.name);
            proExt = "0001.fits";
            state.symtab.put("PRO.EXT", proExt);
        }
        String pipefile = "r." + dpId + "_" + proExt;
        virtualProduct.put("PIPEFILE", pipefile);
        state.globVirtualProducts.add(virtualProduct);
    }
}

