/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.fits;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import nom.tam.fits.FitsFactory;
import org.apache.log4j.Logger;
import org.eso.oca.fits.DataTransportFormatHandler;
import org.eso.oca.fits.FileHandlerException;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.TypedHeaderCardException;

public class HDRHandler
implements DataTransportFormatHandler {
    static Logger logger = Logger.getLogger(HDRHandler.class);
    public static final int PRIMARY_HDU_INDEX = 0;
    private BufferedReader hdrFile;
    private String hdrFilename;
    private boolean headersInMemory = false;
    private TypedHeaderCard[][] headers;
    private Map[] headerMaps;
    private boolean allowDuplicates;

    public HDRHandler(String filename) throws FileHandlerException {
        FitsFactory.setUseHierarch(true);
        try {
            this.hdrFile = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException fnfe) {
            String message = "Could not open HDR file '" + filename + "'.";
            logger.error(message);
            throw new FileHandlerException(message, fnfe);
        }
        this.hdrFilename = filename;
    }

    public HDRHandler(String filename, boolean allowDuplicates) throws FileHandlerException {
        FitsFactory.setUseHierarch(true);
        try {
            this.hdrFile = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException fnfe) {
            String message = "Could not open HDR file '" + filename + "'.";
            logger.error(message);
            throw new FileHandlerException(message, fnfe);
        }
        this.allowDuplicates = allowDuplicates;
        this.hdrFilename = filename;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypedHeaderCard[][] getFITSCards() throws FileHandlerException, TypedHeaderCardException {
        if (this.headersInMemory) return this.headers;
        LinkedList headerList = new LinkedList();
        LinkedList<TypedHeaderCard> currentHeader = new LinkedList<TypedHeaderCard>();
        TreeSet<String> uniqueKeywords = new TreeSet<String>();
        try {
            String currentLine;
            while ((currentLine = this.hdrFile.readLine()) != null) {
                TypedHeaderCard currentCard;
                try {
                    currentCard = new TypedHeaderCard(currentLine);
                }
                catch (Exception e2) {
                    String message = "Could not use FITS header card '" + currentLine + "' to construct a TypedHeaderCard object.";
                    logger.error(message);
                    throw new TypedHeaderCardException(message, e2);
                }
                String key = currentCard.getKey();
                if (uniqueKeywords.contains(key)) {
                    if (!this.allowDuplicates) throw new TypedHeaderCardException("duplicated keyword found: " + key);
                    logger.warn("duplicated keyword found: " + key);
                } else if (!(key.equals("COMMENT") || key.equals("HISTORY") || key.equals(""))) {
                    uniqueKeywords.add(key);
                }
                currentHeader.add(currentCard);
                if (!currentCard.getKey().equals("END")) continue;
                headerList.add(currentHeader);
                currentHeader = new LinkedList();
                uniqueKeywords.clear();
            }
        }
        catch (IOException ioe) {
            String message = "An IO error occurred whilst reading from HDR file '" + this.hdrFilename + "'.";
            logger.error(message);
            throw new FileHandlerException(message, ioe);
        }
        int numHeaders = headerList.size();
        this.headers = new TypedHeaderCard[numHeaders][];
        int i = 0;
        Iterator iterator = headerList.iterator();
        TypedHeaderCard[] modelArray = new TypedHeaderCard[]{};
        while (iterator.hasNext()) {
            this.headers[i++] = ((LinkedList)iterator.next()).toArray(modelArray);
        }
        this.headerMaps = new Map[numHeaders];
        this.headersInMemory = true;
        this.hdrFile = null;
        return this.headers;
    }

    @Override
    public TypedHeaderCard[] getFITSCards(int header) throws FileHandlerException, TypedHeaderCardException {
        if (header >= this.getFITSCards().length) {
            String message = "Header " + header + " could not be found in HDR file '" + this.hdrFilename + "'.";
            logger.error(message);
            throw new FileHandlerException(message);
        }
        return this.getFITSCards()[header];
    }

    @Override
    public TypedHeaderCard[] getFITSCards(int header, String[] requestedCards) throws FileHandlerException, TypedHeaderCardException {
        if (header >= this.getFITSCards().length) {
            String message = "Header " + header + " could not be found in HDR file '" + this.hdrFilename + "'.";
            logger.error(message);
            throw new FileHandlerException(message);
        }
        Map headerCards = this.getFITSCardMap(header);
        TypedHeaderCard[] results = new TypedHeaderCard[requestedCards.length];
        for (int i = 0; i < requestedCards.length; ++i) {
            String currentKey = TypedHeaderCard.formatKey(requestedCards[i], 2);
            TypedHeaderCard currentCard = (TypedHeaderCard)headerCards.get(currentKey);
            if (currentCard == null) {
                try {
                    results[i] = new TypedHeaderCard(currentKey, false);
                    continue;
                }
                catch (Exception e2) {
                    String message = "Could not use undefined keyword '" + currentKey + "' to construct a TypedHeaderCard object " + "with type set to UNDEFINED.";
                    logger.error(message);
                    throw new TypedHeaderCardException(message, e2);
                }
            }
            results[i] = currentCard;
        }
        return results;
    }

    private Map getFITSCardMap(int header) throws FileHandlerException, TypedHeaderCardException {
        if (header >= this.getFITSCards().length) {
            String message = "Header " + header + " could not be found in HDR file '" + this.hdrFilename + "'.";
            logger.error(message);
            throw new FileHandlerException(message);
        }
        if (this.headerMaps[header] == null) {
            this.headerMaps[header] = new Hashtable((int)((double)this.getFITSCards().length / 0.75) + 1);
            TypedHeaderCard[] headerCards = this.getFITSCards(header);
            for (int i = 0; i < headerCards.length; ++i) {
                this.headerMaps[header].put(headerCards[i].getKey(), headerCards[i]);
            }
        }
        return this.headerMaps[header];
    }

    @Override
    public int getNumberOfHDUs() throws FileHandlerException, TypedHeaderCardException {
        return this.getFITSCards().length;
    }

    @Override
    public void dispose() {
        try {
            this.hdrFile.close();
        }
        catch (IOException e2) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

