/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.fits;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;
import org.apache.log4j.Logger;
import org.eso.oca.fits.DataTransportFormatHandler;
import org.eso.oca.fits.FileHandlerException;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.TypedHeaderCardException;

public class FITSHandler
implements DataTransportFormatHandler {
    static Logger logger = Logger.getLogger(FITSHandler.class);
    public static final int PRIMARY_HDU_INDEX = 0;
    private Fits fitsFile;
    private String fitsFilename;
    private boolean readAllHDUs = false;
    private boolean allowduplicates = true;

    public FITSHandler(String filename) throws FileHandlerException {
        this(filename, true);
    }

    public FITSHandler(String filename, boolean allowDuplicates) throws FileHandlerException {
        FitsFactory.setUseHierarch(true);
        try {
            this.fitsFile = new Fits(filename);
        }
        catch (FitsException fe) {
            String message = "Could not open FITS file '" + filename + "'.";
            logger.error(message);
            throw new FileHandlerException(message, fe);
        }
        this.allowduplicates = allowDuplicates;
        this.fitsFilename = filename;
    }

    public FITSHandler(String filename, InputStream stream, boolean compressed) throws FileHandlerException {
        FitsFactory.setUseHierarch(true);
        try {
            this.fitsFile = new Fits(stream, compressed);
        }
        catch (FitsException fe) {
            String message = "Could not open FITS file '" + filename + "'.";
            logger.error(message);
            throw new FileHandlerException(message, fe);
        }
        this.fitsFilename = filename;
    }

    @Override
    public TypedHeaderCard[] getFITSCards(int hdu) throws FileHandlerException, TypedHeaderCardException {
        BasicHDU selectedHDU;
        try {
            selectedHDU = this.fitsFile.getHDU(hdu);
        }
        catch (Exception e2) {
            String message = "Could not retrieve HDU " + hdu + " from FITS file '" + this.fitsFilename + "'.";
            logger.error(message);
            throw new FileHandlerException(message, e2);
        }
        if (selectedHDU == null) {
            String message = "HDU " + hdu + " could not be found in FITS file '" + this.fitsFilename + "'.";
            logger.error(message);
            throw new FileHandlerException(message);
        }
        Header header = selectedHDU.getHeader();
        Cursor iterator = header.iterator();
        TypedHeaderCard[] results = new TypedHeaderCard[header.getNumberOfCards()];
        int i = 0;
        while (iterator.hasNext()) {
            HeaderCard currentCard = (HeaderCard)iterator.next();
            try {
                results[i++] = new TypedHeaderCard(currentCard);
            }
            catch (Exception e3) {
                String message = "Could not use FITS header card '" + currentCard + "' to construct a TypedHeaderCard object.";
                logger.error(message);
                throw new TypedHeaderCardException(message, e3);
            }
        }
        this.checkDuplicates(header);
        return results;
    }

    @Override
    public TypedHeaderCard[] getFITSCards(int hdu, String[] requestedCards) throws FileHandlerException, TypedHeaderCardException {
        BasicHDU selectedHDU;
        try {
            selectedHDU = this.fitsFile.getHDU(hdu);
        }
        catch (Exception e2) {
            String message = "Could not retrieve HDU " + hdu + " from FITS file '" + this.fitsFilename + "'.";
            logger.error(message);
            throw new FileHandlerException(message, e2);
        }
        if (selectedHDU == null) {
            String message = "HDU " + hdu + " could not be found in FITS file '" + this.fitsFilename + "'.";
            logger.error(message);
            throw new FileHandlerException(message);
        }
        Header header = selectedHDU.getHeader();
        TypedHeaderCard[] results = new TypedHeaderCard[requestedCards.length];
        for (int i = 0; i < requestedCards.length; ++i) {
            String currentKey = TypedHeaderCard.formatKey(requestedCards[i], 2);
            HeaderCard currentCard = header.findCard(currentKey);
            if (currentCard == null) {
                try {
                    results[i] = new TypedHeaderCard(currentKey, false);
                    continue;
                }
                catch (Exception e3) {
                    String message = "Could not use undefined keyword '" + currentKey + "' to construct a TypedHeaderCard object " + "with type set to UNDEFINED.";
                    logger.error(message);
                    throw new TypedHeaderCardException(message, e3);
                }
            }
            try {
                results[i] = new TypedHeaderCard(currentCard);
                continue;
            }
            catch (Exception e4) {
                String message = "Could not use FITS header card '" + currentCard + "' to construct a TypedHeaderCard object.";
                logger.error(message);
                throw new TypedHeaderCardException(message, e4);
            }
        }
        this.checkDuplicates(header);
        return results;
    }

    private void checkDuplicates(Header header) throws TypedHeaderCardException {
        if (header.hadDuplicates()) {
            String msg = "duplicated keywords found: ";
            Iterator<HeaderCard> it = header.getDuplicates().iterator();
            while (it.hasNext()) {
                msg = msg + it.next().getKey();
                if (!it.hasNext()) continue;
                msg = msg + ", ";
            }
            if (this.allowduplicates) {
                logger.warn(msg);
            } else {
                throw new TypedHeaderCardException(msg);
            }
        }
    }

    @Override
    public int getNumberOfHDUs() throws FileHandlerException, TypedHeaderCardException {
        if (!this.readAllHDUs) {
            try {
                int i = 0;
                while (this.fitsFile.getHDU(i) != null) {
                    ++i;
                }
                this.readAllHDUs = true;
            }
            catch (Exception e2) {
                throw new FileHandlerException(e2.getMessage());
            }
        }
        return this.fitsFile.getNumberOfHDUs();
    }

    @Override
    public void dispose() {
        try {
            this.fitsFile.getStream().close();
        }
        catch (IOException e2) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

