/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eso.cpl.EnumConstraint;
import org.eso.cpl.ParameterConstraint;
import org.eso.cpl.ParameterType;
import org.eso.cpl.ParameterValueException;
import org.eso.cpl.RangeConstraint;

public class ConstraintTest
extends TestCase {
    public ConstraintTest(String name) {
        super(name);
    }

    public void testEnumConstraint() throws ParameterValueException {
        Object[] options = new String[]{"cow", "pig", "mouse"};
        List<String> optList = Arrays.asList(options);
        EnumConstraint cons1 = new EnumConstraint(options);
        EnumConstraint cons2 = new EnumConstraint(optList);
        ConstraintTest.assertEquals(new ArrayList<String>(optList), new ArrayList(cons1.getOptions()));
        ConstraintTest.assertNotNull(cons1.getDescription());
        ConstraintTest.assertEquals(new ArrayList(cons1.getOptions()), new ArrayList(cons2.getOptions()));
        ConstraintTest.assertEquals(cons1.getDescription(), cons2.getDescription());
        this.goodValue(cons1, "pig");
        this.goodValue(cons1, "cow");
        this.goodValue(cons1, "mouse");
        this.badValue(cons1, "sheep");
    }

    public void testRangeConstraint() throws ParameterValueException {
        int imin = 23;
        int imax = 801;
        Integer min = new Integer(imin);
        Integer max = new Integer(imax);
        RangeConstraint cons = new RangeConstraint(ParameterType.INT, min, max);
        ConstraintTest.assertEquals(min, cons.getMinimum());
        ConstraintTest.assertEquals(max, cons.getMaximum());
        this.badValue(cons, new Integer(imin - 1));
        this.goodValue(cons, new Integer(imin));
        this.goodValue(cons, new Integer(imin + 1));
        this.goodValue(cons, new Integer(imax - 1));
        this.goodValue(cons, new Integer(imax));
        this.badValue(cons, new Integer(imax + 1));
    }

    private void goodValue(ParameterConstraint cons, Object value) throws ParameterValueException {
        cons.checkValue(value);
    }

    private void badValue(ParameterConstraint cons, Object value) {
        try {
            cons.checkValue(value);
            ConstraintTest.fail();
        }
        catch (ParameterValueException parameterValueException) {
            // empty catch block
        }
    }

    public static TestSuite suite() {
        return new TestSuite(ConstraintTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(ConstraintTest.suite());
    }
}

