/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.eso.cpl.CPLException;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameLevel;
import org.eso.cpl.FrameList;
import org.eso.cpl.FrameType;
import org.eso.cpl.NamingScheme;
import org.eso.cpl.Parameter;
import org.eso.cpl.ParameterValueException;
import org.eso.cpl.Recipe;
import org.eso.cpl.RecipeLibrary;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.LibraryLoader;
import org.eso.cpl.jni.PluginLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class StateLoader {
    private static Map groupMap_ = new HashMap();
    private static Map levelMap_;
    private static Map typeMap_;
    private static Map namerMap_;
    private LibraryLoader libLoader_;
    private Element recipeEl_;
    private Element libraryEl_;
    private Element parametersEl_;
    private Element inFramesEl_;
    private Element productsEl_;

    public StateLoader(InputStream istrm, LibraryLoader libLoader) throws IOException {
        this.libLoader_ = libLoader;
        StreamSource xsrc = new StreamSource(istrm);
        DOMResult xres = new DOMResult();
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(xsrc, xres);
            Document doc = (Document)xres.getNode();
            Element docel = doc.getDocumentElement();
            NodeList requests = doc.getElementsByTagName("request");
            if (requests.getLength() < 1) {
                throw new IOException("No <request> element found in stream");
            }
            this.readRequestElement((Element)requests.item(0));
        }
        catch (TransformerException e2) {
            throw (IOException)new IOException("XML Error: " + e2.getMessage()).initCause(e2);
        }
    }

    private void readRequestElement(Element requestEl) {
        String name;
        Element childEl;
        Node node;
        StateLoader.checkElementTag(requestEl, "request");
        for (node = requestEl.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            childEl = (Element)node;
            name = childEl.getTagName();
            if (name.equals("recipe")) {
                this.recipeEl_ = childEl;
                continue;
            }
            if (name.equals("frames")) {
                this.inFramesEl_ = childEl;
                continue;
            }
            if (!name.equals("products")) continue;
            this.productsEl_ = childEl;
        }
        if (this.recipeEl_ != null) {
            for (node = this.recipeEl_.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                childEl = (Element)node;
                name = childEl.getTagName();
                if (name.equals("library")) {
                    this.libraryEl_ = childEl;
                    continue;
                }
                if (!name.equals("parameters")) continue;
                this.parametersEl_ = childEl;
            }
        }
    }

    public Recipe getRecipe() throws CPLException {
        if (this.recipeEl_ == null) {
            return null;
        }
        if (this.libraryEl_ == null) {
            return null;
        }
        String recName = StateLoader.getAttributeValue(this.recipeEl_, "name");
        String recVers = StateLoader.getAttributeValue(this.recipeEl_, "version");
        String libName = StateLoader.getAttributeValue(this.libraryEl_, "name");
        String libLoc = StateLoader.getAttributeValue(this.libraryEl_, "location");
        String libClass = StateLoader.getAttributeValue(this.libraryEl_, "class");
        if (libClass.equals(PluginLibrary.class.getName())) {
            if (this.libLoader_ == null) {
                throw new CPLException("No LibraryLoader specified");
            }
            RecipeLibrary pluglib = null;
            if (pluglib == null && libLoc != null) {
                try {
                    pluglib = this.libLoader_.getLibrary(libLoc);
                }
                catch (LTDLException e2) {
                    // empty catch block
                }
            }
            if (pluglib == null) {
                try {
                    pluglib = this.libLoader_.getLibrary(libName);
                }
                catch (LTDLException e3) {
                    throw new CPLException(e3.getMessage(), e3);
                }
            }
            if (pluglib == null) {
                throw new CPLException("PluginLibrary " + pluglib + " not found");
            }
            Recipe[] recipes = pluglib.getRecipes();
            for (int i = 0; i < recipes.length; ++i) {
                Recipe recipe = recipes[i];
                if (!recipe.getName().equals(recName)) continue;
                if (Long.toString(recipe.getVersion()).equals(recVers)) {
                    return recipe;
                }
                throw new CPLException("Recipe version mismatch for " + recName + ": " + recipe.getVersion() + " != " + recVers);
            }
            throw new CPLException("No recipe " + recName + " found in " + pluglib);
        }
        throw new CPLException("Unknown recipe library class " + libClass);
    }

    public void setParameterValues(Parameter[] params) throws ParameterValueException {
        if (this.parametersEl_ != null) {
            this.setParameterValues(params, this.parametersEl_);
        }
    }

    public FrameList getInputFrames() {
        return this.inFramesEl_ == null ? null : this.readFrameList(this.inFramesEl_);
    }

    public String getProductRoot() {
        return this.productsEl_ == null ? null : StateLoader.getAttributeValue(this.productsEl_, "directory");
    }

    public NamingScheme getNamingScheme() {
        String schemeName = this.productsEl_ == null ? null : StateLoader.getAttributeValue(this.productsEl_, "naming");
        return (NamingScheme)namerMap_.get(schemeName);
    }

    private void setParameterValue(Map paramMap, Element paramEl) throws ParameterValueException {
        StateLoader.checkElementTag(paramEl, "parameter");
        String name = StateLoader.getAttributeValue(paramEl, "name");
        if (!paramMap.containsKey(name)) {
            throw new ParameterValueException("Ignoring parameter \"" + name + "\" not in recipe");
        }
        Parameter param = (Parameter)paramMap.get(name);
        String value = StateLoader.getAttributeValue(paramEl, "value");
        param.setValueFromString(value);
    }

    private void setParameterValues(Parameter[] params, Element paramsEl) throws ParameterValueException {
        StateLoader.checkElementTag(paramsEl, "parameters");
        HashMap<String, Parameter> paramMap = new HashMap<String, Parameter>();
        for (int i = 0; i < params.length; ++i) {
            Parameter param = params[i];
            paramMap.put(param.getName(), param);
        }
        for (Node child = paramsEl.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childEl;
            if (!(child instanceof Element) || !(childEl = (Element)child).getTagName().equals("parameter")) continue;
            this.setParameterValue(paramMap, childEl);
        }
    }

    private Frame readFrame(Element frameEl) {
        StateLoader.checkElementTag(frameEl, "frame");
        Frame frame = new Frame();
        frame.setFile(new File(StateLoader.getAttributeValue(frameEl, "filename")));
        frame.setTag(StateLoader.getAttributeValue(frameEl, "tag"));
        frame.setGroup(StateLoader.getFrameGroup(StateLoader.getAttributeValue(frameEl, "group")));
        frame.setLevel(StateLoader.getFrameLevel(StateLoader.getAttributeValue(frameEl, "level")));
        frame.setType(StateLoader.getFrameType(StateLoader.getAttributeValue(frameEl, "type")));
        return frame;
    }

    private FrameList readFrameList(Element framesEl) {
        StateLoader.checkElementTag(framesEl, "frames");
        FrameList framelist = new FrameList();
        for (Node child = framesEl.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childEl;
            if (!(child instanceof Element) || !(childEl = (Element)child).getTagName().equals("frame")) continue;
            framelist.add(this.readFrame(childEl));
        }
        return framelist;
    }

    private static String getAttributeValue(Element el, String attname) {
        return el.hasAttribute(attname) ? StateLoader.unescapeAttributeValue(el.getAttribute(attname)) : null;
    }

    private static String unescapeAttributeValue(String text) {
        return text.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&apos;", "'").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
    }

    private static void checkElementTag(Element el, String tagname) {
        if (!el.getTagName().equals(tagname)) {
            throw new IllegalArgumentException("Wrong element type: <" + el.getTagName() + "> not <" + tagname + ">");
        }
    }

    private static FrameGroup getFrameGroup(String groupName) {
        return (FrameGroup)groupMap_.get(groupName);
    }

    private static FrameLevel getFrameLevel(String levelName) {
        return (FrameLevel)levelMap_.get(levelName);
    }

    private static FrameType getFrameType(String typeName) {
        return (FrameType)typeMap_.get(typeName);
    }

    static {
        for (FrameGroup group : FrameGroup.ALL_GROUPS) {
            groupMap_.put(group.getName(), group);
        }
        levelMap_ = new HashMap();
        for (FrameLevel level : FrameLevel.ALL_LEVELS) {
            levelMap_.put(level.getName(), level);
        }
        typeMap_ = new HashMap();
        for (FrameType type : FrameType.ALL_TYPES) {
            typeMap_.put(type.getName(), type);
        }
        namerMap_ = new HashMap();
        for (NamingScheme namer : NamingScheme.STANDARD_SCHEMES) {
            namerMap_.put(namer.getName(), namer);
        }
    }
}

