/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.CPDSConnectionFactory;
import org.apache.commons.dbcp.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.commons.dbcp.datasources.PerUserPoolDataSourceFactory;
import org.apache.commons.dbcp.datasources.PoolKey;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PerUserPoolDataSource
extends InstanceKeyDataSource {
    private static final Map poolKeys = new HashMap();
    private int defaultMaxActive = 8;
    private int defaultMaxIdle = 8;
    private int defaultMaxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    Map perUserDefaultAutoCommit = null;
    Map perUserDefaultTransactionIsolation = null;
    Map perUserMaxActive = null;
    Map perUserMaxIdle = null;
    Map perUserMaxWait = null;
    Map perUserDefaultReadOnly = null;
    private transient Map pools = new HashMap();

    private static void close(Map poolMap) {
    }

    public void close() {
        Iterator poolIter = this.pools.values().iterator();
        while (poolIter.hasNext()) {
            try {
                ((ObjectPool)poolIter.next()).close();
            }
            catch (Exception closePoolException) {
                // empty catch block
            }
        }
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getDefaultMaxActive() {
        return this.defaultMaxActive;
    }

    public void setDefaultMaxActive(int maxActive) {
        this.assertInitializationAllowed();
        this.defaultMaxActive = maxActive;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public void setDefaultMaxIdle(int defaultMaxIdle) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = defaultMaxIdle;
    }

    public int getDefaultMaxWait() {
        return this.defaultMaxWait;
    }

    public void setDefaultMaxWait(int defaultMaxWait) {
        this.assertInitializationAllowed();
        this.defaultMaxWait = defaultMaxWait;
    }

    public Boolean getPerUserDefaultAutoCommit(String key) {
        Boolean value = null;
        if (this.perUserDefaultAutoCommit != null) {
            value = (Boolean)this.perUserDefaultAutoCommit.get(key);
        }
        return value;
    }

    public void setPerUserDefaultAutoCommit(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = new HashMap();
        }
        this.perUserDefaultAutoCommit.put(username, value);
    }

    public Integer getPerUserDefaultTransactionIsolation(String username) {
        Integer value = null;
        if (this.perUserDefaultTransactionIsolation != null) {
            value = (Integer)this.perUserDefaultTransactionIsolation.get(username);
        }
        return value;
    }

    public void setPerUserDefaultTransactionIsolation(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap();
        }
        this.perUserDefaultTransactionIsolation.put(username, value);
    }

    public Integer getPerUserMaxActive(String username) {
        Integer value = null;
        if (this.perUserMaxActive != null) {
            value = (Integer)this.perUserMaxActive.get(username);
        }
        return value;
    }

    public void setPerUserMaxActive(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxActive == null) {
            this.perUserMaxActive = new HashMap();
        }
        this.perUserMaxActive.put(username, value);
    }

    public Integer getPerUserMaxIdle(String username) {
        Integer value = null;
        if (this.perUserMaxIdle != null) {
            value = (Integer)this.perUserMaxIdle.get(username);
        }
        return value;
    }

    public void setPerUserMaxIdle(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap();
        }
        this.perUserMaxIdle.put(username, value);
    }

    public Integer getPerUserMaxWait(String username) {
        Integer value = null;
        if (this.perUserMaxWait != null) {
            value = (Integer)this.perUserMaxWait.get(username);
        }
        return value;
    }

    public void setPerUserMaxWait(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWait == null) {
            this.perUserMaxWait = new HashMap();
        }
        this.perUserMaxWait.put(username, value);
    }

    public Boolean getPerUserDefaultReadOnly(String username) {
        Boolean value = null;
        if (this.perUserDefaultReadOnly != null) {
            value = (Boolean)this.perUserDefaultReadOnly.get(username);
        }
        return value;
    }

    public void setPerUserDefaultReadOnly(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = new HashMap();
        }
        this.perUserDefaultReadOnly.put(username, value);
    }

    public int getNumActive() {
        return this.getNumActive(null, null);
    }

    public int getNumActive(String username, String password) {
        ObjectPool pool = (ObjectPool)this.pools.get(this.getPoolKey(username));
        return pool == null ? 0 : pool.getNumActive();
    }

    public int getNumIdle() {
        return this.getNumIdle(null, null);
    }

    public int getNumIdle(String username, String password) {
        ObjectPool pool = (ObjectPool)this.pools.get(this.getPoolKey(username));
        return pool == null ? 0 : pool.getNumIdle();
    }

    protected synchronized PooledConnectionAndInfo getPooledConnectionAndInfo(String username, String password) throws SQLException {
        PoolKey key = this.getPoolKey(username);
        Object pool = this.pools.get(key);
        if (pool == null) {
            try {
                this.registerPool(username, password);
                pool = this.pools.get(key);
            }
            catch (NamingException e2) {
                throw new SQLNestedException("RegisterPool failed", e2);
            }
        }
        PooledConnectionAndInfo info = null;
        try {
            info = (PooledConnectionAndInfo)((ObjectPool)pool).borrowObject();
        }
        catch (Exception e3) {
            throw new SQLNestedException("Could not retrieve connection info from pool", e3);
        }
        return info;
    }

    protected void setupDefaults(Connection con, String username) throws SQLException {
        Integer userMax;
        Boolean userMax2;
        Boolean userMax3;
        boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (username != null && (userMax3 = this.getPerUserDefaultAutoCommit(username)) != null) {
            defaultAutoCommit = userMax3;
        }
        boolean defaultReadOnly = this.isDefaultReadOnly();
        if (username != null && (userMax2 = this.getPerUserDefaultReadOnly(username)) != null) {
            defaultReadOnly = userMax2;
        }
        int defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        if (username != null && (userMax = this.getPerUserDefaultTransactionIsolation(username)) != null) {
            defaultTransactionIsolation = userMax;
        }
        con.setAutoCommit(defaultAutoCommit);
        con.setReadOnly(defaultReadOnly);
        if (defaultTransactionIsolation != -1) {
            con.setTransactionIsolation(defaultTransactionIsolation);
        }
    }

    private PoolKey getPoolKey(String username) {
        PoolKey key = null;
        String dsName = this.getDataSourceName();
        HashMap<String, PoolKey> dsMap = (HashMap<String, PoolKey>)poolKeys.get(dsName);
        if (dsMap != null) {
            key = (PoolKey)dsMap.get(username);
        }
        if (key == null) {
            key = new PoolKey(dsName, username);
            if (dsMap == null) {
                dsMap = new HashMap<String, PoolKey>();
                poolKeys.put(dsName, dsMap);
            }
            dsMap.put(username, key);
        }
        return key;
    }

    private synchronized void registerPool(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(username, password);
        Integer userMax = this.getPerUserMaxActive(username);
        int maxActive = userMax == null ? this.getDefaultMaxActive() : userMax.intValue();
        userMax = this.getPerUserMaxIdle(username);
        int maxIdle = userMax == null ? this.getDefaultMaxIdle() : userMax.intValue();
        userMax = this.getPerUserMaxWait(username);
        int maxWait = userMax == null ? this.getDefaultMaxWait() : userMax.intValue();
        GenericObjectPool pool = new GenericObjectPool(null);
        pool.setMaxActive(maxActive);
        pool.setMaxIdle(maxIdle);
        pool.setMaxWait(maxWait);
        pool.setWhenExhaustedAction(this.whenExhaustedAction(maxActive, maxWait));
        pool.setTestOnBorrow(this.getTestOnBorrow());
        pool.setTestOnReturn(this.getTestOnReturn());
        pool.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        pool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        pool.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        pool.setTestWhileIdle(this.getTestWhileIdle());
        new CPDSConnectionFactory(cpds, pool, this.getValidationQuery(), username, password);
        this.pools.put(this.getPoolKey(username), pool);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            PerUserPoolDataSource oldDS = (PerUserPoolDataSource)new PerUserPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.pools = oldDS.pools;
        }
        catch (NamingException e2) {
            throw new IOException("NamingException: " + e2);
        }
    }
}

