#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "error.h"
#include "utils.h"


void * mymalloc(int size, char *what)
{
	void *dummy = malloc(size);
	if (!dummy)
		error_exit("failed to allocate %d bytes for %s\n", size, what);

	return dummy;
}

void * myrealloc(void *oldp, int newsize, char *what)
{
	void *dummy = realloc(oldp, newsize);
	if (!dummy)
		error_exit("failed to reallocate to %d bytes for %s\n", newsize, what);

	return dummy;
}

char * mystrdup(char *in)
{
	char *dummy = strdup(in);
	if (!dummy)
		error_exit("failed to copy string '%s': out of memory?\n", in);

	return dummy;
}

char * get_token(char *in)
{
        char *out, *dummy;

        // skip leading spaces/tabs
        while(isspace(*in))
                in++;

        // make copy of string
        dummy = out = mystrdup(in);

        // remove trailing spaces/tabs
	while (!isspace(*dummy) && *dummy)
		*dummy++;

	*dummy = 0x00;

        return out;
}
