#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sa.h"
#include "db.h"
#include "split.h"
#include "error.h"
#include "stats.h"


int learn(void *db_handle, char *line)
{
	int	loop;
	sa	*wordlist = split_line(line);

	// sa[1] = process
	if (wordlist -> getn() > 1)
	{
		char *bracket = strchr(wordlist -> get(1), '[');
		if (bracket)
			*bracket = 0x00;
	}

	for(loop=0; loop<wordlist -> getn(); loop++)
	{
		increase_counter_database(db_handle, wordlist -> get(loop));
	}

	delete wordlist;

	return 0;
}

double compare_words_bad(int n_good_lines, int good_freq, int n_bad_lines, int bad_freq)
{
	double good = (double)good_freq / (double)n_good_lines;
	double bad = (double)bad_freq / (double)n_bad_lines;

	double total = good + bad;

	if (total)
		return (bad * 100.0) / total;
	else
		return 0.00001;
}

double calculate(void *wg_db_handle, void *wb_db_handle, char *line, int n_good_lines, int n_bad_lines)
{
	double	value = 0.0;
	sa	*wordlist = split_line(line);

	for(int loop=0; loop<wordlist -> getn(); loop++)
	{
		int good_freq = 0, bad_freq = 0;

		char *dummy = retrieve_from_database(wg_db_handle, wordlist -> get(loop));
		if (dummy)
			good_freq = atoi(dummy);
		free(dummy);

		dummy = retrieve_from_database(wb_db_handle, wordlist -> get(loop));
		if (dummy)
			bad_freq = atoi(dummy);
		free(dummy);

		value += log(compare_words_bad(n_good_lines, good_freq, n_bad_lines, bad_freq));
	}

	delete wordlist;

	return value;
}
