#define _LARGEFILE64_SOURCE
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "conf.h"
#include "error.h"
#include "sa.h"
#include "db.h"
#include "split.h"
#include "stats.h"
#include "utils.h"
#include "br.h"

#define BAD	1
#define GOOD	2

int main(int argc, char *argv[])
{
	char type = -1;
	conf *config = load_config("btail.conf");
	struct stat finfo;
	int pperc = -1, perc;

	fprintf(stderr, "BayesTail by folkert@vanheusden.com\n\n");

	if (argc != 3)
	{
		fprintf(stderr, "Usage: <-b|-g> file\n");
		return 1;
	}

	if (strcmp(argv[1], "-b") == 0)
	{
		type = BAD;
	}
	else if (strcmp(argv[1], "-g") == 0)
	{
		type = GOOD;
	}
	else
	{
		fprintf(stderr, "Parameter '%s' ought to be either -b or -g.\n", argv[1]);
		return 2;
	}

	int fd = open64(argv[2], O_RDONLY);
	if (fd == -1)
	{
		fprintf(stderr, "Error opening file %s: %s\n", argv[2], strerror(errno));
		return 3;
	}
	buffered_reader	br(fd);

	if (fstat(fd, &finfo) == -1)
	{
		fprintf(stderr, "Failed to obtain info on file '%s': %s\n", argv[2], strerror(errno));
		return 4;
	}

	void *c_db_handle = open_database(config -> conf_db_parameters, DB_OPEN_WRITE);
	void *w_db_handle = open_database(type == GOOD ? config -> good_db_parameters : config -> bad_db_parameters, DB_OPEN_WRITE);

	printf("Learning %s...\n", type == GOOD ? "good" : "bad");
	for(;;)
	{
		char *line = br.read_line();
		if (!line)
			break;

		if (learn(w_db_handle, line) == -1)
		{
			fprintf(stderr, "failed to learn\n");
			return 1;
		}

		increase_counter_database(c_db_handle, (char *)(type == GOOD ? "good" : "bad"), 1);

		perc = (lseek(fd, 0, SEEK_CUR) * 100) / finfo.st_size;
		if (perc != pperc)
		{
			printf("%d%%\r", perc);
			fflush(stdout);

			pperc = perc;
		}

		free(line);
	}

	close_database(w_db_handle);
	close_database(c_db_handle);

	printf("Done.\n");

	return 0;
}
