/*
	globals.h - external variables
*/

#include "xglobals.h"

extern int  pauseflag;
extern int  bagptr;
extern int  NUMLETTERS;
extern int  NUMBLANKS;
extern char bag[BAGSIZE_MAX];
extern char PROMPT[NUMPROMPTS][256];
extern char board[BOARDSIZE][BOARDSIZE];

extern scoreStat highscores[4][NUMHIGHSCORES];
extern int num_players;
extern playerStat player[MAXPLAYERS];
extern int letterscore[NUMCHAR_MAX];
extern int freq[NUMCHAR_MAX];
extern char letterchar[NUMLETTERS_MAX];
extern char blanktiles[NUMBLANKS_MAX];
extern int sq_col[BOARDSIZE][BOARDSIZE];
extern int curr_player;
extern char dict[DICTSIZE][16];
extern int word_pos[15];
extern short int perms[5040][7];
extern int factorial[7];
extern int norms[6][7];
extern int norms_max[6];
extern goStat bestgos[NUMGOSCORES];
extern int bell_level;

/* external prototypes for misc.c */
extern void loadrules();
extern void loaddict();
extern void loadperms();
extern void savegame();
extern void loadgame();
extern void savescores();
extern void loadscores();
extern void alterscores();
extern void alterbestgo(int goscore,char *wordsmade);
extern void showscores(int numplay,char outstring[256]);
extern void showgoscores(char *outstring);
extern unsigned int wordsearch(char *word);
extern void clearboard(char b[BOARDSIZE][BOARDSIZE]);
extern void makebag();
extern void shufflebag();
extern void addtobag(char *letts);
extern void fillbar(int playernum);
extern int bartotal(int playernum);
extern void takeletters(int numletters,char *letters);
extern void showbag();
extern void showboard(char b[BOARDSIZE][BOARDSIZE]);
extern void showstats();

/* external prototypes for moves.c */
extern void convupper(char *str);
extern unsigned int emptyboard(char b[BOARDSIZE][BOARDSIZE]);
extern int validate(char newboard[BOARDSIZE][BOARDSIZE],int testing,int *goscore);
extern int checkwords(char nb[BOARDSIZE][BOARDSIZE],int sx,int sy,int ex,int ey,int testing,int *goscore);
extern void addhword(char newboard[BOARDSIZE][BOARDSIZE],int x,int y,char *word,int length);
extern void addvword(char newboard[BOARDSIZE][BOARDSIZE],int x,int y,char *word,int length);
extern int scoreword(int sx,int sy,int ex,int ey, char nb[BOARDSIZE][BOARDSIZE]);

/* external prototypes for cmove.c */
extern int check_boardh(int x,int y,int numlett);
extern int check_boardv(int x, int y,int numlett);
extern void makeperm(short int p[5040][7],int factorial[7]);
extern void findh_blank(int numblanks,char word[16],int xpos,int ypos,
			int *curr_bestscore,char curr_bestword[16],
			char tempboard[BOARDSIZE][BOARDSIZE],char prefix[16],
			int numlett);
extern void findv_blank(int numblanks,char word[16],int xpos,int ypos,
			int *curr_bestscore,char curr_bestword[16],
			char tempboard[BOARDSIZE][BOARDSIZE],char prefix[16],
			int numlett);
extern void checkh_words(int x, int y,char best[16],int *bestscore,int numlett);
extern void checkv_words(int x, int y,char best[16],int *bestscore,int numlett);
extern void comp_move(int *compscore,int level);
