/* perm5
 *
 * Copyright 2020 Etienne Helluy-Lafont, Univ. Lille, CNRS.
 *
 * This file is part of Project Ubertooth.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */
#include <stdint.h>

const uint8_t perm5_lut[2][4096] = {{
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x10,0x11,0x04,0x05,0x14,0x15,0x08,0x09,0x18,0x19,0x0c,0x0d,0x1c,0x1d,
	0x02,0x03,0x12,0x13,0x06,0x07,0x16,0x17,0x0a,0x0b,0x1a,0x1b,0x0e,0x0f,0x1e,0x1f,
	0x00,0x01,0x08,0x09,0x04,0x05,0x0c,0x0d,0x10,0x11,0x18,0x19,0x14,0x15,0x1c,0x1d,
	0x02,0x03,0x0a,0x0b,0x06,0x07,0x0e,0x0f,0x12,0x13,0x1a,0x1b,0x16,0x17,0x1e,0x1f,
	0x00,0x08,0x02,0x0a,0x04,0x0c,0x06,0x0e,0x01,0x09,0x03,0x0b,0x05,0x0d,0x07,0x0f,
	0x10,0x18,0x12,0x1a,0x14,0x1c,0x16,0x1e,0x11,0x19,0x13,0x1b,0x15,0x1d,0x17,0x1f,
	0x00,0x10,0x02,0x12,0x04,0x14,0x06,0x16,0x01,0x11,0x03,0x13,0x05,0x15,0x07,0x17,
	0x08,0x18,0x0a,0x1a,0x0c,0x1c,0x0e,0x1e,0x09,0x19,0x0b,0x1b,0x0d,0x1d,0x0f,0x1f,
	0x00,0x08,0x10,0x18,0x04,0x0c,0x14,0x1c,0x01,0x09,0x11,0x19,0x05,0x0d,0x15,0x1d,
	0x02,0x0a,0x12,0x1a,0x06,0x0e,0x16,0x1e,0x03,0x0b,0x13,0x1b,0x07,0x0f,0x17,0x1f,
	0x00,0x10,0x08,0x18,0x04,0x14,0x0c,0x1c,0x01,0x11,0x09,0x19,0x05,0x15,0x0d,0x1d,
	0x02,0x12,0x0a,0x1a,0x06,0x16,0x0e,0x1e,0x03,0x13,0x0b,0x1b,0x07,0x17,0x0f,0x1f,
	0x00,0x01,0x02,0x03,0x10,0x11,0x12,0x13,0x08,0x09,0x0a,0x0b,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x14,0x15,0x16,0x17,0x0c,0x0d,0x0e,0x0f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x08,0x09,0x0a,0x0b,0x10,0x11,0x12,0x13,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x0c,0x0d,0x0e,0x0f,0x14,0x15,0x16,0x17,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x10,0x11,0x02,0x03,0x12,0x13,0x08,0x09,0x18,0x19,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x06,0x07,0x16,0x17,0x0c,0x0d,0x1c,0x1d,0x0e,0x0f,0x1e,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,
	0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x08,0x02,0x0a,0x10,0x18,0x12,0x1a,0x01,0x09,0x03,0x0b,0x11,0x19,0x13,0x1b,
	0x04,0x0c,0x06,0x0e,0x14,0x1c,0x16,0x1e,0x05,0x0d,0x07,0x0f,0x15,0x1d,0x17,0x1f,
	0x00,0x10,0x02,0x12,0x08,0x18,0x0a,0x1a,0x01,0x11,0x03,0x13,0x09,0x19,0x0b,0x1b,
	0x04,0x14,0x06,0x16,0x0c,0x1c,0x0e,0x1e,0x05,0x15,0x07,0x17,0x0d,0x1d,0x0f,0x1f,
	0x00,0x08,0x10,0x18,0x02,0x0a,0x12,0x1a,0x01,0x09,0x11,0x19,0x03,0x0b,0x13,0x1b,
	0x04,0x0c,0x14,0x1c,0x06,0x0e,0x16,0x1e,0x05,0x0d,0x15,0x1d,0x07,0x0f,0x17,0x1f,
	0x00,0x10,0x08,0x18,0x02,0x12,0x0a,0x1a,0x01,0x11,0x09,0x19,0x03,0x13,0x0b,0x1b,
	0x04,0x14,0x0c,0x1c,0x06,0x16,0x0e,0x1e,0x05,0x15,0x0d,0x1d,0x07,0x17,0x0f,0x1f,
	0x00,0x01,0x08,0x09,0x04,0x05,0x0c,0x0d,0x02,0x03,0x0a,0x0b,0x06,0x07,0x0e,0x0f,
	0x10,0x11,0x18,0x19,0x14,0x15,0x1c,0x1d,0x12,0x13,0x1a,0x1b,0x16,0x17,0x1e,0x1f,
	0x00,0x01,0x10,0x11,0x04,0x05,0x14,0x15,0x02,0x03,0x12,0x13,0x06,0x07,0x16,0x17,
	0x08,0x09,0x18,0x19,0x0c,0x0d,0x1c,0x1d,0x0a,0x0b,0x1a,0x1b,0x0e,0x0f,0x1e,0x1f,
	0x00,0x01,0x08,0x09,0x04,0x05,0x0c,0x0d,0x10,0x11,0x18,0x19,0x14,0x15,0x1c,0x1d,
	0x02,0x03,0x0a,0x0b,0x06,0x07,0x0e,0x0f,0x12,0x13,0x1a,0x1b,0x16,0x17,0x1e,0x1f,
	0x00,0x01,0x10,0x11,0x04,0x05,0x14,0x15,0x08,0x09,0x18,0x19,0x0c,0x0d,0x1c,0x1d,
	0x02,0x03,0x12,0x13,0x06,0x07,0x16,0x17,0x0a,0x0b,0x1a,0x1b,0x0e,0x0f,0x1e,0x1f,
	0x00,0x08,0x01,0x09,0x04,0x0c,0x05,0x0d,0x02,0x0a,0x03,0x0b,0x06,0x0e,0x07,0x0f,
	0x10,0x18,0x11,0x19,0x14,0x1c,0x15,0x1d,0x12,0x1a,0x13,0x1b,0x16,0x1e,0x17,0x1f,
	0x00,0x10,0x01,0x11,0x04,0x14,0x05,0x15,0x02,0x12,0x03,0x13,0x06,0x16,0x07,0x17,
	0x08,0x18,0x09,0x19,0x0c,0x1c,0x0d,0x1d,0x0a,0x1a,0x0b,0x1b,0x0e,0x1e,0x0f,0x1f,
	0x00,0x08,0x01,0x09,0x04,0x0c,0x05,0x0d,0x10,0x18,0x11,0x19,0x14,0x1c,0x15,0x1d,
	0x02,0x0a,0x03,0x0b,0x06,0x0e,0x07,0x0f,0x12,0x1a,0x13,0x1b,0x16,0x1e,0x17,0x1f,
	0x00,0x10,0x01,0x11,0x04,0x14,0x05,0x15,0x08,0x18,0x09,0x19,0x0c,0x1c,0x0d,0x1d,
	0x02,0x12,0x03,0x13,0x06,0x16,0x07,0x17,0x0a,0x1a,0x0b,0x1b,0x0e,0x1e,0x0f,0x1f,
	0x00,0x01,0x08,0x09,0x10,0x11,0x18,0x19,0x02,0x03,0x0a,0x0b,0x12,0x13,0x1a,0x1b,
	0x04,0x05,0x0c,0x0d,0x14,0x15,0x1c,0x1d,0x06,0x07,0x0e,0x0f,0x16,0x17,0x1e,0x1f,
	0x00,0x01,0x10,0x11,0x08,0x09,0x18,0x19,0x02,0x03,0x12,0x13,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x0c,0x0d,0x1c,0x1d,0x06,0x07,0x16,0x17,0x0e,0x0f,0x1e,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,
	0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x01,0x10,0x11,0x02,0x03,0x12,0x13,0x08,0x09,0x18,0x19,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x06,0x07,0x16,0x17,0x0c,0x0d,0x1c,0x1d,0x0e,0x0f,0x1e,0x1f,
	0x00,0x08,0x01,0x09,0x10,0x18,0x11,0x19,0x02,0x0a,0x03,0x0b,0x12,0x1a,0x13,0x1b,
	0x04,0x0c,0x05,0x0d,0x14,0x1c,0x15,0x1d,0x06,0x0e,0x07,0x0f,0x16,0x1e,0x17,0x1f,
	0x00,0x10,0x01,0x11,0x08,0x18,0x09,0x19,0x02,0x12,0x03,0x13,0x0a,0x1a,0x0b,0x1b,
	0x04,0x14,0x05,0x15,0x0c,0x1c,0x0d,0x1d,0x06,0x16,0x07,0x17,0x0e,0x1e,0x0f,0x1f,
	0x00,0x08,0x01,0x09,0x02,0x0a,0x03,0x0b,0x10,0x18,0x11,0x19,0x12,0x1a,0x13,0x1b,
	0x04,0x0c,0x05,0x0d,0x06,0x0e,0x07,0x0f,0x14,0x1c,0x15,0x1d,0x16,0x1e,0x17,0x1f,
	0x00,0x10,0x01,0x11,0x02,0x12,0x03,0x13,0x08,0x18,0x09,0x19,0x0a,0x1a,0x0b,0x1b,
	0x04,0x14,0x05,0x15,0x06,0x16,0x07,0x17,0x0c,0x1c,0x0d,0x1d,0x0e,0x1e,0x0f,0x1f,
	0x00,0x08,0x02,0x0a,0x04,0x0c,0x06,0x0e,0x01,0x09,0x03,0x0b,0x05,0x0d,0x07,0x0f,
	0x10,0x18,0x12,0x1a,0x14,0x1c,0x16,0x1e,0x11,0x19,0x13,0x1b,0x15,0x1d,0x17,0x1f,
	0x00,0x10,0x02,0x12,0x04,0x14,0x06,0x16,0x01,0x11,0x03,0x13,0x05,0x15,0x07,0x17,
	0x08,0x18,0x0a,0x1a,0x0c,0x1c,0x0e,0x1e,0x09,0x19,0x0b,0x1b,0x0d,0x1d,0x0f,0x1f,
	0x00,0x08,0x10,0x18,0x04,0x0c,0x14,0x1c,0x01,0x09,0x11,0x19,0x05,0x0d,0x15,0x1d,
	0x02,0x0a,0x12,0x1a,0x06,0x0e,0x16,0x1e,0x03,0x0b,0x13,0x1b,0x07,0x0f,0x17,0x1f,
	0x00,0x10,0x08,0x18,0x04,0x14,0x0c,0x1c,0x01,0x11,0x09,0x19,0x05,0x15,0x0d,0x1d,
	0x02,0x12,0x0a,0x1a,0x06,0x16,0x0e,0x1e,0x03,0x13,0x0b,0x1b,0x07,0x17,0x0f,0x1f,
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x10,0x11,0x04,0x05,0x14,0x15,0x08,0x09,0x18,0x19,0x0c,0x0d,0x1c,0x1d,
	0x02,0x03,0x12,0x13,0x06,0x07,0x16,0x17,0x0a,0x0b,0x1a,0x1b,0x0e,0x0f,0x1e,0x1f,
	0x00,0x01,0x08,0x09,0x04,0x05,0x0c,0x0d,0x10,0x11,0x18,0x19,0x14,0x15,0x1c,0x1d,
	0x02,0x03,0x0a,0x0b,0x06,0x07,0x0e,0x0f,0x12,0x13,0x1a,0x1b,0x16,0x17,0x1e,0x1f,
	0x00,0x08,0x02,0x0a,0x10,0x18,0x12,0x1a,0x01,0x09,0x03,0x0b,0x11,0x19,0x13,0x1b,
	0x04,0x0c,0x06,0x0e,0x14,0x1c,0x16,0x1e,0x05,0x0d,0x07,0x0f,0x15,0x1d,0x17,0x1f,
	0x00,0x10,0x02,0x12,0x08,0x18,0x0a,0x1a,0x01,0x11,0x03,0x13,0x09,0x19,0x0b,0x1b,
	0x04,0x14,0x06,0x16,0x0c,0x1c,0x0e,0x1e,0x05,0x15,0x07,0x17,0x0d,0x1d,0x0f,0x1f,
	0x00,0x08,0x10,0x18,0x02,0x0a,0x12,0x1a,0x01,0x09,0x11,0x19,0x03,0x0b,0x13,0x1b,
	0x04,0x0c,0x14,0x1c,0x06,0x0e,0x16,0x1e,0x05,0x0d,0x15,0x1d,0x07,0x0f,0x17,0x1f,
	0x00,0x10,0x08,0x18,0x02,0x12,0x0a,0x1a,0x01,0x11,0x09,0x19,0x03,0x13,0x0b,0x1b,
	0x04,0x14,0x0c,0x1c,0x06,0x16,0x0e,0x1e,0x05,0x15,0x0d,0x1d,0x07,0x17,0x0f,0x1f,
	0x00,0x01,0x02,0x03,0x10,0x11,0x12,0x13,0x08,0x09,0x0a,0x0b,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x14,0x15,0x16,0x17,0x0c,0x0d,0x0e,0x0f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x08,0x09,0x0a,0x0b,0x10,0x11,0x12,0x13,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x0c,0x0d,0x0e,0x0f,0x14,0x15,0x16,0x17,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x10,0x11,0x02,0x03,0x12,0x13,0x08,0x09,0x18,0x19,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x06,0x07,0x16,0x17,0x0c,0x0d,0x1c,0x1d,0x0e,0x0f,0x1e,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,
	0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x02,0x08,0x0a,0x04,0x06,0x0c,0x0e,0x01,0x03,0x09,0x0b,0x05,0x07,0x0d,0x0f,
	0x10,0x12,0x18,0x1a,0x14,0x16,0x1c,0x1e,0x11,0x13,0x19,0x1b,0x15,0x17,0x1d,0x1f,
	0x00,0x02,0x10,0x12,0x04,0x06,0x14,0x16,0x01,0x03,0x11,0x13,0x05,0x07,0x15,0x17,
	0x08,0x0a,0x18,0x1a,0x0c,0x0e,0x1c,0x1e,0x09,0x0b,0x19,0x1b,0x0d,0x0f,0x1d,0x1f,
	0x00,0x10,0x08,0x18,0x04,0x14,0x0c,0x1c,0x01,0x11,0x09,0x19,0x05,0x15,0x0d,0x1d,
	0x02,0x12,0x0a,0x1a,0x06,0x16,0x0e,0x1e,0x03,0x13,0x0b,0x1b,0x07,0x17,0x0f,0x1f,
	0x00,0x08,0x10,0x18,0x04,0x0c,0x14,0x1c,0x01,0x09,0x11,0x19,0x05,0x0d,0x15,0x1d,
	0x02,0x0a,0x12,0x1a,0x06,0x0e,0x16,0x1e,0x03,0x0b,0x13,0x1b,0x07,0x0f,0x17,0x1f,
	0x00,0x02,0x01,0x03,0x04,0x06,0x05,0x07,0x08,0x0a,0x09,0x0b,0x0c,0x0e,0x0d,0x0f,
	0x10,0x12,0x11,0x13,0x14,0x16,0x15,0x17,0x18,0x1a,0x19,0x1b,0x1c,0x1e,0x1d,0x1f,
	0x00,0x02,0x01,0x03,0x04,0x06,0x05,0x07,0x10,0x12,0x11,0x13,0x14,0x16,0x15,0x17,
	0x08,0x0a,0x09,0x0b,0x0c,0x0e,0x0d,0x0f,0x18,0x1a,0x19,0x1b,0x1c,0x1e,0x1d,0x1f,
	0x00,0x10,0x01,0x11,0x04,0x14,0x05,0x15,0x08,0x18,0x09,0x19,0x0c,0x1c,0x0d,0x1d,
	0x02,0x12,0x03,0x13,0x06,0x16,0x07,0x17,0x0a,0x1a,0x0b,0x1b,0x0e,0x1e,0x0f,0x1f,
	0x00,0x08,0x01,0x09,0x04,0x0c,0x05,0x0d,0x10,0x18,0x11,0x19,0x14,0x1c,0x15,0x1d,
	0x02,0x0a,0x03,0x0b,0x06,0x0e,0x07,0x0f,0x12,0x1a,0x13,0x1b,0x16,0x1e,0x17,0x1f,
	0x00,0x02,0x08,0x0a,0x10,0x12,0x18,0x1a,0x01,0x03,0x09,0x0b,0x11,0x13,0x19,0x1b,
	0x04,0x06,0x0c,0x0e,0x14,0x16,0x1c,0x1e,0x05,0x07,0x0d,0x0f,0x15,0x17,0x1d,0x1f,
	0x00,0x02,0x10,0x12,0x08,0x0a,0x18,0x1a,0x01,0x03,0x11,0x13,0x09,0x0b,0x19,0x1b,
	0x04,0x06,0x14,0x16,0x0c,0x0e,0x1c,0x1e,0x05,0x07,0x15,0x17,0x0d,0x0f,0x1d,0x1f,
	0x00,0x10,0x08,0x18,0x02,0x12,0x0a,0x1a,0x01,0x11,0x09,0x19,0x03,0x13,0x0b,0x1b,
	0x04,0x14,0x0c,0x1c,0x06,0x16,0x0e,0x1e,0x05,0x15,0x0d,0x1d,0x07,0x17,0x0f,0x1f,
	0x00,0x08,0x10,0x18,0x02,0x0a,0x12,0x1a,0x01,0x09,0x11,0x19,0x03,0x0b,0x13,0x1b,
	0x04,0x0c,0x14,0x1c,0x06,0x0e,0x16,0x1e,0x05,0x0d,0x15,0x1d,0x07,0x0f,0x17,0x1f,
	0x00,0x02,0x01,0x03,0x10,0x12,0x11,0x13,0x08,0x0a,0x09,0x0b,0x18,0x1a,0x19,0x1b,
	0x04,0x06,0x05,0x07,0x14,0x16,0x15,0x17,0x0c,0x0e,0x0d,0x0f,0x1c,0x1e,0x1d,0x1f,
	0x00,0x02,0x01,0x03,0x08,0x0a,0x09,0x0b,0x10,0x12,0x11,0x13,0x18,0x1a,0x19,0x1b,
	0x04,0x06,0x05,0x07,0x0c,0x0e,0x0d,0x0f,0x14,0x16,0x15,0x17,0x1c,0x1e,0x1d,0x1f,
	0x00,0x10,0x01,0x11,0x02,0x12,0x03,0x13,0x08,0x18,0x09,0x19,0x0a,0x1a,0x0b,0x1b,
	0x04,0x14,0x05,0x15,0x06,0x16,0x07,0x17,0x0c,0x1c,0x0d,0x1d,0x0e,0x1e,0x0f,0x1f,
	0x00,0x08,0x01,0x09,0x02,0x0a,0x03,0x0b,0x10,0x18,0x11,0x19,0x12,0x1a,0x13,0x1b,
	0x04,0x0c,0x05,0x0d,0x06,0x0e,0x07,0x0f,0x14,0x1c,0x15,0x1d,0x16,0x1e,0x17,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,
	0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,
	0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x01,0x04,0x05,0x10,0x11,0x14,0x15,0x08,0x09,0x0c,0x0d,0x18,0x19,0x1c,0x1d,
	0x02,0x03,0x06,0x07,0x12,0x13,0x16,0x17,0x0a,0x0b,0x0e,0x0f,0x1a,0x1b,0x1e,0x1f,
	0x00,0x01,0x04,0x05,0x08,0x09,0x0c,0x0d,0x10,0x11,0x14,0x15,0x18,0x19,0x1c,0x1d,
	0x02,0x03,0x06,0x07,0x0a,0x0b,0x0e,0x0f,0x12,0x13,0x16,0x17,0x1a,0x1b,0x1e,0x1f,
	0x00,0x08,0x04,0x0c,0x02,0x0a,0x06,0x0e,0x01,0x09,0x05,0x0d,0x03,0x0b,0x07,0x0f,
	0x10,0x18,0x14,0x1c,0x12,0x1a,0x16,0x1e,0x11,0x19,0x15,0x1d,0x13,0x1b,0x17,0x1f,
	0x00,0x10,0x04,0x14,0x02,0x12,0x06,0x16,0x01,0x11,0x05,0x15,0x03,0x13,0x07,0x17,
	0x08,0x18,0x0c,0x1c,0x0a,0x1a,0x0e,0x1e,0x09,0x19,0x0d,0x1d,0x0b,0x1b,0x0f,0x1f,
	0x00,0x08,0x04,0x0c,0x10,0x18,0x14,0x1c,0x01,0x09,0x05,0x0d,0x11,0x19,0x15,0x1d,
	0x02,0x0a,0x06,0x0e,0x12,0x1a,0x16,0x1e,0x03,0x0b,0x07,0x0f,0x13,0x1b,0x17,0x1f,
	0x00,0x10,0x04,0x14,0x08,0x18,0x0c,0x1c,0x01,0x11,0x05,0x15,0x09,0x19,0x0d,0x1d,
	0x02,0x12,0x06,0x16,0x0a,0x1a,0x0e,0x1e,0x03,0x13,0x07,0x17,0x0b,0x1b,0x0f,0x1f,
	0x00,0x01,0x10,0x11,0x02,0x03,0x12,0x13,0x08,0x09,0x18,0x19,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x06,0x07,0x16,0x17,0x0c,0x0d,0x1c,0x1d,0x0e,0x0f,0x1e,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,
	0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x10,0x11,0x12,0x13,0x08,0x09,0x0a,0x0b,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x14,0x15,0x16,0x17,0x0c,0x0d,0x0e,0x0f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x08,0x09,0x0a,0x0b,0x10,0x11,0x12,0x13,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x0c,0x0d,0x0e,0x0f,0x14,0x15,0x16,0x17,0x1c,0x1d,0x1e,0x1f,
	0x00,0x08,0x10,0x18,0x02,0x0a,0x12,0x1a,0x01,0x09,0x11,0x19,0x03,0x0b,0x13,0x1b,
	0x04,0x0c,0x14,0x1c,0x06,0x0e,0x16,0x1e,0x05,0x0d,0x15,0x1d,0x07,0x0f,0x17,0x1f,
	0x00,0x10,0x08,0x18,0x02,0x12,0x0a,0x1a,0x01,0x11,0x09,0x19,0x03,0x13,0x0b,0x1b,
	0x04,0x14,0x0c,0x1c,0x06,0x16,0x0e,0x1e,0x05,0x15,0x0d,0x1d,0x07,0x17,0x0f,0x1f,
	0x00,0x08,0x02,0x0a,0x10,0x18,0x12,0x1a,0x01,0x09,0x03,0x0b,0x11,0x19,0x13,0x1b,
	0x04,0x0c,0x06,0x0e,0x14,0x1c,0x16,0x1e,0x05,0x0d,0x07,0x0f,0x15,0x1d,0x17,0x1f,
	0x00,0x10,0x02,0x12,0x08,0x18,0x0a,0x1a,0x01,0x11,0x03,0x13,0x09,0x19,0x0b,0x1b,
	0x04,0x14,0x06,0x16,0x0c,0x1c,0x0e,0x1e,0x05,0x15,0x07,0x17,0x0d,0x1d,0x0f,0x1f,
	0x00,0x01,0x04,0x05,0x08,0x09,0x0c,0x0d,0x02,0x03,0x06,0x07,0x0a,0x0b,0x0e,0x0f,
	0x10,0x11,0x14,0x15,0x18,0x19,0x1c,0x1d,0x12,0x13,0x16,0x17,0x1a,0x1b,0x1e,0x1f,
	0x00,0x01,0x04,0x05,0x10,0x11,0x14,0x15,0x02,0x03,0x06,0x07,0x12,0x13,0x16,0x17,
	0x08,0x09,0x0c,0x0d,0x18,0x19,0x1c,0x1d,0x0a,0x0b,0x0e,0x0f,0x1a,0x1b,0x1e,0x1f,
	0x00,0x01,0x04,0x05,0x08,0x09,0x0c,0x0d,0x10,0x11,0x14,0x15,0x18,0x19,0x1c,0x1d,
	0x02,0x03,0x06,0x07,0x0a,0x0b,0x0e,0x0f,0x12,0x13,0x16,0x17,0x1a,0x1b,0x1e,0x1f,
	0x00,0x01,0x04,0x05,0x10,0x11,0x14,0x15,0x08,0x09,0x0c,0x0d,0x18,0x19,0x1c,0x1d,
	0x02,0x03,0x06,0x07,0x12,0x13,0x16,0x17,0x0a,0x0b,0x0e,0x0f,0x1a,0x1b,0x1e,0x1f,
	0x00,0x08,0x04,0x0c,0x01,0x09,0x05,0x0d,0x02,0x0a,0x06,0x0e,0x03,0x0b,0x07,0x0f,
	0x10,0x18,0x14,0x1c,0x11,0x19,0x15,0x1d,0x12,0x1a,0x16,0x1e,0x13,0x1b,0x17,0x1f,
	0x00,0x10,0x04,0x14,0x01,0x11,0x05,0x15,0x02,0x12,0x06,0x16,0x03,0x13,0x07,0x17,
	0x08,0x18,0x0c,0x1c,0x09,0x19,0x0d,0x1d,0x0a,0x1a,0x0e,0x1e,0x0b,0x1b,0x0f,0x1f,
	0x00,0x08,0x04,0x0c,0x01,0x09,0x05,0x0d,0x10,0x18,0x14,0x1c,0x11,0x19,0x15,0x1d,
	0x02,0x0a,0x06,0x0e,0x03,0x0b,0x07,0x0f,0x12,0x1a,0x16,0x1e,0x13,0x1b,0x17,0x1f,
	0x00,0x10,0x04,0x14,0x01,0x11,0x05,0x15,0x08,0x18,0x0c,0x1c,0x09,0x19,0x0d,0x1d,
	0x02,0x12,0x06,0x16,0x03,0x13,0x07,0x17,0x0a,0x1a,0x0e,0x1e,0x0b,0x1b,0x0f,0x1f,
	0x00,0x01,0x10,0x11,0x08,0x09,0x18,0x19,0x02,0x03,0x12,0x13,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x0c,0x0d,0x1c,0x1d,0x06,0x07,0x16,0x17,0x0e,0x0f,0x1e,0x1f,
	0x00,0x01,0x08,0x09,0x10,0x11,0x18,0x19,0x02,0x03,0x0a,0x0b,0x12,0x13,0x1a,0x1b,
	0x04,0x05,0x0c,0x0d,0x14,0x15,0x1c,0x1d,0x06,0x07,0x0e,0x0f,0x16,0x17,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x08,0x09,0x0a,0x0b,0x10,0x11,0x12,0x13,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x0c,0x0d,0x0e,0x0f,0x14,0x15,0x16,0x17,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x10,0x11,0x12,0x13,0x08,0x09,0x0a,0x0b,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x14,0x15,0x16,0x17,0x0c,0x0d,0x0e,0x0f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x08,0x10,0x18,0x01,0x09,0x11,0x19,0x02,0x0a,0x12,0x1a,0x03,0x0b,0x13,0x1b,
	0x04,0x0c,0x14,0x1c,0x05,0x0d,0x15,0x1d,0x06,0x0e,0x16,0x1e,0x07,0x0f,0x17,0x1f,
	0x00,0x10,0x08,0x18,0x01,0x11,0x09,0x19,0x02,0x12,0x0a,0x1a,0x03,0x13,0x0b,0x1b,
	0x04,0x14,0x0c,0x1c,0x05,0x15,0x0d,0x1d,0x06,0x16,0x0e,0x1e,0x07,0x17,0x0f,0x1f,
	0x00,0x08,0x02,0x0a,0x01,0x09,0x03,0x0b,0x10,0x18,0x12,0x1a,0x11,0x19,0x13,0x1b,
	0x04,0x0c,0x06,0x0e,0x05,0x0d,0x07,0x0f,0x14,0x1c,0x16,0x1e,0x15,0x1d,0x17,0x1f,
	0x00,0x10,0x02,0x12,0x01,0x11,0x03,0x13,0x08,0x18,0x0a,0x1a,0x09,0x19,0x0b,0x1b,
	0x04,0x14,0x06,0x16,0x05,0x15,0x07,0x17,0x0c,0x1c,0x0e,0x1e,0x0d,0x1d,0x0f,0x1f,
	0x00,0x08,0x04,0x0c,0x02,0x0a,0x06,0x0e,0x01,0x09,0x05,0x0d,0x03,0x0b,0x07,0x0f,
	0x10,0x18,0x14,0x1c,0x12,0x1a,0x16,0x1e,0x11,0x19,0x15,0x1d,0x13,0x1b,0x17,0x1f,
	0x00,0x10,0x04,0x14,0x02,0x12,0x06,0x16,0x01,0x11,0x05,0x15,0x03,0x13,0x07,0x17,
	0x08,0x18,0x0c,0x1c,0x0a,0x1a,0x0e,0x1e,0x09,0x19,0x0d,0x1d,0x0b,0x1b,0x0f,0x1f,
	0x00,0x08,0x04,0x0c,0x10,0x18,0x14,0x1c,0x01,0x09,0x05,0x0d,0x11,0x19,0x15,0x1d,
	0x02,0x0a,0x06,0x0e,0x12,0x1a,0x16,0x1e,0x03,0x0b,0x07,0x0f,0x13,0x1b,0x17,0x1f,
	0x00,0x10,0x04,0x14,0x08,0x18,0x0c,0x1c,0x01,0x11,0x05,0x15,0x09,0x19,0x0d,0x1d,
	0x02,0x12,0x06,0x16,0x0a,0x1a,0x0e,0x1e,0x03,0x13,0x07,0x17,0x0b,0x1b,0x0f,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,
	0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,
	0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x01,0x04,0x05,0x10,0x11,0x14,0x15,0x08,0x09,0x0c,0x0d,0x18,0x19,0x1c,0x1d,
	0x02,0x03,0x06,0x07,0x12,0x13,0x16,0x17,0x0a,0x0b,0x0e,0x0f,0x1a,0x1b,0x1e,0x1f,
	0x00,0x01,0x04,0x05,0x08,0x09,0x0c,0x0d,0x10,0x11,0x14,0x15,0x18,0x19,0x1c,0x1d,
	0x02,0x03,0x06,0x07,0x0a,0x0b,0x0e,0x0f,0x12,0x13,0x16,0x17,0x1a,0x1b,0x1e,0x1f,
	0x00,0x08,0x10,0x18,0x02,0x0a,0x12,0x1a,0x01,0x09,0x11,0x19,0x03,0x0b,0x13,0x1b,
	0x04,0x0c,0x14,0x1c,0x06,0x0e,0x16,0x1e,0x05,0x0d,0x15,0x1d,0x07,0x0f,0x17,0x1f,
	0x00,0x10,0x08,0x18,0x02,0x12,0x0a,0x1a,0x01,0x11,0x09,0x19,0x03,0x13,0x0b,0x1b,
	0x04,0x14,0x0c,0x1c,0x06,0x16,0x0e,0x1e,0x05,0x15,0x0d,0x1d,0x07,0x17,0x0f,0x1f,
	0x00,0x08,0x02,0x0a,0x10,0x18,0x12,0x1a,0x01,0x09,0x03,0x0b,0x11,0x19,0x13,0x1b,
	0x04,0x0c,0x06,0x0e,0x14,0x1c,0x16,0x1e,0x05,0x0d,0x07,0x0f,0x15,0x1d,0x17,0x1f,
	0x00,0x10,0x02,0x12,0x08,0x18,0x0a,0x1a,0x01,0x11,0x03,0x13,0x09,0x19,0x0b,0x1b,
	0x04,0x14,0x06,0x16,0x0c,0x1c,0x0e,0x1e,0x05,0x15,0x07,0x17,0x0d,0x1d,0x0f,0x1f,
	0x00,0x01,0x10,0x11,0x02,0x03,0x12,0x13,0x08,0x09,0x18,0x19,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x06,0x07,0x16,0x17,0x0c,0x0d,0x1c,0x1d,0x0e,0x0f,0x1e,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,
	0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x10,0x11,0x12,0x13,0x08,0x09,0x0a,0x0b,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x14,0x15,0x16,0x17,0x0c,0x0d,0x0e,0x0f,0x1c,0x1d,0x1e,0x1f,
	0x00,0x01,0x02,0x03,0x08,0x09,0x0a,0x0b,0x10,0x11,0x12,0x13,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x0c,0x0d,0x0e,0x0f,0x14,0x15,0x16,0x17,0x1c,0x1d,0x1e,0x1f,
	0x00,0x02,0x04,0x06,0x08,0x0a,0x0c,0x0e,0x01,0x03,0x05,0x07,0x09,0x0b,0x0d,0x0f,
	0x10,0x12,0x14,0x16,0x18,0x1a,0x1c,0x1e,0x11,0x13,0x15,0x17,0x19,0x1b,0x1d,0x1f,
	0x00,0x02,0x04,0x06,0x10,0x12,0x14,0x16,0x01,0x03,0x05,0x07,0x11,0x13,0x15,0x17,
	0x08,0x0a,0x0c,0x0e,0x18,0x1a,0x1c,0x1e,0x09,0x0b,0x0d,0x0f,0x19,0x1b,0x1d,0x1f,
	0x00,0x10,0x04,0x14,0x08,0x18,0x0c,0x1c,0x01,0x11,0x05,0x15,0x09,0x19,0x0d,0x1d,
	0x02,0x12,0x06,0x16,0x0a,0x1a,0x0e,0x1e,0x03,0x13,0x07,0x17,0x0b,0x1b,0x0f,0x1f,
	0x00,0x08,0x04,0x0c,0x10,0x18,0x14,0x1c,0x01,0x09,0x05,0x0d,0x11,0x19,0x15,0x1d,
	0x02,0x0a,0x06,0x0e,0x12,0x1a,0x16,0x1e,0x03,0x0b,0x07,0x0f,0x13,0x1b,0x17,0x1f,
	0x00,0x02,0x04,0x06,0x01,0x03,0x05,0x07,0x08,0x0a,0x0c,0x0e,0x09,0x0b,0x0d,0x0f,
	0x10,0x12,0x14,0x16,0x11,0x13,0x15,0x17,0x18,0x1a,0x1c,0x1e,0x19,0x1b,0x1d,0x1f,
	0x00,0x02,0x04,0x06,0x01,0x03,0x05,0x07,0x10,0x12,0x14,0x16,0x11,0x13,0x15,0x17,
	0x08,0x0a,0x0c,0x0e,0x09,0x0b,0x0d,0x0f,0x18,0x1a,0x1c,0x1e,0x19,0x1b,0x1d,0x1f,
	0x00,0x10,0x04,0x14,0x01,0x11,0x05,0x15,0x08,0x18,0x0c,0x1c,0x09,0x19,0x0d,0x1d,
	0x02,0x12,0x06,0x16,0x03,0x13,0x07,0x17,0x0a,0x1a,0x0e,0x1e,0x0b,0x1b,0x0f,0x1f,
	0x00,0x08,0x04,0x0c,0x01,0x09,0x05,0x0d,0x10,0x18,0x14,0x1c,0x11,0x19,0x15,0x1d,
	0x02,0x0a,0x06,0x0e,0x03,0x0b,0x07,0x0f,0x12,0x1a,0x16,0x1e,0x13,0x1b,0x17,0x1f,
	0x00,0x02,0x10,0x12,0x08,0x0a,0x18,0x1a,0x01,0x03,0x11,0x13,0x09,0x0b,0x19,0x1b,
	0x04,0x06,0x14,0x16,0x0c,0x0e,0x1c,0x1e,0x05,0x07,0x15,0x17,0x0d,0x0f,0x1d,0x1f,
	0x00,0x02,0x08,0x0a,0x10,0x12,0x18,0x1a,0x01,0x03,0x09,0x0b,0x11,0x13,0x19,0x1b,
	0x04,0x06,0x0c,0x0e,0x14,0x16,0x1c,0x1e,0x05,0x07,0x0d,0x0f,0x15,0x17,0x1d,0x1f,
	0x00,0x10,0x02,0x12,0x08,0x18,0x0a,0x1a,0x01,0x11,0x03,0x13,0x09,0x19,0x0b,0x1b,
	0x04,0x14,0x06,0x16,0x0c,0x1c,0x0e,0x1e,0x05,0x15,0x07,0x17,0x0d,0x1d,0x0f,0x1f,
	0x00,0x08,0x02,0x0a,0x10,0x18,0x12,0x1a,0x01,0x09,0x03,0x0b,0x11,0x19,0x13,0x1b,
	0x04,0x0c,0x06,0x0e,0x14,0x1c,0x16,0x1e,0x05,0x0d,0x07,0x0f,0x15,0x1d,0x17,0x1f,
	0x00,0x02,0x10,0x12,0x01,0x03,0x11,0x13,0x08,0x0a,0x18,0x1a,0x09,0x0b,0x19,0x1b,
	0x04,0x06,0x14,0x16,0x05,0x07,0x15,0x17,0x0c,0x0e,0x1c,0x1e,0x0d,0x0f,0x1d,0x1f,
	0x00,0x02,0x08,0x0a,0x01,0x03,0x09,0x0b,0x10,0x12,0x18,0x1a,0x11,0x13,0x19,0x1b,
	0x04,0x06,0x0c,0x0e,0x05,0x07,0x0d,0x0f,0x14,0x16,0x1c,0x1e,0x15,0x17,0x1d,0x1f,
	0x00,0x10,0x02,0x12,0x01,0x11,0x03,0x13,0x08,0x18,0x0a,0x1a,0x09,0x19,0x0b,0x1b,
	0x04,0x14,0x06,0x16,0x05,0x15,0x07,0x17,0x0c,0x1c,0x0e,0x1e,0x0d,0x1d,0x0f,0x1f,
	0x00,0x08,0x02,0x0a,0x01,0x09,0x03,0x0b,0x10,0x18,0x12,0x1a,0x11,0x19,0x13,0x1b,
	0x04,0x0c,0x06,0x0e,0x05,0x0d,0x07,0x0f,0x14,0x1c,0x16,0x1e,0x15,0x1d,0x17,0x1f,
},{
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x00,0x02,0x01,0x03,0x04,0x06,0x05,0x07,0x08,0x0a,0x09,0x0b,0x0c,0x0e,0x0d,0x0f,
	0x10,0x12,0x11,0x13,0x14,0x16,0x15,0x17,0x18,0x1a,0x19,0x1b,0x1c,0x1e,0x1d,0x1f,
	0x00,0x01,0x02,0x03,0x08,0x09,0x0a,0x0b,0x04,0x05,0x06,0x07,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x18,0x19,0x1a,0x1b,0x14,0x15,0x16,0x17,0x1c,0x1d,0x1e,0x1f,
	0x00,0x02,0x01,0x03,0x08,0x0a,0x09,0x0b,0x04,0x06,0x05,0x07,0x0c,0x0e,0x0d,0x0f,
	0x10,0x12,0x11,0x13,0x18,0x1a,0x19,0x1b,0x14,0x16,0x15,0x17,0x1c,0x1e,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,
	0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x02,0x04,0x06,0x01,0x03,0x05,0x07,0x08,0x0a,0x0c,0x0e,0x09,0x0b,0x0d,0x0f,
	0x10,0x12,0x14,0x16,0x11,0x13,0x15,0x17,0x18,0x1a,0x1c,0x1e,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,
	0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x02,0x08,0x0a,0x01,0x03,0x09,0x0b,0x04,0x06,0x0c,0x0e,0x05,0x07,0x0d,0x0f,
	0x10,0x12,0x18,0x1a,0x11,0x13,0x19,0x1b,0x14,0x16,0x1c,0x1e,0x15,0x17,0x1d,0x1f,
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x00,0x02,0x01,0x03,0x04,0x06,0x05,0x07,0x10,0x12,0x11,0x13,0x14,0x16,0x15,0x17,
	0x08,0x0a,0x09,0x0b,0x0c,0x0e,0x0d,0x0f,0x18,0x1a,0x19,0x1b,0x1c,0x1e,0x1d,0x1f,
	0x00,0x01,0x02,0x03,0x08,0x09,0x0a,0x0b,0x10,0x11,0x12,0x13,0x18,0x19,0x1a,0x1b,
	0x04,0x05,0x06,0x07,0x0c,0x0d,0x0e,0x0f,0x14,0x15,0x16,0x17,0x1c,0x1d,0x1e,0x1f,
	0x00,0x02,0x01,0x03,0x08,0x0a,0x09,0x0b,0x10,0x12,0x11,0x13,0x18,0x1a,0x19,0x1b,
	0x04,0x06,0x05,0x07,0x0c,0x0e,0x0d,0x0f,0x14,0x16,0x15,0x17,0x1c,0x1e,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,
	0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x02,0x04,0x06,0x01,0x03,0x05,0x07,0x10,0x12,0x14,0x16,0x11,0x13,0x15,0x17,
	0x08,0x0a,0x0c,0x0e,0x09,0x0b,0x0d,0x0f,0x18,0x1a,0x1c,0x1e,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,
	0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x02,0x08,0x0a,0x01,0x03,0x09,0x0b,0x10,0x12,0x18,0x1a,0x11,0x13,0x19,0x1b,
	0x04,0x06,0x0c,0x0e,0x05,0x07,0x0d,0x0f,0x14,0x16,0x1c,0x1e,0x15,0x17,0x1d,0x1f,
	0x00,0x10,0x02,0x12,0x04,0x14,0x06,0x16,0x08,0x18,0x0a,0x1a,0x0c,0x1c,0x0e,0x1e,
	0x01,0x11,0x03,0x13,0x05,0x15,0x07,0x17,0x09,0x19,0x0b,0x1b,0x0d,0x1d,0x0f,0x1f,
	0x00,0x10,0x01,0x11,0x04,0x14,0x05,0x15,0x08,0x18,0x09,0x19,0x0c,0x1c,0x0d,0x1d,
	0x02,0x12,0x03,0x13,0x06,0x16,0x07,0x17,0x0a,0x1a,0x0b,0x1b,0x0e,0x1e,0x0f,0x1f,
	0x00,0x10,0x02,0x12,0x08,0x18,0x0a,0x1a,0x04,0x14,0x06,0x16,0x0c,0x1c,0x0e,0x1e,
	0x01,0x11,0x03,0x13,0x09,0x19,0x0b,0x1b,0x05,0x15,0x07,0x17,0x0d,0x1d,0x0f,0x1f,
	0x00,0x10,0x01,0x11,0x08,0x18,0x09,0x19,0x04,0x14,0x05,0x15,0x0c,0x1c,0x0d,0x1d,
	0x02,0x12,0x03,0x13,0x0a,0x1a,0x0b,0x1b,0x06,0x16,0x07,0x17,0x0e,0x1e,0x0f,0x1f,
	0x00,0x10,0x04,0x14,0x02,0x12,0x06,0x16,0x08,0x18,0x0c,0x1c,0x0a,0x1a,0x0e,0x1e,
	0x01,0x11,0x05,0x15,0x03,0x13,0x07,0x17,0x09,0x19,0x0d,0x1d,0x0b,0x1b,0x0f,0x1f,
	0x00,0x10,0x04,0x14,0x01,0x11,0x05,0x15,0x08,0x18,0x0c,0x1c,0x09,0x19,0x0d,0x1d,
	0x02,0x12,0x06,0x16,0x03,0x13,0x07,0x17,0x0a,0x1a,0x0e,0x1e,0x0b,0x1b,0x0f,0x1f,
	0x00,0x10,0x08,0x18,0x02,0x12,0x0a,0x1a,0x04,0x14,0x0c,0x1c,0x06,0x16,0x0e,0x1e,
	0x01,0x11,0x09,0x19,0x03,0x13,0x0b,0x1b,0x05,0x15,0x0d,0x1d,0x07,0x17,0x0f,0x1f,
	0x00,0x10,0x08,0x18,0x01,0x11,0x09,0x19,0x04,0x14,0x0c,0x1c,0x05,0x15,0x0d,0x1d,
	0x02,0x12,0x0a,0x1a,0x03,0x13,0x0b,0x1b,0x06,0x16,0x0e,0x1e,0x07,0x17,0x0f,0x1f,
	0x00,0x08,0x02,0x0a,0x04,0x0c,0x06,0x0e,0x10,0x18,0x12,0x1a,0x14,0x1c,0x16,0x1e,
	0x01,0x09,0x03,0x0b,0x05,0x0d,0x07,0x0f,0x11,0x19,0x13,0x1b,0x15,0x1d,0x17,0x1f,
	0x00,0x08,0x01,0x09,0x04,0x0c,0x05,0x0d,0x10,0x18,0x11,0x19,0x14,0x1c,0x15,0x1d,
	0x02,0x0a,0x03,0x0b,0x06,0x0e,0x07,0x0f,0x12,0x1a,0x13,0x1b,0x16,0x1e,0x17,0x1f,
	0x00,0x04,0x02,0x06,0x08,0x0c,0x0a,0x0e,0x10,0x14,0x12,0x16,0x18,0x1c,0x1a,0x1e,
	0x01,0x05,0x03,0x07,0x09,0x0d,0x0b,0x0f,0x11,0x15,0x13,0x17,0x19,0x1d,0x1b,0x1f,
	0x00,0x04,0x01,0x05,0x08,0x0c,0x09,0x0d,0x10,0x14,0x11,0x15,0x18,0x1c,0x19,0x1d,
	0x02,0x06,0x03,0x07,0x0a,0x0e,0x0b,0x0f,0x12,0x16,0x13,0x17,0x1a,0x1e,0x1b,0x1f,
	0x00,0x08,0x04,0x0c,0x02,0x0a,0x06,0x0e,0x10,0x18,0x14,0x1c,0x12,0x1a,0x16,0x1e,
	0x01,0x09,0x05,0x0d,0x03,0x0b,0x07,0x0f,0x11,0x19,0x15,0x1d,0x13,0x1b,0x17,0x1f,
	0x00,0x08,0x04,0x0c,0x01,0x09,0x05,0x0d,0x10,0x18,0x14,0x1c,0x11,0x19,0x15,0x1d,
	0x02,0x0a,0x06,0x0e,0x03,0x0b,0x07,0x0f,0x12,0x1a,0x16,0x1e,0x13,0x1b,0x17,0x1f,
	0x00,0x04,0x08,0x0c,0x02,0x06,0x0a,0x0e,0x10,0x14,0x18,0x1c,0x12,0x16,0x1a,0x1e,
	0x01,0x05,0x09,0x0d,0x03,0x07,0x0b,0x0f,0x11,0x15,0x19,0x1d,0x13,0x17,0x1b,0x1f,
	0x00,0x04,0x08,0x0c,0x01,0x05,0x09,0x0d,0x10,0x14,0x18,0x1c,0x11,0x15,0x19,0x1d,
	0x02,0x06,0x0a,0x0e,0x03,0x07,0x0b,0x0f,0x12,0x16,0x1a,0x1e,0x13,0x17,0x1b,0x1f,
	0x00,0x01,0x08,0x09,0x04,0x05,0x0c,0x0d,0x02,0x03,0x0a,0x0b,0x06,0x07,0x0e,0x0f,
	0x10,0x11,0x18,0x19,0x14,0x15,0x1c,0x1d,0x12,0x13,0x1a,0x1b,0x16,0x17,0x1e,0x1f,
	0x00,0x02,0x08,0x0a,0x04,0x06,0x0c,0x0e,0x01,0x03,0x09,0x0b,0x05,0x07,0x0d,0x0f,
	0x10,0x12,0x18,0x1a,0x14,0x16,0x1c,0x1e,0x11,0x13,0x19,0x1b,0x15,0x17,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x08,0x09,0x0c,0x0d,0x02,0x03,0x06,0x07,0x0a,0x0b,0x0e,0x0f,
	0x10,0x11,0x14,0x15,0x18,0x19,0x1c,0x1d,0x12,0x13,0x16,0x17,0x1a,0x1b,0x1e,0x1f,
	0x00,0x02,0x04,0x06,0x08,0x0a,0x0c,0x0e,0x01,0x03,0x05,0x07,0x09,0x0b,0x0d,0x0f,
	0x10,0x12,0x14,0x16,0x18,0x1a,0x1c,0x1e,0x11,0x13,0x15,0x17,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,
	0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x02,0x08,0x0a,0x01,0x03,0x09,0x0b,0x04,0x06,0x0c,0x0e,0x05,0x07,0x0d,0x0f,
	0x10,0x12,0x18,0x1a,0x11,0x13,0x19,0x1b,0x14,0x16,0x1c,0x1e,0x15,0x17,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,
	0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x02,0x04,0x06,0x01,0x03,0x05,0x07,0x08,0x0a,0x0c,0x0e,0x09,0x0b,0x0d,0x0f,
	0x10,0x12,0x14,0x16,0x11,0x13,0x15,0x17,0x18,0x1a,0x1c,0x1e,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x10,0x11,0x04,0x05,0x14,0x15,0x02,0x03,0x12,0x13,0x06,0x07,0x16,0x17,
	0x08,0x09,0x18,0x19,0x0c,0x0d,0x1c,0x1d,0x0a,0x0b,0x1a,0x1b,0x0e,0x0f,0x1e,0x1f,
	0x00,0x02,0x10,0x12,0x04,0x06,0x14,0x16,0x01,0x03,0x11,0x13,0x05,0x07,0x15,0x17,
	0x08,0x0a,0x18,0x1a,0x0c,0x0e,0x1c,0x1e,0x09,0x0b,0x19,0x1b,0x0d,0x0f,0x1d,0x1f,
	0x00,0x01,0x10,0x11,0x08,0x09,0x18,0x19,0x02,0x03,0x12,0x13,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x0c,0x0d,0x1c,0x1d,0x06,0x07,0x16,0x17,0x0e,0x0f,0x1e,0x1f,
	0x00,0x02,0x10,0x12,0x08,0x0a,0x18,0x1a,0x01,0x03,0x11,0x13,0x09,0x0b,0x19,0x1b,
	0x04,0x06,0x14,0x16,0x0c,0x0e,0x1c,0x1e,0x05,0x07,0x15,0x17,0x0d,0x0f,0x1d,0x1f,
	0x00,0x01,0x10,0x11,0x02,0x03,0x12,0x13,0x04,0x05,0x14,0x15,0x06,0x07,0x16,0x17,
	0x08,0x09,0x18,0x19,0x0a,0x0b,0x1a,0x1b,0x0c,0x0d,0x1c,0x1d,0x0e,0x0f,0x1e,0x1f,
	0x00,0x02,0x10,0x12,0x01,0x03,0x11,0x13,0x04,0x06,0x14,0x16,0x05,0x07,0x15,0x17,
	0x08,0x0a,0x18,0x1a,0x09,0x0b,0x19,0x1b,0x0c,0x0e,0x1c,0x1e,0x0d,0x0f,0x1d,0x1f,
	0x00,0x01,0x10,0x11,0x02,0x03,0x12,0x13,0x08,0x09,0x18,0x19,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x06,0x07,0x16,0x17,0x0c,0x0d,0x1c,0x1d,0x0e,0x0f,0x1e,0x1f,
	0x00,0x02,0x10,0x12,0x01,0x03,0x11,0x13,0x08,0x0a,0x18,0x1a,0x09,0x0b,0x19,0x1b,
	0x04,0x06,0x14,0x16,0x05,0x07,0x15,0x17,0x0c,0x0e,0x1c,0x1e,0x0d,0x0f,0x1d,0x1f,
	0x00,0x10,0x08,0x18,0x04,0x14,0x0c,0x1c,0x02,0x12,0x0a,0x1a,0x06,0x16,0x0e,0x1e,
	0x01,0x11,0x09,0x19,0x05,0x15,0x0d,0x1d,0x03,0x13,0x0b,0x1b,0x07,0x17,0x0f,0x1f,
	0x00,0x10,0x08,0x18,0x04,0x14,0x0c,0x1c,0x01,0x11,0x09,0x19,0x05,0x15,0x0d,0x1d,
	0x02,0x12,0x0a,0x1a,0x06,0x16,0x0e,0x1e,0x03,0x13,0x0b,0x1b,0x07,0x17,0x0f,0x1f,
	0x00,0x10,0x04,0x14,0x08,0x18,0x0c,0x1c,0x02,0x12,0x06,0x16,0x0a,0x1a,0x0e,0x1e,
	0x01,0x11,0x05,0x15,0x09,0x19,0x0d,0x1d,0x03,0x13,0x07,0x17,0x0b,0x1b,0x0f,0x1f,
	0x00,0x10,0x04,0x14,0x08,0x18,0x0c,0x1c,0x01,0x11,0x05,0x15,0x09,0x19,0x0d,0x1d,
	0x02,0x12,0x06,0x16,0x0a,0x1a,0x0e,0x1e,0x03,0x13,0x07,0x17,0x0b,0x1b,0x0f,0x1f,
	0x00,0x10,0x08,0x18,0x02,0x12,0x0a,0x1a,0x04,0x14,0x0c,0x1c,0x06,0x16,0x0e,0x1e,
	0x01,0x11,0x09,0x19,0x03,0x13,0x0b,0x1b,0x05,0x15,0x0d,0x1d,0x07,0x17,0x0f,0x1f,
	0x00,0x10,0x08,0x18,0x01,0x11,0x09,0x19,0x04,0x14,0x0c,0x1c,0x05,0x15,0x0d,0x1d,
	0x02,0x12,0x0a,0x1a,0x03,0x13,0x0b,0x1b,0x06,0x16,0x0e,0x1e,0x07,0x17,0x0f,0x1f,
	0x00,0x10,0x04,0x14,0x02,0x12,0x06,0x16,0x08,0x18,0x0c,0x1c,0x0a,0x1a,0x0e,0x1e,
	0x01,0x11,0x05,0x15,0x03,0x13,0x07,0x17,0x09,0x19,0x0d,0x1d,0x0b,0x1b,0x0f,0x1f,
	0x00,0x10,0x04,0x14,0x01,0x11,0x05,0x15,0x08,0x18,0x0c,0x1c,0x09,0x19,0x0d,0x1d,
	0x02,0x12,0x06,0x16,0x03,0x13,0x07,0x17,0x0a,0x1a,0x0e,0x1e,0x0b,0x1b,0x0f,0x1f,
	0x00,0x08,0x10,0x18,0x04,0x0c,0x14,0x1c,0x02,0x0a,0x12,0x1a,0x06,0x0e,0x16,0x1e,
	0x01,0x09,0x11,0x19,0x05,0x0d,0x15,0x1d,0x03,0x0b,0x13,0x1b,0x07,0x0f,0x17,0x1f,
	0x00,0x08,0x10,0x18,0x04,0x0c,0x14,0x1c,0x01,0x09,0x11,0x19,0x05,0x0d,0x15,0x1d,
	0x02,0x0a,0x12,0x1a,0x06,0x0e,0x16,0x1e,0x03,0x0b,0x13,0x1b,0x07,0x0f,0x17,0x1f,
	0x00,0x04,0x10,0x14,0x08,0x0c,0x18,0x1c,0x02,0x06,0x12,0x16,0x0a,0x0e,0x1a,0x1e,
	0x01,0x05,0x11,0x15,0x09,0x0d,0x19,0x1d,0x03,0x07,0x13,0x17,0x0b,0x0f,0x1b,0x1f,
	0x00,0x04,0x10,0x14,0x08,0x0c,0x18,0x1c,0x01,0x05,0x11,0x15,0x09,0x0d,0x19,0x1d,
	0x02,0x06,0x12,0x16,0x0a,0x0e,0x1a,0x1e,0x03,0x07,0x13,0x17,0x0b,0x0f,0x1b,0x1f,
	0x00,0x08,0x10,0x18,0x02,0x0a,0x12,0x1a,0x04,0x0c,0x14,0x1c,0x06,0x0e,0x16,0x1e,
	0x01,0x09,0x11,0x19,0x03,0x0b,0x13,0x1b,0x05,0x0d,0x15,0x1d,0x07,0x0f,0x17,0x1f,
	0x00,0x08,0x10,0x18,0x01,0x09,0x11,0x19,0x04,0x0c,0x14,0x1c,0x05,0x0d,0x15,0x1d,
	0x02,0x0a,0x12,0x1a,0x03,0x0b,0x13,0x1b,0x06,0x0e,0x16,0x1e,0x07,0x0f,0x17,0x1f,
	0x00,0x04,0x10,0x14,0x02,0x06,0x12,0x16,0x08,0x0c,0x18,0x1c,0x0a,0x0e,0x1a,0x1e,
	0x01,0x05,0x11,0x15,0x03,0x07,0x13,0x17,0x09,0x0d,0x19,0x1d,0x0b,0x0f,0x1b,0x1f,
	0x00,0x04,0x10,0x14,0x01,0x05,0x11,0x15,0x08,0x0c,0x18,0x1c,0x09,0x0d,0x19,0x1d,
	0x02,0x06,0x12,0x16,0x03,0x07,0x13,0x17,0x0a,0x0e,0x1a,0x1e,0x0b,0x0f,0x1b,0x1f,
	0x00,0x04,0x02,0x06,0x01,0x05,0x03,0x07,0x08,0x0c,0x0a,0x0e,0x09,0x0d,0x0b,0x0f,
	0x10,0x14,0x12,0x16,0x11,0x15,0x13,0x17,0x18,0x1c,0x1a,0x1e,0x19,0x1d,0x1b,0x1f,
	0x00,0x04,0x01,0x05,0x02,0x06,0x03,0x07,0x08,0x0c,0x09,0x0d,0x0a,0x0e,0x0b,0x0f,
	0x10,0x14,0x11,0x15,0x12,0x16,0x13,0x17,0x18,0x1c,0x19,0x1d,0x1a,0x1e,0x1b,0x1f,
	0x00,0x08,0x02,0x0a,0x01,0x09,0x03,0x0b,0x04,0x0c,0x06,0x0e,0x05,0x0d,0x07,0x0f,
	0x10,0x18,0x12,0x1a,0x11,0x19,0x13,0x1b,0x14,0x1c,0x16,0x1e,0x15,0x1d,0x17,0x1f,
	0x00,0x08,0x01,0x09,0x02,0x0a,0x03,0x0b,0x04,0x0c,0x05,0x0d,0x06,0x0e,0x07,0x0f,
	0x10,0x18,0x11,0x19,0x12,0x1a,0x13,0x1b,0x14,0x1c,0x15,0x1d,0x16,0x1e,0x17,0x1f,
	0x00,0x02,0x04,0x06,0x01,0x03,0x05,0x07,0x08,0x0a,0x0c,0x0e,0x09,0x0b,0x0d,0x0f,
	0x10,0x12,0x14,0x16,0x11,0x13,0x15,0x17,0x18,0x1a,0x1c,0x1e,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,
	0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x02,0x08,0x0a,0x01,0x03,0x09,0x0b,0x04,0x06,0x0c,0x0e,0x05,0x07,0x0d,0x0f,
	0x10,0x12,0x18,0x1a,0x11,0x13,0x19,0x1b,0x14,0x16,0x1c,0x1e,0x15,0x17,0x1d,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,
	0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x04,0x02,0x06,0x01,0x05,0x03,0x07,0x10,0x14,0x12,0x16,0x11,0x15,0x13,0x17,
	0x08,0x0c,0x0a,0x0e,0x09,0x0d,0x0b,0x0f,0x18,0x1c,0x1a,0x1e,0x19,0x1d,0x1b,0x1f,
	0x00,0x04,0x01,0x05,0x02,0x06,0x03,0x07,0x10,0x14,0x11,0x15,0x12,0x16,0x13,0x17,
	0x08,0x0c,0x09,0x0d,0x0a,0x0e,0x0b,0x0f,0x18,0x1c,0x19,0x1d,0x1a,0x1e,0x1b,0x1f,
	0x00,0x08,0x02,0x0a,0x01,0x09,0x03,0x0b,0x10,0x18,0x12,0x1a,0x11,0x19,0x13,0x1b,
	0x04,0x0c,0x06,0x0e,0x05,0x0d,0x07,0x0f,0x14,0x1c,0x16,0x1e,0x15,0x1d,0x17,0x1f,
	0x00,0x08,0x01,0x09,0x02,0x0a,0x03,0x0b,0x10,0x18,0x11,0x19,0x12,0x1a,0x13,0x1b,
	0x04,0x0c,0x05,0x0d,0x06,0x0e,0x07,0x0f,0x14,0x1c,0x15,0x1d,0x16,0x1e,0x17,0x1f,
	0x00,0x02,0x04,0x06,0x01,0x03,0x05,0x07,0x10,0x12,0x14,0x16,0x11,0x13,0x15,0x17,
	0x08,0x0a,0x0c,0x0e,0x09,0x0b,0x0d,0x0f,0x18,0x1a,0x1c,0x1e,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,
	0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x02,0x08,0x0a,0x01,0x03,0x09,0x0b,0x10,0x12,0x18,0x1a,0x11,0x13,0x19,0x1b,
	0x04,0x06,0x0c,0x0e,0x05,0x07,0x0d,0x0f,0x14,0x16,0x1c,0x1e,0x15,0x17,0x1d,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,
	0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x04,0x02,0x06,0x10,0x14,0x12,0x16,0x08,0x0c,0x0a,0x0e,0x18,0x1c,0x1a,0x1e,
	0x01,0x05,0x03,0x07,0x11,0x15,0x13,0x17,0x09,0x0d,0x0b,0x0f,0x19,0x1d,0x1b,0x1f,
	0x00,0x04,0x01,0x05,0x10,0x14,0x11,0x15,0x08,0x0c,0x09,0x0d,0x18,0x1c,0x19,0x1d,
	0x02,0x06,0x03,0x07,0x12,0x16,0x13,0x17,0x0a,0x0e,0x0b,0x0f,0x1a,0x1e,0x1b,0x1f,
	0x00,0x08,0x02,0x0a,0x10,0x18,0x12,0x1a,0x04,0x0c,0x06,0x0e,0x14,0x1c,0x16,0x1e,
	0x01,0x09,0x03,0x0b,0x11,0x19,0x13,0x1b,0x05,0x0d,0x07,0x0f,0x15,0x1d,0x17,0x1f,
	0x00,0x08,0x01,0x09,0x10,0x18,0x11,0x19,0x04,0x0c,0x05,0x0d,0x14,0x1c,0x15,0x1d,
	0x02,0x0a,0x03,0x0b,0x12,0x1a,0x13,0x1b,0x06,0x0e,0x07,0x0f,0x16,0x1e,0x17,0x1f,
	0x00,0x02,0x04,0x06,0x10,0x12,0x14,0x16,0x08,0x0a,0x0c,0x0e,0x18,0x1a,0x1c,0x1e,
	0x01,0x03,0x05,0x07,0x11,0x13,0x15,0x17,0x09,0x0b,0x0d,0x0f,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x10,0x11,0x14,0x15,0x08,0x09,0x0c,0x0d,0x18,0x19,0x1c,0x1d,
	0x02,0x03,0x06,0x07,0x12,0x13,0x16,0x17,0x0a,0x0b,0x0e,0x0f,0x1a,0x1b,0x1e,0x1f,
	0x00,0x02,0x08,0x0a,0x10,0x12,0x18,0x1a,0x04,0x06,0x0c,0x0e,0x14,0x16,0x1c,0x1e,
	0x01,0x03,0x09,0x0b,0x11,0x13,0x19,0x1b,0x05,0x07,0x0d,0x0f,0x15,0x17,0x1d,0x1f,
	0x00,0x01,0x08,0x09,0x10,0x11,0x18,0x19,0x04,0x05,0x0c,0x0d,0x14,0x15,0x1c,0x1d,
	0x02,0x03,0x0a,0x0b,0x12,0x13,0x1a,0x1b,0x06,0x07,0x0e,0x0f,0x16,0x17,0x1e,0x1f,
	0x00,0x04,0x02,0x06,0x08,0x0c,0x0a,0x0e,0x10,0x14,0x12,0x16,0x18,0x1c,0x1a,0x1e,
	0x01,0x05,0x03,0x07,0x09,0x0d,0x0b,0x0f,0x11,0x15,0x13,0x17,0x19,0x1d,0x1b,0x1f,
	0x00,0x04,0x01,0x05,0x08,0x0c,0x09,0x0d,0x10,0x14,0x11,0x15,0x18,0x1c,0x19,0x1d,
	0x02,0x06,0x03,0x07,0x0a,0x0e,0x0b,0x0f,0x12,0x16,0x13,0x17,0x1a,0x1e,0x1b,0x1f,
	0x00,0x08,0x02,0x0a,0x04,0x0c,0x06,0x0e,0x10,0x18,0x12,0x1a,0x14,0x1c,0x16,0x1e,
	0x01,0x09,0x03,0x0b,0x05,0x0d,0x07,0x0f,0x11,0x19,0x13,0x1b,0x15,0x1d,0x17,0x1f,
	0x00,0x08,0x01,0x09,0x04,0x0c,0x05,0x0d,0x10,0x18,0x11,0x19,0x14,0x1c,0x15,0x1d,
	0x02,0x0a,0x03,0x0b,0x06,0x0e,0x07,0x0f,0x12,0x1a,0x13,0x1b,0x16,0x1e,0x17,0x1f,
	0x00,0x02,0x04,0x06,0x08,0x0a,0x0c,0x0e,0x10,0x12,0x14,0x16,0x18,0x1a,0x1c,0x1e,
	0x01,0x03,0x05,0x07,0x09,0x0b,0x0d,0x0f,0x11,0x13,0x15,0x17,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x08,0x09,0x0c,0x0d,0x10,0x11,0x14,0x15,0x18,0x19,0x1c,0x1d,
	0x02,0x03,0x06,0x07,0x0a,0x0b,0x0e,0x0f,0x12,0x13,0x16,0x17,0x1a,0x1b,0x1e,0x1f,
	0x00,0x02,0x08,0x0a,0x04,0x06,0x0c,0x0e,0x10,0x12,0x18,0x1a,0x14,0x16,0x1c,0x1e,
	0x01,0x03,0x09,0x0b,0x05,0x07,0x0d,0x0f,0x11,0x13,0x19,0x1b,0x15,0x17,0x1d,0x1f,
	0x00,0x01,0x08,0x09,0x04,0x05,0x0c,0x0d,0x10,0x11,0x18,0x19,0x14,0x15,0x1c,0x1d,
	0x02,0x03,0x0a,0x0b,0x06,0x07,0x0e,0x0f,0x12,0x13,0x1a,0x1b,0x16,0x17,0x1e,0x1f,
	0x00,0x04,0x08,0x0c,0x01,0x05,0x09,0x0d,0x02,0x06,0x0a,0x0e,0x03,0x07,0x0b,0x0f,
	0x10,0x14,0x18,0x1c,0x11,0x15,0x19,0x1d,0x12,0x16,0x1a,0x1e,0x13,0x17,0x1b,0x1f,
	0x00,0x04,0x08,0x0c,0x02,0x06,0x0a,0x0e,0x01,0x05,0x09,0x0d,0x03,0x07,0x0b,0x0f,
	0x10,0x14,0x18,0x1c,0x12,0x16,0x1a,0x1e,0x11,0x15,0x19,0x1d,0x13,0x17,0x1b,0x1f,
	0x00,0x08,0x04,0x0c,0x01,0x09,0x05,0x0d,0x02,0x0a,0x06,0x0e,0x03,0x0b,0x07,0x0f,
	0x10,0x18,0x14,0x1c,0x11,0x19,0x15,0x1d,0x12,0x1a,0x16,0x1e,0x13,0x1b,0x17,0x1f,
	0x00,0x08,0x04,0x0c,0x02,0x0a,0x06,0x0e,0x01,0x09,0x05,0x0d,0x03,0x0b,0x07,0x0f,
	0x10,0x18,0x14,0x1c,0x12,0x1a,0x16,0x1e,0x11,0x19,0x15,0x1d,0x13,0x1b,0x17,0x1f,
	0x00,0x02,0x08,0x0a,0x01,0x03,0x09,0x0b,0x04,0x06,0x0c,0x0e,0x05,0x07,0x0d,0x0f,
	0x10,0x12,0x18,0x1a,0x11,0x13,0x19,0x1b,0x14,0x16,0x1c,0x1e,0x15,0x17,0x1d,0x1f,
	0x00,0x01,0x08,0x09,0x02,0x03,0x0a,0x0b,0x04,0x05,0x0c,0x0d,0x06,0x07,0x0e,0x0f,
	0x10,0x11,0x18,0x19,0x12,0x13,0x1a,0x1b,0x14,0x15,0x1c,0x1d,0x16,0x17,0x1e,0x1f,
	0x00,0x02,0x04,0x06,0x01,0x03,0x05,0x07,0x08,0x0a,0x0c,0x0e,0x09,0x0b,0x0d,0x0f,
	0x10,0x12,0x14,0x16,0x11,0x13,0x15,0x17,0x18,0x1a,0x1c,0x1e,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x02,0x03,0x06,0x07,0x08,0x09,0x0c,0x0d,0x0a,0x0b,0x0e,0x0f,
	0x10,0x11,0x14,0x15,0x12,0x13,0x16,0x17,0x18,0x19,0x1c,0x1d,0x1a,0x1b,0x1e,0x1f,
	0x00,0x04,0x10,0x14,0x01,0x05,0x11,0x15,0x02,0x06,0x12,0x16,0x03,0x07,0x13,0x17,
	0x08,0x0c,0x18,0x1c,0x09,0x0d,0x19,0x1d,0x0a,0x0e,0x1a,0x1e,0x0b,0x0f,0x1b,0x1f,
	0x00,0x04,0x10,0x14,0x02,0x06,0x12,0x16,0x01,0x05,0x11,0x15,0x03,0x07,0x13,0x17,
	0x08,0x0c,0x18,0x1c,0x0a,0x0e,0x1a,0x1e,0x09,0x0d,0x19,0x1d,0x0b,0x0f,0x1b,0x1f,
	0x00,0x08,0x10,0x18,0x01,0x09,0x11,0x19,0x02,0x0a,0x12,0x1a,0x03,0x0b,0x13,0x1b,
	0x04,0x0c,0x14,0x1c,0x05,0x0d,0x15,0x1d,0x06,0x0e,0x16,0x1e,0x07,0x0f,0x17,0x1f,
	0x00,0x08,0x10,0x18,0x02,0x0a,0x12,0x1a,0x01,0x09,0x11,0x19,0x03,0x0b,0x13,0x1b,
	0x04,0x0c,0x14,0x1c,0x06,0x0e,0x16,0x1e,0x05,0x0d,0x15,0x1d,0x07,0x0f,0x17,0x1f,
	0x00,0x02,0x10,0x12,0x01,0x03,0x11,0x13,0x04,0x06,0x14,0x16,0x05,0x07,0x15,0x17,
	0x08,0x0a,0x18,0x1a,0x09,0x0b,0x19,0x1b,0x0c,0x0e,0x1c,0x1e,0x0d,0x0f,0x1d,0x1f,
	0x00,0x01,0x10,0x11,0x02,0x03,0x12,0x13,0x04,0x05,0x14,0x15,0x06,0x07,0x16,0x17,
	0x08,0x09,0x18,0x19,0x0a,0x0b,0x1a,0x1b,0x0c,0x0d,0x1c,0x1d,0x0e,0x0f,0x1e,0x1f,
	0x00,0x02,0x10,0x12,0x01,0x03,0x11,0x13,0x08,0x0a,0x18,0x1a,0x09,0x0b,0x19,0x1b,
	0x04,0x06,0x14,0x16,0x05,0x07,0x15,0x17,0x0c,0x0e,0x1c,0x1e,0x0d,0x0f,0x1d,0x1f,
	0x00,0x01,0x10,0x11,0x02,0x03,0x12,0x13,0x08,0x09,0x18,0x19,0x0a,0x0b,0x1a,0x1b,
	0x04,0x05,0x14,0x15,0x06,0x07,0x16,0x17,0x0c,0x0d,0x1c,0x1d,0x0e,0x0f,0x1e,0x1f,
	0x00,0x04,0x08,0x0c,0x10,0x14,0x18,0x1c,0x02,0x06,0x0a,0x0e,0x12,0x16,0x1a,0x1e,
	0x01,0x05,0x09,0x0d,0x11,0x15,0x19,0x1d,0x03,0x07,0x0b,0x0f,0x13,0x17,0x1b,0x1f,
	0x00,0x04,0x08,0x0c,0x10,0x14,0x18,0x1c,0x01,0x05,0x09,0x0d,0x11,0x15,0x19,0x1d,
	0x02,0x06,0x0a,0x0e,0x12,0x16,0x1a,0x1e,0x03,0x07,0x0b,0x0f,0x13,0x17,0x1b,0x1f,
	0x00,0x08,0x04,0x0c,0x10,0x18,0x14,0x1c,0x02,0x0a,0x06,0x0e,0x12,0x1a,0x16,0x1e,
	0x01,0x09,0x05,0x0d,0x11,0x19,0x15,0x1d,0x03,0x0b,0x07,0x0f,0x13,0x1b,0x17,0x1f,
	0x00,0x08,0x04,0x0c,0x10,0x18,0x14,0x1c,0x01,0x09,0x05,0x0d,0x11,0x19,0x15,0x1d,
	0x02,0x0a,0x06,0x0e,0x12,0x1a,0x16,0x1e,0x03,0x0b,0x07,0x0f,0x13,0x1b,0x17,0x1f,
	0x00,0x02,0x08,0x0a,0x10,0x12,0x18,0x1a,0x04,0x06,0x0c,0x0e,0x14,0x16,0x1c,0x1e,
	0x01,0x03,0x09,0x0b,0x11,0x13,0x19,0x1b,0x05,0x07,0x0d,0x0f,0x15,0x17,0x1d,0x1f,
	0x00,0x01,0x08,0x09,0x10,0x11,0x18,0x19,0x04,0x05,0x0c,0x0d,0x14,0x15,0x1c,0x1d,
	0x02,0x03,0x0a,0x0b,0x12,0x13,0x1a,0x1b,0x06,0x07,0x0e,0x0f,0x16,0x17,0x1e,0x1f,
	0x00,0x02,0x04,0x06,0x10,0x12,0x14,0x16,0x08,0x0a,0x0c,0x0e,0x18,0x1a,0x1c,0x1e,
	0x01,0x03,0x05,0x07,0x11,0x13,0x15,0x17,0x09,0x0b,0x0d,0x0f,0x19,0x1b,0x1d,0x1f,
	0x00,0x01,0x04,0x05,0x10,0x11,0x14,0x15,0x08,0x09,0x0c,0x0d,0x18,0x19,0x1c,0x1d,
	0x02,0x03,0x06,0x07,0x12,0x13,0x16,0x17,0x0a,0x0b,0x0e,0x0f,0x1a,0x1b,0x1e,0x1f,
	0x00,0x04,0x10,0x14,0x08,0x0c,0x18,0x1c,0x02,0x06,0x12,0x16,0x0a,0x0e,0x1a,0x1e,
	0x01,0x05,0x11,0x15,0x09,0x0d,0x19,0x1d,0x03,0x07,0x13,0x17,0x0b,0x0f,0x1b,0x1f,
	0x00,0x04,0x10,0x14,0x08,0x0c,0x18,0x1c,0x01,0x05,0x11,0x15,0x09,0x0d,0x19,0x1d,
	0x02,0x06,0x12,0x16,0x0a,0x0e,0x1a,0x1e,0x03,0x07,0x13,0x17,0x0b,0x0f,0x1b,0x1f,
	0x00,0x08,0x10,0x18,0x04,0x0c,0x14,0x1c,0x02,0x0a,0x12,0x1a,0x06,0x0e,0x16,0x1e,
	0x01,0x09,0x11,0x19,0x05,0x0d,0x15,0x1d,0x03,0x0b,0x13,0x1b,0x07,0x0f,0x17,0x1f,
	0x00,0x08,0x10,0x18,0x04,0x0c,0x14,0x1c,0x01,0x09,0x11,0x19,0x05,0x0d,0x15,0x1d,
	0x02,0x0a,0x12,0x1a,0x06,0x0e,0x16,0x1e,0x03,0x0b,0x13,0x1b,0x07,0x0f,0x17,0x1f,
	0x00,0x02,0x10,0x12,0x08,0x0a,0x18,0x1a,0x04,0x06,0x14,0x16,0x0c,0x0e,0x1c,0x1e,
	0x01,0x03,0x11,0x13,0x09,0x0b,0x19,0x1b,0x05,0x07,0x15,0x17,0x0d,0x0f,0x1d,0x1f,
	0x00,0x01,0x10,0x11,0x08,0x09,0x18,0x19,0x04,0x05,0x14,0x15,0x0c,0x0d,0x1c,0x1d,
	0x02,0x03,0x12,0x13,0x0a,0x0b,0x1a,0x1b,0x06,0x07,0x16,0x17,0x0e,0x0f,0x1e,0x1f,
	0x00,0x02,0x10,0x12,0x04,0x06,0x14,0x16,0x08,0x0a,0x18,0x1a,0x0c,0x0e,0x1c,0x1e,
	0x01,0x03,0x11,0x13,0x05,0x07,0x15,0x17,0x09,0x0b,0x19,0x1b,0x0d,0x0f,0x1d,0x1f,
	0x00,0x01,0x10,0x11,0x04,0x05,0x14,0x15,0x08,0x09,0x18,0x19,0x0c,0x0d,0x1c,0x1d,
	0x02,0x03,0x12,0x13,0x06,0x07,0x16,0x17,0x0a,0x0b,0x1a,0x1b,0x0e,0x0f,0x1e,0x1f,
}};

#if 0
/* perm5 with only 7 rounds */
static u8 perm5_short(u8 z, u16 p, uint8_t offset)
{
	int i,j;
	u8 tmp, output, z_bit[5];
	static const u8 index1[14] = {0, 2, 1, 3, 0, 1, 0, 3, 1, 0, 2, 1, 0, 1};
	static const u8 index2[14] = {1, 3, 2, 4, 4, 3, 2, 4, 4, 3, 4, 3, 3, 2};

	/* z is constrained to 5 bits, p_high to 5 bits, p_low to 9 bits */
	z &= 0x1f;

	/* bit swapping will be easier with an array of bits */
	for (i = 0; i < 5; i++)
		z_bit[i] = (z >> i) & 0x01;
	p<<=7-offset;

	/* butterfly operations */
	for (j=0, i = 14-1-offset; j<7; i--,j++) {
		/* swap bits according to index arrays if control signal tells us to */
		if (p&(1<<(i))) {
			tmp = z_bit[index1[i]];
			z_bit[index1[i]] = z_bit[index2[i]];
			z_bit[index2[i]] = tmp;
		}
	}

	/* reconstruct output from rearranged bits */
	output = 0;
	for (i = 0; i < 5; i++)
		output += z_bit[i] << i;

	return output;
}
static u8 perm5_slow(u8 z, u8 p_high, u16 p_low)
{
	/* z is constrained to 5 bits, p_high to 5 bits, p_low to 9 bits */
	z &= (1<<5)-1;
	p_low &= (1<<9)-1; 
	p_high &= (1<<5)-1;

	int i;
	u8 tmp, output, z_bit[5], p[14];
	static const u8 index1[14] = {0, 2, 1, 3, 0, 1, 0, 3, 1, 0, 2, 1, 0, 1};
	static const u8 index2[14] = {1, 3, 2, 4, 4, 3, 2, 4, 4, 3, 4, 3, 3, 2};

	/* bits of p_low and p_high are control signals */
	for (i = 0; i < 9; i++)
		p[i] = (p_low >> i) & 0x01;
	for (i = 0; i < 5; i++)
		p[i+9] = (p_high >> i) & 0x01;

	/* bit swapping will be easier with an array of bits */
	for (i = 0; i < 5; i++)
		z_bit[i] = (z >> i) & 0x01;

	/* butterfly operations */
	for (i = 13; i >= 0; i--) {
		/* swap bits according to index arrays if control signal tells us to */
		if (p[i]) {
			tmp = z_bit[index1[i]];
			z_bit[index1[i]] = z_bit[index2[i]];
			z_bit[index2[i]] = tmp;
		}
	}

	/* reconstruct output from rearranged bits */
	output = 0;
	for (i = 0; i < 5; i++)
		output += z_bit[i] << i;

	return output;
}

/* poor fncompute two 1Kb lut, with index (z, p7) to make perm5 fast */
void perm5_precal(void)
{	
	unsigned i;
	u8 z, p, round, out;

	for (z=0;z<32;z++) // 5 bits of 7
	{
		for(p=0;p<128;p++) // 7 bits of p;
		{
			perm5_lut[0][z|(p<<5)] = perm5_short(z, p, 0);
			perm5_lut[1][z|(p<<5)] = perm5_short(z, p, 7);
		}
	}
	printf("static const perm5_lut[2][4096] = {\n");
	for(round=0;round<2;round++)
	{
		printf("{\n\t");
		for(i=0;i<4096;i++){
			printf("0x%02x,", perm5_lut[round][i]);
			if (((i+1)&0xf)==0)printf("\n\t");
		}
		printf("},\n");
	}
	printf("};\n");
}

void perm5_test(void)
{
	unsigned z, p, res1,res2, plo,phi;

	perm5_precal();

	for(p=0;p<1<<14;p++)
	for(z=0;z<32;z++)
	{
		plo = p&0x1ff;
		phi = 0x7f&(p>>9);
		res1 = perm5_slow(z,phi,plo);
		res2 = perm5(z,phi,plo);
		if(res1!=res2)
		{
			printf("failed: z=%2x p=%3x %x %x\n",z, p,res1,res2);
			return;
		}
		else{
			//printf("worked: z=%2x p=%3x %x %x\n", z, p,res1,res2);
		}
	}
	printf("it works\n");
}
#endif
