/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extension.r;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import org.nlogo.api.ClassManager;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.ExtensionManager$;
import org.nlogo.core.CompilerException;
import org.nlogo.core.ErrorSource;
import org.nlogo.core.ExtensionObject;
import org.nlogo.core.Primitive;
import org.nlogo.extension.r.ConsoleSync;
import org.nlogo.extension.r.Entry;
import org.nlogo.extension.r.JavaLibraryPath;
import org.nlogo.extension.r.plot.JavaGDFrame;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineCallbacks;
import org.rosuda.REngine.REngineInputInterface;
import org.rosuda.REngine.REngineOutputInterface;

class ShellWindow
extends JFrame
implements KeyListener,
ActionListener,
REngineOutputInterface,
REngineInputInterface,
REngineCallbacks,
ExtensionManager {
    private static final long serialVersionUID = 1L;
    final JFileChooser fc = new JFileChooser();
    FileFilter ff = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".rhistory") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "R History File (*.RHistory)";
        }
    };
    private final JSplitPane consolePanel = new JSplitPane(0);
    public JTextArea output = new JTextArea();
    public JTextArea input = new JTextArea();
    private Vector<String> cmd_history = new Vector();
    private int cmd_hist_index = 0;
    private boolean cmd_hist_first = true;
    private ConsoleSync rSync = null;

    public ShellWindow(ConsoleSync rSync) {
        super("R Console");
        this.rSync = rSync;
        this.fc.setFileFilter(this.ff);
        JScrollPane sp1 = new JScrollPane(this.output);
        sp1.setVerticalScrollBarPolicy(22);
        this.consolePanel.setTopComponent(sp1);
        JScrollPane sp2 = new JScrollPane(this.input);
        sp2.setVerticalScrollBarPolicy(20);
        this.consolePanel.setBottomComponent(sp2);
        this.consolePanel.setDividerLocation((int)((double)this.getHeight() * 0.65));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                super.componentResized(evt);
                ShellWindow.this.consolePanel.setDividerLocation((int)((double)ShellWindow.this.getHeight() * 0.65));
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.consolePanel, "Center");
        this.setMinimumSize(new Dimension(555, 650));
        this.setSize(new Dimension(555, 650));
        this.input.addKeyListener(this);
        this.output.setEditable(false);
        this.output.setText("\nR-Extension Notes:\n\n------------------\nThis is a special interactive shell.\nPlease note, that if you open windows from R (e.g. plot windows)\nthey are not refreshed while you have no idle loop running\n(see the plot example for implementing an idle loop\nfrom NetLogo).\n\nWrite your R commands into the lower area (input) and drop\nCtrl+Enter for submitting them.\nUse context menu to clear, save or load history.\nUse the page up/down keys in the lower area (input) to browse\nthe current history.\nVariable created from NetLogo live in nl.env environment.\nUse get('varname',nl.env) to access them and\nls(nl.env) to get a list of variables.\n------------------\n\n");
        JPopupMenu contextMenu = new JPopupMenu("Edit");
        contextMenu.add(this.makeMenuItem("Clear all"));
        contextMenu.add(this.makeMenuItem("Clear Window"));
        contextMenu.add(this.makeMenuItem("Clear History"));
        contextMenu.add(this.makeMenuItem("Save History to File"));
        contextMenu.add(this.makeMenuItem("Load Histroy from File"));
        this.output.setComponentPopupMenu(contextMenu);
        this.input.setComponentPopupMenu(contextMenu);
        this.output.setInheritsPopupMenu(true);
        this.input.setInheritsPopupMenu(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.output.append(e.getActionCommand() + "\n");
        if (e.getActionCommand() == "Clear all") {
            this.startFullCompilation();
            return;
        }
        if (e.getActionCommand() == "Clear Window") {
            this.output.setText("");
            return;
        }
        if (e.getActionCommand() == "Clear History") {
            this.cmd_history.clear();
            return;
        }
        if (e.getActionCommand() == "Save History to File") {
            try {
                this.fc.setDialogTitle("Select file where to save R History...");
                int returnVal = this.fc.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = this.fc.getSelectedFile();
                    String filename = file.getAbsolutePath();
                    if (!file.getName().toLowerCase().endsWith(".rhistory")) {
                        filename = file.getAbsolutePath() + ".RHistory";
                    }
                    BufferedWriter out = new BufferedWriter(new FileWriter(filename));
                    Iterator<String> it = this.cmd_history.iterator();
                    while (it.hasNext()) {
                        out.write(it.next().toString());
                        out.newLine();
                    }
                    out.close();
                }
            }
            catch (Exception ex) {
                System.out.println("R-Extension: Error while writing History to file!\n" + ex);
            }
            return;
        }
        if (e.getActionCommand() == "Load Histroy from File") {
            try {
                this.fc.setDialogTitle("Select RHistory file to be loaded...");
                int returnVal = this.fc.showOpenDialog(null);
                if (returnVal == 0) {
                    String strLine;
                    File file = this.fc.getSelectedFile();
                    FileInputStream fstream = new FileInputStream(file.getAbsoluteFile());
                    DataInputStream in = new DataInputStream(fstream);
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    this.cmd_history.clear();
                    while ((strLine = br.readLine()) != null) {
                        this.cmd_history.add(strLine);
                    }
                    this.cmd_hist_index = this.cmd_history.size() - 1;
                    br.close();
                }
            }
            catch (Exception ex) {
                System.out.println("R-Extension: Error while writing History to file!\n" + ex);
            }
            return;
        }
    }

    private JMenuItem makeMenuItem(String label) {
        JMenuItem item = new JMenuItem(label);
        item.addActionListener(this);
        return item;
    }

    public void execute(String cmd) {
        String[] cmdArray = cmd.split("\n");
        String c = null;
        for (int i = 0; i < cmdArray.length; ++i) {
            c = cmdArray[i];
            this.rSync.triggerNotification(c.trim());
        }
    }

    public static void addPath(String s) throws Exception {
        File f = new File(s);
        URL u = f.toURI().toURL();
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u);
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.isControlDown() && ke.getKeyCode() == 10) {
            String cmd = this.input.getText().trim();
            this.cmd_history.add(cmd);
            this.cmd_hist_index = this.cmd_history.size() - 1;
            this.cmd_hist_first = true;
            this.input.setText("");
            this.input.setCaretPosition(0);
            this.input.requestFocus();
            if (cmd.contains("q()")) {
                this.output.append("You cannot execute q() from inside this shell. \n Please close this window and then NetLogo.");
            } else {
                this.execute(cmd);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if ((ke.getKeyCode() == 34 || ke.getKeyCode() == 33) && this.cmd_history.size() > 0) {
            if (ke.getKeyCode() == 33) {
                if (!this.cmd_hist_first) {
                    --this.cmd_hist_index;
                }
                if (this.cmd_hist_index < 0) {
                    this.cmd_hist_index = this.cmd_history.size() - 1;
                }
            } else {
                ++this.cmd_hist_index;
                if (this.cmd_hist_index >= this.cmd_history.size()) {
                    this.cmd_hist_index = 0;
                }
            }
            this.cmd_hist_first = false;
            this.input.setText(this.cmd_history.get(this.cmd_hist_index));
        }
    }

    public void RFlushConsole(REngine eng) {
    }

    public void RShowMessage(REngine eng, String message) {
        JOptionPane.showMessageDialog(this, message, "R Message", 1);
    }

    public void RWriteConsole(REngine eng, String text, int oType) {
        this.output.append(text);
        this.output.setCaretPosition(this.output.getDocument().getLength());
    }

    public String RReadConsole(REngine eng, String prompt, int addToHistory) {
        this.output.append(prompt);
        String s = this.rSync.waitForNotification();
        try {
            this.output.append(s + "\n");
            this.output.setCaretPosition(this.output.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s == null || s.length() == 0 ? "\n" : s + "\n";
    }

    public boolean anyExtensionsLoaded() {
        return this.isVisible();
    }

    public void finishFullCompilation() {
        this.setVisible(true);
    }

    public void reset() {
        this.setVisible(false);
    }

    public void startFullCompilation() {
        this.output.setText("");
        this.cmd_history.clear();
        this.cmd_hist_first = true;
    }

    public static String getRExtensionJarPath() throws FileNotFoundException {
        Path extensionsPath = ExtensionManager$.MODULE$.extensionsPath().resolve("r").resolve("r.jar");
        if (extensionsPath.toFile().exists()) {
            return extensionsPath.toString();
        }
        Path userExtensionsPath = ExtensionManager$.MODULE$.userExtensionsPath().resolve("r").resolve("r.jar");
        if (userExtensionsPath.toFile().exists()) {
            return userExtensionsPath.toString();
        }
        Path bundledExtensionsPath = ExtensionManager$.MODULE$.extensionsPath().resolve(".bundled").resolve("r").resolve("r.jar");
        if (bundledExtensionsPath.toFile().exists()) {
            return bundledExtensionsPath.toString();
        }
        throw new FileNotFoundException("Unable to locate r.jar for the shell window to use.");
    }

    public void storeObject(Object arg0) {
        try {
            Entry.rConn.execute(Entry.rConn.rConnection, "require(JavaGD)", Entry.rConn.WorkingEnvironment, true);
            String filepath = Entry.rConn.execute(Entry.rConn.rConnection, "path.package(\"JavaGD\")", null, true).asString();
            String filesep = System.getProperty("file.separator");
            JavaLibraryPath.addFile(filepath + filesep + "/java/javaGD.jar");
            JavaLibraryPath.addFile(ShellWindow.getRExtensionJarPath());
            JavaGDFrame.engine = Entry.rConn.rConnection;
            Entry.rConn.execute(Entry.rConn.rConnection, "Sys.setenv('JAVAGD_CLASS_NAME'='org/nlogo/extension/r/plot/JavaGDFrame')", Entry.rConn.WorkingEnvironment, true);
            Entry.rConn.execute(Entry.rConn.rConnection, "options(device=JavaGD)", Entry.rConn.WorkingEnvironment, true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error during configuration of JavaGD plot device: " + ex, "Error in R-Extension", 1);
        }
    }

    public String dumpExtensionPrimitives() {
        return null;
    }

    public Iterable<ClassManager> loadedExtensions() {
        return new ArrayList<ClassManager>();
    }

    public String dumpExtensions() {
        return null;
    }

    public void importExtension(String arg0, ErrorSource arg1) throws CompilerException {
    }

    public ExtensionObject readExtensionObject(String arg0, String arg1, String arg2) throws CompilerException {
        return null;
    }

    public Object readFromString(String arg0) throws CompilerException {
        return null;
    }

    public Primitive replaceIdentifier(String arg0) {
        return null;
    }

    public Object retrieveObject() {
        return null;
    }
}

