/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.typography.general;

import Jama.Matrix;
import com.caffeineowl.graphics.bezier.BezierUtils;
import com.caffeineowl.graphics.bezier.CubicSegmentConsumer;
import com.caffeineowl.graphics.bezier.CubicSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.QuadSegmentConsumer;
import com.caffeineowl.graphics.bezier.QuadSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.SimpleConvexHullSubdivCriterion;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.renderer.RenderHints;
import org.openimaj.image.typography.FontRenderer;
import org.openimaj.image.typography.FontStyle;
import org.openimaj.image.typography.general.GeneralFont;
import org.openimaj.image.typography.general.GeneralFontStyle;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class GeneralFontRenderer<T>
extends FontRenderer<T, GeneralFontStyle<T>> {
    @Override
    public void renderText(ImageRenderer<T, ?> renderer, String text, int x, int y, GeneralFontStyle<T> style) {
        Polygon[] p = GeneralFontRenderer.getPolygons(text, x, y, style);
        p = this.alignPolygons(p, style);
        if (style.isOutline()) {
            for (Polygon polyOuter : p) {
                if (polyOuter.nVertices() > 0) {
                    renderer.drawPolygon(polyOuter, style.getColour());
                }
                for (Polygon poly : polyOuter.getInnerPolys()) {
                    if (poly.nVertices() <= 0) continue;
                    renderer.drawPolygon(poly, style.getColour());
                }
            }
        } else {
            for (Polygon poly : p) {
                if (poly.nVertices() <= 0) continue;
                renderer.drawPolygonFilled(poly, style.getColour());
            }
        }
    }

    private Polygon[] alignPolygons(Polygon[] p, FontStyle<T> sty) {
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = -minx;
        int maxy = -miny;
        for (Polygon polygon : p) {
            for (Point2d point2d : polygon) {
                minx = (int)Math.min(point2d.getX(), (float)minx);
                miny = (int)Math.min(point2d.getY(), (float)miny);
                maxx = (int)Math.max(point2d.getX(), (float)maxx);
                maxy = (int)Math.max(point2d.getY(), (float)maxy);
            }
        }
        Rectangle bb = new Rectangle((float)minx, (float)miny, (float)(maxx - minx), (float)(maxy - miny));
        if (sty.getHorizontalAlignment() != FontStyle.HorizontalAlignment.HORIZONTAL_LEFT) {
            float len = bb.width;
            Matrix trans = null;
            trans = sty.getHorizontalAlignment() == FontStyle.HorizontalAlignment.HORIZONTAL_CENTER ? TransformUtilities.translateMatrix((double)(-len / 2.0f), (double)0.0) : TransformUtilities.translateMatrix((double)(-len), (double)0.0);
            for (int i = 0; i < p.length; ++i) {
                p[i] = p[i].transform(trans);
            }
        }
        return p;
    }

    public static <T> Polygon[] getPolygons(String text, int x, int y, GeneralFontStyle<T> style) {
        return GeneralFontRenderer.getPolygons(text.toCharArray(), x, y, style);
    }

    public static <T> Polygon[] getPolygons(char[] characters, int x, int y, GeneralFontStyle<T> style) {
        Font f = new Font(style.getFont().getName(), ((GeneralFont)style.getFont()).getType(), style.getFontSize());
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        GlyphVector g = f.createGlyphVector(frc, characters);
        Polygon[] output = new Polygon[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            output[i] = new Polygon();
        }
        Polygon currentPoly = null;
        for (int i = 0; i < g.getNumGlyphs(); ++i) {
            Polygon letterPoly = output[g.getGlyphCharIndex(i)];
            GeneralPath s = (GeneralPath)g.getGlyphOutline(i, x, y);
            PathIterator pi = s.getPathIterator(new AffineTransform());
            float[] ps = new float[6];
            float xx = 0.0f;
            float yy = 0.0f;
            while (!pi.isDone()) {
                int t = pi.currentSegment(ps);
                switch (t) {
                    case 0: {
                        if (currentPoly != null && currentPoly.nVertices() > 0) {
                            letterPoly.addInnerPolygon(currentPoly.roundVertices());
                        }
                        currentPoly = new Polygon();
                        currentPoly.addVertex(ps[0], ps[1]);
                        xx = ps[0];
                        yy = ps[1];
                        break;
                    }
                    case 1: {
                        currentPoly.addVertex(ps[0], ps[1]);
                        xx = ps[0];
                        yy = ps[1];
                        break;
                    }
                    case 2: {
                        Shape c = new QuadCurve2D.Double(xx, yy, ps[0], ps[1], ps[2], ps[3]);
                        final Polygon p = currentPoly;
                        BezierUtils.adaptiveHalving((QuadCurve2D)c, (QuadSubdivisionCriterion)new SimpleConvexHullSubdivCriterion(), (QuadSegmentConsumer)new QuadSegmentConsumer(){

                            public void processSegment(QuadCurve2D segment, double startT, double endT) {
                                if (0.0 == startT) {
                                    p.addVertex((Point2d)new Point2dImpl((float)segment.getX1(), (float)segment.getY1()));
                                }
                                p.addVertex((Point2d)new Point2dImpl((float)segment.getX2(), (float)segment.getY2()));
                            }
                        });
                        xx = ps[2];
                        yy = ps[3];
                        break;
                    }
                    case 3: {
                        Shape c = new CubicCurve2D.Double(xx, yy, ps[0], ps[1], ps[2], ps[3], ps[4], ps[5]);
                        final Polygon p = currentPoly;
                        BezierUtils.adaptiveHalving((CubicCurve2D)c, (CubicSubdivisionCriterion)new SimpleConvexHullSubdivCriterion(), (CubicSegmentConsumer)new CubicSegmentConsumer(){

                            public void processSegment(CubicCurve2D segment, double startT, double endT) {
                                if (0.0 == startT) {
                                    p.addVertex((Point2d)new Point2dImpl((float)segment.getX1(), (float)segment.getY1()));
                                }
                                p.addVertex((Point2d)new Point2dImpl((float)segment.getX2(), (float)segment.getY2()));
                            }
                        });
                        xx = ps[4];
                        yy = ps[5];
                        break;
                    }
                    case 4: {
                        currentPoly.addVertex(ps[0], ps[1]);
                        letterPoly.addInnerPolygon(currentPoly.roundVertices());
                        currentPoly = new Polygon();
                    }
                }
                pi.next();
            }
        }
        return output;
    }

    @Override
    public Rectangle getSize(String string, GeneralFontStyle<T> style) {
        Polygon[] polys;
        Rectangle bounds = new Rectangle(0.0f, 0.0f, Float.MIN_VALUE, Float.MIN_VALUE);
        for (Polygon p : polys = GeneralFontRenderer.getPolygons(string, 0, 0, style)) {
            bounds.x = (float)Math.min((double)bounds.x, p.minX());
            bounds.y = (float)Math.min((double)bounds.y, p.minY());
            bounds.width = (float)Math.max((double)bounds.width, p.maxX() - (double)bounds.x);
            bounds.height = (float)Math.max((double)bounds.height, p.maxY() - (double)bounds.y);
        }
        return bounds;
    }

    public static void main(String[] args) {
        Polygon[] polys;
        FImage tmp = new FImage(800, 800);
        int size = 40;
        tmp.drawText("Hello World!", 20, 60, new GeneralFont("Arial", 0), 40);
        GeneralFontStyle<Float> gfs = new GeneralFontStyle<Float>(new GeneralFont("Arial", 0), (ImageRenderer<Float, ?>)tmp.createRenderer(RenderHints.ANTI_ALIASED));
        gfs.setFontSize(40);
        for (Polygon p : polys = GeneralFontRenderer.getPolygons("Hello World!", 20, 100, gfs)) {
            tmp.drawPolygon(p, Float.valueOf(1.0f));
        }
        Font fnt = new Font("Arial", 0, 40);
        BufferedImage bimg = ImageUtilities.createBufferedImage(tmp);
        Graphics g = bimg.getGraphics();
        g.setFont(fnt);
        g.drawString("Hello World!", 20, 140);
        GlyphVector gl = fnt.createGlyphVector(new FontRenderContext(null, true, true), "Hello World!");
        for (int i = 0; i < gl.getNumGlyphs(); ++i) {
            ((Graphics2D)g).fill(gl.getGlyphOutline(i, 20.0f, 180.0f));
        }
        DisplayUtilities.display(bimg);
    }
}

