/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.jhotdraw.contrib.Layoutable;
import org.jhotdraw.contrib.Layouter;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class SimpleLayouter
implements Layouter {
    private Layoutable myLayoutable;
    private Insets myInsets;
    static final long serialVersionUID = 2928651014089117493L;

    private SimpleLayouter() {
    }

    public SimpleLayouter(Layoutable layoutable) {
        this.setLayoutable(layoutable);
        this.setInsets(new Insets(0, 0, 0, 0));
    }

    public Layoutable getLayoutable() {
        return this.myLayoutable;
    }

    public void setLayoutable(Layoutable layoutable) {
        this.myLayoutable = layoutable;
    }

    public void setInsets(Insets insets) {
        this.myInsets = insets;
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public Layouter create(Layoutable layoutable) {
        SimpleLayouter simpleLayouter = new SimpleLayouter(layoutable);
        simpleLayouter.setInsets((Insets)this.getInsets().clone());
        return simpleLayouter;
    }

    public Rectangle calculateLayout(Point point, Point point2) {
        Rectangle rectangle = new Rectangle(point);
        rectangle.add(point2);
        FigureEnumeration figureEnumeration = this.getLayoutable().figures();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            rectangle.union(figure.displayBox());
        }
        rectangle.width += this.getInsets().left + this.getInsets().right;
        rectangle.height += this.getInsets().top + this.getInsets().bottom;
        return rectangle;
    }

    public Rectangle layout(Point point, Point point2) {
        return this.calculateLayout(point, point2);
    }

    public void read(StorableInput storableInput) throws IOException {
        this.setLayoutable((Layoutable)storableInput.readStorable());
        this.setInsets(new Insets(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt()));
    }

    public void write(StorableOutput storableOutput) {
        storableOutput.writeStorable(this.getLayoutable());
        Insets insets = this.getInsets();
        storableOutput.writeInt(insets.top);
        storableOutput.writeInt(insets.left);
        storableOutput.writeInt(insets.bottom);
        storableOutput.writeInt(insets.right);
    }
}

