/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.time;

import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.openimaj.time.TimeKeeper;
import org.openimaj.time.Timecode;

public class Sequencer
implements Runnable {
    private TimeKeeper<? extends Timecode> timeKeeper = null;
    private long tickAccuracyMillis = 1000L;
    private final TreeSet<SequencerEvent> events = new TreeSet();
    private boolean removeEventsWhenComplete = true;
    private boolean retryFailedEvents = false;
    private Timer timer = null;

    public Sequencer(TimeKeeper<? extends Timecode> timeKeeper) {
        this.timeKeeper = timeKeeper;
    }

    public Sequencer(TimeKeeper<? extends Timecode> timeKeeper, long tickAccuracyMillis) {
        this.timeKeeper = timeKeeper;
        this.tickAccuracyMillis = tickAccuracyMillis;
    }

    public void addEvent(SequencerEvent event) {
        this.events.add(event);
    }

    @Override
    public void run() {
        new Thread(this.timeKeeper).start();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new CheckActionTask(), 0L, this.tickAccuracyMillis);
    }

    public TreeSet<SequencerEvent> getEvents() {
        return this.events;
    }

    private void checkForActions() {
        long startProcessingTime = System.currentTimeMillis();
        Timecode tc = this.timeKeeper.getTime();
        long t = tc.getTimecodeInMilliseconds();
        Iterator<SequencerEvent> eventIterator = this.events.iterator();
        while (eventIterator.hasNext()) {
            SequencerEvent event = eventIterator.next();
            if (event.fired || event.timestamp > t) continue;
            boolean success = event.action.performAction();
            if ((success || !this.retryFailedEvents) && this.removeEventsWhenComplete) {
                eventIterator.remove();
                continue;
            }
            event.fired = this.retryFailedEvents ? success : true;
            event.failed = !success;
        }
        long processingTime = System.currentTimeMillis() - startProcessingTime;
        for (long nextTime = this.tickAccuracyMillis - processingTime; nextTime < 0L; nextTime += this.tickAccuracyMillis) {
        }
    }

    public void setRetryFailedEvents(boolean rfe) {
        this.retryFailedEvents = rfe;
    }

    public void setRemoveEventsWhenComplete(boolean rewc) {
        this.removeEventsWhenComplete = rewc;
    }

    private class CheckActionTask
    extends TimerTask {
        private CheckActionTask() {
        }

        @Override
        public void run() {
            Sequencer.this.checkForActions();
        }
    }

    public static class SequencerEvent
    implements Comparable<SequencerEvent> {
        public SequencedAction action = null;
        public long timestamp = 0L;
        public boolean fired = false;
        public boolean failed = false;

        public SequencerEvent(long timestamp, SequencedAction action) {
            this.timestamp = timestamp;
            this.action = action;
        }

        public SequencerEvent(Timecode tc, SequencedAction action) {
            this.timestamp = tc.getTimecodeInMilliseconds();
            this.action = action;
        }

        @Override
        public int compareTo(SequencerEvent event) {
            int v = (int)(this.timestamp - event.timestamp);
            if (v == 0 && event != this) {
                return -1;
            }
            return v;
        }

        public String toString() {
            return "@" + this.timestamp;
        }
    }

    public static interface SequencedAction {
        public boolean performAction();
    }
}

