/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.VectorFeature;
import org.myworldgis.util.VectorFeaturesToTurtlesUtil;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.LogoList;
import org.nlogo.core.Syntax;
import org.nlogo.nvm.AssemblerAssistant;
import org.nlogo.nvm.CustomAssembled;
import org.nlogo.nvm.ExtensionContext;

public strictfp class CreateTurtlesInsidePolygon {

    public strictfp static class TurtlesInsidePolygonManual
    extends TurtlesInsidePolygon {
        public Syntax getSyntax() {
            return VectorFeaturesToTurtlesUtil.makeTurtleCreationCommandSyntax(new Object[]{Syntax.WildcardType(), Syntax.TurtlesetType(), Syntax.NumberType(), Syntax.ListType(), Syntax.CommandBlockType() | Syntax.OptionalType()});
        }

        @Override
        public Map<String, Integer> getPropertyNameToTurtleVarIndex(List<String> variableNamesList, List<String> properties, Argument[] args) throws ExtensionException {
            Map<String, Integer> propertyNameToTurtleVarIndexMappings = VectorFeaturesToTurtlesUtil.getAutomaticPropertyNameToTurtleVarIndexMappings(variableNamesList, properties);
            LogoList manualList = args[3].getList();
            VectorFeaturesToTurtlesUtil.UpdatePropertyNameToTurtleVarMappingsWithManualAdditions(propertyNameToTurtleVarIndexMappings, manualList, variableNamesList);
            return propertyNameToTurtleVarIndexMappings;
        }
    }

    public strictfp static class TurtlesInsidePolygonAutomatic
    extends TurtlesInsidePolygon {
        public Syntax getSyntax() {
            return VectorFeaturesToTurtlesUtil.makeTurtleCreationCommandSyntax(new Object[]{Syntax.WildcardType(), Syntax.TurtlesetType(), Syntax.NumberType(), Syntax.CommandBlockType() | Syntax.OptionalType()});
        }

        @Override
        public Map<String, Integer> getPropertyNameToTurtleVarIndex(List<String> variableNamesList, List<String> properties, Argument[] args) {
            return VectorFeaturesToTurtlesUtil.getAutomaticPropertyNameToTurtleVarIndexMappings(variableNamesList, properties);
        }
    }

    private strictfp static abstract class TurtlesInsidePolygon
    extends GISExtension.Command
    implements CustomAssembled {
        private TurtlesInsidePolygon() {
        }

        protected abstract Map<String, Integer> getPropertyNameToTurtleVarIndex(List<String> var1, List<String> var2, Argument[] var3) throws ExtensionException;

        @Override
        public void performInternal(Argument[] args, Context context) throws ExtensionException, AgentException {
            ExtensionContext eContext = (ExtensionContext)context;
            org.nlogo.nvm.Context nvmContext = eContext.nvmContext();
            World world = (World)context.world();
            if (!(args[0].get() instanceof VectorFeature)) {
                throw new ExtensionException("Not a VectorFeature");
            }
            VectorFeature vectorFeature = (VectorFeature)args[0].get();
            if (vectorFeature.getShapeType() != VectorDataset.ShapeType.POLYGON) {
                throw new ExtensionException("Not a polygon feature");
            }
            AgentSet agentSetCandidate = args[1].getAgentSet();
            if (agentSetCandidate.printName() == null) {
                throw new ExtensionException("Expected breed, received non-breed turtleset");
            }
            TreeAgentSet breedAgentSet = agentSetCandidate.printName().equalsIgnoreCase("turtles") ? world.turtles() : world.getBreed(agentSetCandidate.printName());
            int numToMake = args[2].getIntValue();
            List<String> variableNamesList = VectorFeaturesToTurtlesUtil.getVariableNamesListForBreed(world, (AgentSet)breedAgentSet);
            List<String> propertyNamesList = Arrays.asList(vectorFeature.getPropertyNames());
            Map<String, Integer> propertyNameToTurtleVarIndex = this.getPropertyNameToTurtleVarIndex(variableNamesList, propertyNamesList, args);
            for (int i = 0; i < numToMake; ++i) {
                Coordinate coord = vectorFeature.getRandomPointInsidePolygon((Random)context.getRNG());
                Turtle turtle = VectorFeaturesToTurtlesUtil.CreateTurtleAtGISCoordinate(breedAgentSet, coord, world, nvmContext);
                if (turtle == null) {
                    GISExtension.getState().displayWarning("Tried to create turtle outside GIS envelope at: " + coord.toString() + ". Try setting your GIS world envelope with gis:set-world-envelope (gis:envelope-union-of (gis:envelope-of your-first-dataset) (gis:envelope-of your-second-dataset) etc.))");
                    continue;
                }
                VectorFeaturesToTurtlesUtil.setTurtleVariablesToVectorFeatureProperties(turtle, vectorFeature, propertyNameToTurtleVarIndex);
            }
            nvmContext.runExclusiveJob((org.nlogo.agent.AgentSet)breedAgentSet, nvmContext.ip + 1);
        }

        public void assemble(AssemblerAssistant assemblerAssistant) {
            assemblerAssistant.block();
            assemblerAssistant.done();
        }
    }
}

