/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusPopupBehavior;
import com.sun.javafx.scene.control.skin.MenuBarSkin;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.Window;
import javafx.util.Duration;

public class ContextMenuContent
extends Region {
    private ContextMenu contextMenu;
    private double maxGraphicWidth = 0.0;
    private double maxRightWidth = 0.0;
    private double maxLabelWidth = 0.0;
    private double maxRowHeight = 0.0;
    private double maxLeftWidth = 0.0;
    private double oldWidth = 0.0;
    private Rectangle clipRect;
    MenuBox itemsContainer;
    private ArrowMenuItem upArrow;
    private ArrowMenuItem downArrow;
    private int currentFocusedIndex = -1;
    private boolean itemsDirty = true;
    private InvalidationListener popupShowingListener = arg0 -> this.updateItems();
    private WeakInvalidationListener weakPopupShowingListener = new WeakInvalidationListener(this.popupShowingListener);
    private boolean isFirstShow = true;
    private double ty;
    private ChangeListener<Boolean> menuShowingListener = (observable, wasShowing, isShowing) -> {
        ReadOnlyBooleanProperty isShowingProperty = (ReadOnlyBooleanProperty)observable;
        Menu menu = (Menu)isShowingProperty.getBean();
        if (wasShowing.booleanValue() && !isShowing.booleanValue()) {
            this.hideSubmenu();
        } else if (!wasShowing.booleanValue() && isShowing.booleanValue()) {
            this.showSubmenu(menu);
        }
    };
    private ListChangeListener<MenuItem> contextMenuItemsListener = c -> {
        while (c.next()) {
            this.updateMenuShowingListeners(c.getRemoved(), false);
            this.updateMenuShowingListeners(c.getAddedSubList(), true);
        }
        this.itemsDirty = true;
        this.updateItems();
    };
    private ChangeListener<Boolean> menuItemVisibleListener = (observable, oldValue, newValue) -> this.requestLayout();
    private Menu openSubmenu;
    private ContextMenu submenu;
    Region selectedBackground;
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("selected");
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("disabled");
    private static final PseudoClass CHECKED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("checked");

    public ContextMenuContent(ContextMenu popupMenu) {
        this.contextMenu = popupMenu;
        this.clipRect = new Rectangle();
        this.clipRect.setSmooth(false);
        this.itemsContainer = new MenuBox();
        this.itemsContainer.setClip(this.clipRect);
        this.upArrow = new ArrowMenuItem(this);
        this.upArrow.setUp(true);
        this.upArrow.setFocusTraversable(false);
        this.downArrow = new ArrowMenuItem(this);
        this.downArrow.setUp(false);
        this.downArrow.setFocusTraversable(false);
        this.getChildren().add(this.itemsContainer);
        this.getChildren().add(this.upArrow);
        this.getChildren().add(this.downArrow);
        this.initialize();
        this.setUpBinds();
        this.updateItems();
        popupMenu.showingProperty().addListener(this.weakPopupShowingListener);
        if (Utils.isTwoLevelFocus()) {
            new TwoLevelFocusPopupBehavior(this);
        }
    }

    public VBox getItemsContainer() {
        return this.itemsContainer;
    }

    int getCurrentFocusIndex() {
        return this.currentFocusedIndex;
    }

    void setCurrentFocusedIndex(int index) {
        if (index < this.itemsContainer.getChildren().size()) {
            this.currentFocusedIndex = index;
        }
    }

    private void updateItems() {
        if (this.itemsDirty) {
            this.updateVisualItems();
            this.itemsDirty = false;
        }
    }

    private void computeVisualMetrics() {
        this.maxRightWidth = 0.0;
        this.maxLabelWidth = 0.0;
        this.maxRowHeight = 0.0;
        this.maxGraphicWidth = 0.0;
        this.maxLeftWidth = 0.0;
        for (int i = 0; i < this.itemsContainer.getChildren().size(); ++i) {
            MenuItemContainer menuItemContainer;
            Node child = (Node)this.itemsContainer.getChildren().get(i);
            if (!(child instanceof MenuItemContainer) || !(menuItemContainer = (MenuItemContainer)this.itemsContainer.getChildren().get(i)).isVisible()) continue;
            double alt = -1.0;
            Node n = menuItemContainer.left;
            if (n != null) {
                alt = n.getContentBias() == Orientation.VERTICAL ? this.snapSize(n.prefHeight(-1.0)) : -1.0;
                this.maxLeftWidth = Math.max(this.maxLeftWidth, this.snapSize(n.prefWidth(alt)));
                this.maxRowHeight = Math.max(this.maxRowHeight, n.prefHeight(-1.0));
            }
            if ((n = menuItemContainer.graphic) != null) {
                alt = n.getContentBias() == Orientation.VERTICAL ? this.snapSize(n.prefHeight(-1.0)) : -1.0;
                this.maxGraphicWidth = Math.max(this.maxGraphicWidth, this.snapSize(n.prefWidth(alt)));
                this.maxRowHeight = Math.max(this.maxRowHeight, n.prefHeight(-1.0));
            }
            if ((n = menuItemContainer.label) != null) {
                alt = n.getContentBias() == Orientation.VERTICAL ? this.snapSize(n.prefHeight(-1.0)) : -1.0;
                this.maxLabelWidth = Math.max(this.maxLabelWidth, this.snapSize(n.prefWidth(alt)));
                this.maxRowHeight = Math.max(this.maxRowHeight, n.prefHeight(-1.0));
            }
            if ((n = menuItemContainer.right) == null) continue;
            alt = n.getContentBias() == Orientation.VERTICAL ? this.snapSize(n.prefHeight(-1.0)) : -1.0;
            this.maxRightWidth = Math.max(this.maxRightWidth, this.snapSize(n.prefWidth(alt)));
            this.maxRowHeight = Math.max(this.maxRowHeight, n.prefHeight(-1.0));
        }
        double newWidth = this.maxRightWidth + this.maxLabelWidth + this.maxGraphicWidth + this.maxLeftWidth;
        Window ownerWindow = this.contextMenu.getOwnerWindow();
        if (ownerWindow instanceof ContextMenu && this.contextMenu.getX() < ownerWindow.getX() && this.oldWidth != newWidth) {
            this.contextMenu.setX(this.contextMenu.getX() + this.oldWidth - newWidth);
        }
        this.oldWidth = newWidth;
    }

    private void updateVisualItems() {
        ObservableList<Node> itemsContainerChilder = this.itemsContainer.getChildren();
        this.disposeVisualItems();
        for (int row = 0; row < this.getItems().size(); ++row) {
            MenuItem item = (MenuItem)this.getItems().get(row);
            if (item instanceof CustomMenuItem && ((CustomMenuItem)item).getContent() == null) continue;
            if (item instanceof SeparatorMenuItem) {
                Node node = ((CustomMenuItem)item).getContent();
                node.visibleProperty().bind(item.visibleProperty());
                itemsContainerChilder.add(node);
                node.getProperties().put(MenuItem.class, item);
                continue;
            }
            MenuItemContainer menuItemContainer = new MenuItemContainer(item);
            menuItemContainer.visibleProperty().bind(item.visibleProperty());
            itemsContainerChilder.add(menuItemContainer);
        }
        if (this.getItems().size() > 0) {
            MenuItem item = (MenuItem)this.getItems().get(0);
            this.getProperties().put(Menu.class, item.getParentMenu());
        }
        this.impl_reapplyCSS();
    }

    private void disposeVisualItems() {
        ObservableList<Node> itemsContainerChilder = this.itemsContainer.getChildren();
        int max = itemsContainerChilder.size();
        for (int i = 0; i < max; ++i) {
            Node n = (Node)itemsContainerChilder.get(i);
            if (!(n instanceof MenuItemContainer)) continue;
            MenuItemContainer container = (MenuItemContainer)n;
            container.visibleProperty().unbind();
            container.dispose();
        }
        itemsContainerChilder.clear();
    }

    public void dispose() {
        this.disposeBinds();
        this.disposeVisualItems();
        this.disposeContextMenu(this.submenu);
        this.submenu = null;
        this.openSubmenu = null;
        this.selectedBackground = null;
        if (this.contextMenu != null) {
            this.contextMenu.getItems().clear();
            this.contextMenu = null;
        }
    }

    public void disposeContextMenu(ContextMenu menu) {
        if (menu == null) {
            return;
        }
        Skin<?> skin = menu.getSkin();
        if (skin == null) {
            return;
        }
        ContextMenuContent cmContent = (ContextMenuContent)skin.getNode();
        if (cmContent == null) {
            return;
        }
        cmContent.dispose();
    }

    @Override
    protected void layoutChildren() {
        double prefHeight;
        if (this.itemsContainer.getChildren().size() == 0) {
            return;
        }
        double x = this.snappedLeftInset();
        double y = this.snappedTopInset();
        double w = this.getWidth() - x - this.snappedRightInset();
        double h = this.getHeight() - y - this.snappedBottomInset();
        double contentHeight = this.snapSize(this.getContentHeight());
        this.itemsContainer.resize(w, contentHeight);
        this.itemsContainer.relocate(x, y);
        if (this.isFirstShow && this.ty == 0.0) {
            this.upArrow.setVisible(false);
            this.isFirstShow = false;
        } else {
            this.upArrow.setVisible(this.ty < y && this.ty < 0.0);
        }
        this.downArrow.setVisible(this.ty + contentHeight > y + h);
        this.clipRect.setX(0.0);
        this.clipRect.setY(0.0);
        this.clipRect.setWidth(w);
        this.clipRect.setHeight(h);
        if (this.upArrow.isVisible()) {
            prefHeight = this.snapSize(this.upArrow.prefHeight(-1.0));
            this.clipRect.setHeight(this.snapSize(this.clipRect.getHeight() - prefHeight));
            this.clipRect.setY(this.snapSize(this.clipRect.getY()) + prefHeight);
            this.upArrow.resize(this.snapSize(this.upArrow.prefWidth(-1.0)), prefHeight);
            this.positionInArea(this.upArrow, x, y, w, prefHeight, 0.0, HPos.CENTER, VPos.CENTER);
        }
        if (this.downArrow.isVisible()) {
            prefHeight = this.snapSize(this.downArrow.prefHeight(-1.0));
            this.clipRect.setHeight(this.snapSize(this.clipRect.getHeight()) - prefHeight);
            this.downArrow.resize(this.snapSize(this.downArrow.prefWidth(-1.0)), prefHeight);
            this.positionInArea(this.downArrow, x, y + h - prefHeight, w, prefHeight, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    @Override
    protected double computePrefWidth(double height) {
        this.computeVisualMetrics();
        double prefWidth = 0.0;
        if (this.itemsContainer.getChildren().size() == 0) {
            return 0.0;
        }
        for (Node n : this.itemsContainer.getChildren()) {
            if (!n.isVisible()) continue;
            prefWidth = Math.max(prefWidth, this.snapSize(n.prefWidth(-1.0)));
        }
        return this.snappedLeftInset() + this.snapSize(prefWidth) + this.snappedRightInset();
    }

    @Override
    protected double computePrefHeight(double width) {
        if (this.itemsContainer.getChildren().size() == 0) {
            return 0.0;
        }
        double screenHeight = this.getScreenHeight();
        double contentHeight = this.getContentHeight();
        double totalHeight = this.snappedTopInset() + this.snapSize(contentHeight) + this.snappedBottomInset();
        double prefHeight = screenHeight <= 0.0 ? totalHeight : Math.min(totalHeight, screenHeight);
        return prefHeight;
    }

    @Override
    protected double computeMinHeight(double width) {
        return 0.0;
    }

    @Override
    protected double computeMaxHeight(double height) {
        return this.getScreenHeight();
    }

    private double getScreenHeight() {
        if (this.contextMenu == null || this.contextMenu.getOwnerWindow() == null || this.contextMenu.getOwnerWindow().getScene() == null) {
            return -1.0;
        }
        return this.snapSize(com.sun.javafx.util.Utils.getScreen(this.contextMenu.getOwnerWindow().getScene().getRoot()).getVisualBounds().getHeight());
    }

    private double getContentHeight() {
        double h = 0.0;
        for (Node i : this.itemsContainer.getChildren()) {
            if (!i.isVisible()) continue;
            h += this.snapSize(i.prefHeight(-1.0));
        }
        return h;
    }

    private void ensureFocusedMenuItemIsVisible(Node node) {
        if (node == null) {
            return;
        }
        Bounds nodeBounds = node.getBoundsInParent();
        Bounds clipBounds = this.clipRect.getBoundsInParent();
        if (nodeBounds.getMaxY() >= clipBounds.getMaxY()) {
            this.scroll(-nodeBounds.getMaxY() + clipBounds.getMaxY());
        } else if (nodeBounds.getMinY() <= clipBounds.getMinY()) {
            this.scroll(-nodeBounds.getMinY() + clipBounds.getMinY());
        }
    }

    protected ObservableList<MenuItem> getItems() {
        return this.contextMenu.getItems();
    }

    private int findFocusedIndex() {
        for (int i = 0; i < this.itemsContainer.getChildren().size(); ++i) {
            Node n = (Node)this.itemsContainer.getChildren().get(i);
            if (!n.isFocused()) continue;
            return i;
        }
        return -1;
    }

    private void initialize() {
        this.contextMenu.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.currentFocusedIndex = -1;
                this.requestFocus();
            }
        });
        this.contextMenu.addEventHandler(Menu.ON_SHOWN, event -> {
            for (Node child : this.itemsContainer.getChildren()) {
                MenuItem item;
                if (!(child instanceof MenuItemContainer) || !"choice-box-menu-item".equals((item = ((MenuItemContainer)child).item).getId()) || !((RadioMenuItem)item).isSelected()) continue;
                child.requestFocus();
                break;
            }
        });
        this.setOnKeyPressed((EventHandler<? super KeyEvent>)new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent ke) {
                Node ownerNode;
                switch (ke.getCode()) {
                    case LEFT: {
                        if (ContextMenuContent.this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                            ContextMenuContent.this.processRightKey(ke);
                            break;
                        }
                        ContextMenuContent.this.processLeftKey(ke);
                        break;
                    }
                    case RIGHT: {
                        if (ContextMenuContent.this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                            ContextMenuContent.this.processLeftKey(ke);
                            break;
                        }
                        ContextMenuContent.this.processRightKey(ke);
                        break;
                    }
                    case CANCEL: {
                        ke.consume();
                        break;
                    }
                    case ESCAPE: {
                        ownerNode = ContextMenuContent.this.contextMenu.getOwnerNode();
                        if (ownerNode instanceof MenuBarSkin.MenuBarButton) break;
                        ContextMenuContent.this.contextMenu.hide();
                        ke.consume();
                        break;
                    }
                    case DOWN: {
                        ContextMenuContent.this.moveToNextSibling();
                        ke.consume();
                        break;
                    }
                    case UP: {
                        ContextMenuContent.this.moveToPreviousSibling();
                        ke.consume();
                        break;
                    }
                    case SPACE: 
                    case ENTER: {
                        ContextMenuContent.this.selectMenuItem();
                        ke.consume();
                        break;
                    }
                }
                if (!ke.isConsumed()) {
                    MenuBarSkin mbs;
                    ownerNode = ContextMenuContent.this.contextMenu.getOwnerNode();
                    if (ownerNode instanceof MenuItemContainer) {
                        Parent parent;
                        for (parent = ownerNode.getParent(); parent != null && !(parent instanceof ContextMenuContent); parent = parent.getParent()) {
                        }
                        if (parent instanceof ContextMenuContent) {
                            parent.getOnKeyPressed().handle(ke);
                        }
                    } else if (ownerNode instanceof MenuBarSkin.MenuBarButton && (mbs = ((MenuBarSkin.MenuBarButton)ownerNode).getMenuBarSkin()) != null && mbs.getKeyEventHandler() != null) {
                        mbs.getKeyEventHandler().handle(ke);
                    }
                }
            }
        });
        this.addEventHandler(ScrollEvent.SCROLL, event -> {
            double textDeltaY = event.getTextDeltaY();
            double deltaY = event.getDeltaY();
            if (this.downArrow.isVisible() && (textDeltaY < 0.0 || deltaY < 0.0) || this.upArrow.isVisible() && (textDeltaY > 0.0 || deltaY > 0.0)) {
                switch (event.getTextDeltaYUnits()) {
                    case LINES: {
                        int focusedIndex = this.findFocusedIndex();
                        if (focusedIndex == -1) {
                            focusedIndex = 0;
                        }
                        double rowHeight = ((Node)this.itemsContainer.getChildren().get(focusedIndex)).prefHeight(-1.0);
                        this.scroll(textDeltaY * rowHeight);
                        break;
                    }
                    case PAGES: {
                        this.scroll(textDeltaY * this.itemsContainer.getHeight());
                        break;
                    }
                    case NONE: {
                        this.scroll(deltaY);
                    }
                }
                event.consume();
            }
        });
    }

    private void processLeftKey(KeyEvent ke) {
        Menu menu;
        MenuItem item;
        Node n;
        if (this.currentFocusedIndex != -1 && (n = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex)) instanceof MenuItemContainer && (item = ((MenuItemContainer)n).item) instanceof Menu && (menu = (Menu)item) == this.openSubmenu && this.submenu != null && this.submenu.isShowing()) {
            this.hideSubmenu();
            ke.consume();
        }
    }

    private void processRightKey(KeyEvent ke) {
        MenuItem item;
        Node n;
        if (this.currentFocusedIndex != -1 && (n = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex)) instanceof MenuItemContainer && (item = ((MenuItemContainer)n).item) instanceof Menu) {
            Menu menu = (Menu)item;
            if (menu.isDisable()) {
                return;
            }
            this.selectedBackground = (MenuItemContainer)n;
            if (this.openSubmenu == menu && this.submenu != null && this.submenu.isShowing()) {
                return;
            }
            this.showMenu(menu);
            ke.consume();
        }
    }

    private void showMenu(Menu menu) {
        menu.show();
        ContextMenuContent cmContent = (ContextMenuContent)this.submenu.getSkin().getNode();
        if (cmContent != null) {
            if (cmContent.itemsContainer.getChildren().size() > 0) {
                ((Node)cmContent.itemsContainer.getChildren().get(0)).requestFocus();
                cmContent.currentFocusedIndex = 0;
            } else {
                cmContent.requestFocus();
            }
        }
    }

    private void selectMenuItem() {
        Node n;
        if (this.currentFocusedIndex != -1 && (n = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex)) instanceof MenuItemContainer) {
            MenuItem item = ((MenuItemContainer)n).item;
            if (item instanceof Menu) {
                Menu menu = (Menu)item;
                if (this.openSubmenu != null) {
                    this.hideSubmenu();
                }
                if (menu.isDisable()) {
                    return;
                }
                this.selectedBackground = (MenuItemContainer)n;
                menu.show();
            } else {
                ((MenuItemContainer)n).doSelect();
            }
        }
    }

    private int findNext(int from) {
        Node n;
        int i;
        for (i = from; i < this.itemsContainer.getChildren().size(); ++i) {
            n = (Node)this.itemsContainer.getChildren().get(i);
            if (!(n instanceof MenuItemContainer)) continue;
            return i;
        }
        for (i = 0; i < from; ++i) {
            n = (Node)this.itemsContainer.getChildren().get(i);
            if (!(n instanceof MenuItemContainer)) continue;
            return i;
        }
        return -1;
    }

    private void moveToNextSibling() {
        if (this.currentFocusedIndex != -1) {
            this.currentFocusedIndex = this.findNext(this.currentFocusedIndex + 1);
        } else if (this.currentFocusedIndex == -1 || this.currentFocusedIndex == this.itemsContainer.getChildren().size() - 1) {
            this.currentFocusedIndex = this.findNext(0);
        }
        if (this.currentFocusedIndex != -1) {
            Node n = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex);
            this.selectedBackground = (MenuItemContainer)n;
            n.requestFocus();
            this.ensureFocusedMenuItemIsVisible(n);
        }
    }

    private int findPrevious(int from) {
        Node n;
        int i;
        for (i = from; i >= 0; --i) {
            n = (Node)this.itemsContainer.getChildren().get(i);
            if (!(n instanceof MenuItemContainer)) continue;
            return i;
        }
        for (i = this.itemsContainer.getChildren().size() - 1; i > from; --i) {
            n = (Node)this.itemsContainer.getChildren().get(i);
            if (!(n instanceof MenuItemContainer)) continue;
            return i;
        }
        return -1;
    }

    private void moveToPreviousSibling() {
        if (this.currentFocusedIndex != -1) {
            this.currentFocusedIndex = this.findPrevious(this.currentFocusedIndex - 1);
        } else if (this.currentFocusedIndex == -1 || this.currentFocusedIndex == 0) {
            this.currentFocusedIndex = this.findPrevious(this.itemsContainer.getChildren().size() - 1);
        }
        if (this.currentFocusedIndex != -1) {
            Node n = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex);
            this.selectedBackground = (MenuItemContainer)n;
            n.requestFocus();
            this.ensureFocusedMenuItemIsVisible(n);
        }
    }

    double getMenuYOffset(int menuIndex) {
        double offset = 0.0;
        if (this.itemsContainer.getChildren().size() > menuIndex) {
            offset = this.snappedTopInset();
            Node menuitem = (Node)this.itemsContainer.getChildren().get(menuIndex);
            offset += menuitem.getLayoutY() + menuitem.prefHeight(-1.0);
        }
        return offset;
    }

    private void setUpBinds() {
        this.updateMenuShowingListeners(this.contextMenu.getItems(), true);
        this.contextMenu.getItems().addListener(this.contextMenuItemsListener);
    }

    private void disposeBinds() {
        this.updateMenuShowingListeners(this.contextMenu.getItems(), false);
        this.contextMenu.getItems().removeListener(this.contextMenuItemsListener);
    }

    private void updateMenuShowingListeners(List<? extends MenuItem> items, boolean addListeners) {
        for (MenuItem menuItem : items) {
            if (menuItem instanceof Menu) {
                Menu menu = (Menu)menuItem;
                if (addListeners) {
                    menu.showingProperty().addListener(this.menuShowingListener);
                } else {
                    menu.showingProperty().removeListener(this.menuShowingListener);
                }
            }
            if (addListeners) {
                menuItem.visibleProperty().addListener(this.menuItemVisibleListener);
                continue;
            }
            menuItem.visibleProperty().removeListener(this.menuItemVisibleListener);
        }
    }

    ContextMenu getSubMenu() {
        return this.submenu;
    }

    Menu getOpenSubMenu() {
        return this.openSubmenu;
    }

    private void createSubmenu() {
        if (this.submenu == null) {
            this.submenu = new ContextMenu();
            this.submenu.showingProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (!ContextMenuContent.this.submenu.isShowing()) {
                        for (Node node : ContextMenuContent.this.itemsContainer.getChildren()) {
                            Menu menu;
                            if (!(node instanceof MenuItemContainer) || !(((MenuItemContainer)node).item instanceof Menu) || !(menu = (Menu)((MenuItemContainer)node).item).isShowing()) continue;
                            menu.hide();
                        }
                    }
                }
            });
        }
    }

    private void showSubmenu(Menu menu) {
        this.openSubmenu = menu;
        this.createSubmenu();
        this.submenu.getItems().setAll((Collection<MenuItem>)menu.getItems());
        this.submenu.show(this.selectedBackground, Side.RIGHT, 0.0, 0.0);
    }

    private void hideSubmenu() {
        if (this.submenu == null) {
            return;
        }
        this.submenu.hide();
        this.openSubmenu = null;
        this.disposeContextMenu(this.submenu);
        this.submenu = null;
    }

    private void hideAllMenus(MenuItem item) {
        Menu parentMenu;
        if (this.contextMenu != null) {
            this.contextMenu.hide();
        }
        while ((parentMenu = item.getParentMenu()) != null) {
            parentMenu.hide();
            item = parentMenu;
        }
        if (item.getParentPopup() != null) {
            item.getParentPopup().hide();
        }
    }

    void scroll(double delta) {
        double newTy = this.ty + delta;
        if (this.ty == newTy) {
            return;
        }
        if (newTy > 0.0) {
            newTy = 0.0;
        }
        if (delta < 0.0 && this.getHeight() - newTy > this.itemsContainer.getHeight() - this.downArrow.getHeight()) {
            newTy = this.getHeight() - this.itemsContainer.getHeight() - this.downArrow.getHeight();
        }
        this.ty = newTy;
        this.itemsContainer.requestLayout();
    }

    @Override
    public Styleable getStyleableParent() {
        return this.contextMenu;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ContextMenuContent.getClassCssMetaData();
    }

    protected Label getLabelAt(int index) {
        return ((MenuItemContainer)this.itemsContainer.getChildren().get(index)).getLabel();
    }

    private class MenuLabel
    extends Label {
        public MenuLabel(MenuItem item, MenuItemContainer mic) {
            super(item.getText());
            this.setMnemonicParsing(item.isMnemonicParsing());
            this.setLabelFor(mic);
        }
    }

    public class MenuItemContainer
    extends Region {
        private final MenuItem item;
        private Node left;
        private Node graphic;
        private Node label;
        private Node right;
        private final MultiplePropertyChangeListenerHandler listener = new MultiplePropertyChangeListenerHandler(param -> {
            this.handlePropertyChanged((String)param);
            return null;
        });
        private EventHandler<MouseEvent> mouseEnteredEventHandler;
        private EventHandler<MouseEvent> mouseReleasedEventHandler;
        private EventHandler<ActionEvent> actionEventHandler;
        private EventHandler<MouseEvent> customMenuItemMouseClickedHandler;

        protected Label getLabel() {
            return (Label)this.label;
        }

        public MenuItem getItem() {
            return this.item;
        }

        public MenuItemContainer(MenuItem item) {
            if (item == null) {
                throw new NullPointerException("MenuItem can not be null");
            }
            this.getStyleClass().addAll((Collection<String>)item.getStyleClass());
            this.setId(item.getId());
            this.setFocusTraversable(!(item instanceof CustomMenuItem));
            this.item = item;
            this.createChildren();
            if (item instanceof Menu) {
                ReadOnlyBooleanProperty pseudoProperty = ((Menu)item).showingProperty();
                this.listener.registerChangeListener(pseudoProperty, "MENU_SHOWING");
                this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, pseudoProperty.get());
                this.setAccessibleRole(AccessibleRole.MENU);
            } else if (item instanceof RadioMenuItem) {
                BooleanProperty pseudoProperty = ((RadioMenuItem)item).selectedProperty();
                this.listener.registerChangeListener(pseudoProperty, "RADIO_ITEM_SELECTED");
                this.pseudoClassStateChanged(CHECKED_PSEUDOCLASS_STATE, pseudoProperty.get());
                this.setAccessibleRole(AccessibleRole.RADIO_MENU_ITEM);
            } else if (item instanceof CheckMenuItem) {
                BooleanProperty pseudoProperty = ((CheckMenuItem)item).selectedProperty();
                this.listener.registerChangeListener(pseudoProperty, "CHECK_ITEM_SELECTED");
                this.pseudoClassStateChanged(CHECKED_PSEUDOCLASS_STATE, pseudoProperty.get());
                this.setAccessibleRole(AccessibleRole.CHECK_MENU_ITEM);
            } else {
                this.setAccessibleRole(AccessibleRole.MENU_ITEM);
            }
            this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, item.disableProperty().get());
            this.listener.registerChangeListener(item.disableProperty(), "DISABLE");
            this.getProperties().put(MenuItem.class, item);
            this.listener.registerChangeListener(item.graphicProperty(), "GRAPHIC");
            this.actionEventHandler = e -> {
                if (item instanceof Menu) {
                    Menu menu = (Menu)item;
                    if (ContextMenuContent.this.openSubmenu == menu && ContextMenuContent.this.submenu.isShowing()) {
                        return;
                    }
                    if (ContextMenuContent.this.openSubmenu != null) {
                        ContextMenuContent.this.hideSubmenu();
                    }
                    ContextMenuContent.this.selectedBackground = this;
                    ContextMenuContent.this.showMenu(menu);
                } else {
                    this.doSelect();
                }
            };
            this.addEventHandler(ActionEvent.ACTION, this.actionEventHandler);
        }

        public void dispose() {
            Node node;
            if (this.item instanceof CustomMenuItem && (node = ((CustomMenuItem)this.item).getContent()) != null) {
                node.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.customMenuItemMouseClickedHandler);
            }
            this.listener.dispose();
            this.removeEventHandler(ActionEvent.ACTION, this.actionEventHandler);
            if (this.label != null) {
                ((Label)this.label).textProperty().unbind();
            }
            this.left = null;
            this.graphic = null;
            this.label = null;
            this.right = null;
        }

        private void handlePropertyChanged(String p) {
            if ("MENU_SHOWING".equals(p)) {
                Menu menu = (Menu)this.item;
                this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, menu.isShowing());
            } else if ("RADIO_ITEM_SELECTED".equals(p)) {
                RadioMenuItem radioItem = (RadioMenuItem)this.item;
                this.pseudoClassStateChanged(CHECKED_PSEUDOCLASS_STATE, radioItem.isSelected());
            } else if ("CHECK_ITEM_SELECTED".equals(p)) {
                CheckMenuItem checkItem = (CheckMenuItem)this.item;
                this.pseudoClassStateChanged(CHECKED_PSEUDOCLASS_STATE, checkItem.isSelected());
            } else if ("DISABLE".equals(p)) {
                this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, this.item.isDisable());
            } else if ("GRAPHIC".equals(p)) {
                this.createChildren();
                ContextMenuContent.this.computeVisualMetrics();
            } else if ("ACCELERATOR".equals(p)) {
                this.updateAccelerator();
            } else if ("FOCUSED".equals(p) && this.isFocused()) {
                ContextMenuContent.this.currentFocusedIndex = ContextMenuContent.this.itemsContainer.getChildren().indexOf(this);
            }
        }

        private void createChildren() {
            this.getChildren().clear();
            if (this.item instanceof CustomMenuItem) {
                this.createNodeMenuItemChildren((CustomMenuItem)this.item);
                if (this.mouseEnteredEventHandler == null) {
                    this.mouseEnteredEventHandler = event -> this.requestFocus();
                } else {
                    this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
                }
                this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            } else {
                Node leftNode = this.getLeftGraphic(this.item);
                if (leftNode != null) {
                    StackPane leftPane = new StackPane();
                    leftPane.getStyleClass().add("left-container");
                    leftPane.getChildren().add(leftNode);
                    this.left = leftPane;
                    this.getChildren().add(this.left);
                    this.left.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
                }
                if (this.item.getGraphic() != null) {
                    Node graphicNode = this.item.getGraphic();
                    StackPane graphicPane = new StackPane();
                    graphicPane.getStyleClass().add("graphic-container");
                    graphicPane.getChildren().add(graphicNode);
                    this.graphic = graphicPane;
                    this.getChildren().add(this.graphic);
                }
                this.label = new MenuLabel(this.item, this);
                this.label.setStyle(this.item.getStyle());
                ((Label)this.label).textProperty().bind(this.item.textProperty());
                this.label.setMouseTransparent(true);
                this.getChildren().add(this.label);
                this.listener.unregisterChangeListener(this.focusedProperty());
                this.listener.registerChangeListener(this.focusedProperty(), "FOCUSED");
                if (this.item instanceof Menu) {
                    Region rightNode = new Region();
                    rightNode.setMouseTransparent(true);
                    rightNode.getStyleClass().add("arrow");
                    StackPane rightPane = new StackPane();
                    rightPane.setMaxWidth(Math.max(rightNode.prefWidth(-1.0), 10.0));
                    rightPane.setMouseTransparent(true);
                    rightPane.getStyleClass().add("right-container");
                    rightPane.getChildren().add(rightNode);
                    this.right = rightPane;
                    this.getChildren().add(rightPane);
                    if (this.mouseEnteredEventHandler == null) {
                        this.mouseEnteredEventHandler = event -> {
                            Menu menu;
                            if (ContextMenuContent.this.openSubmenu != null && this.item != ContextMenuContent.this.openSubmenu) {
                                ContextMenuContent.this.hideSubmenu();
                            }
                            if ((menu = (Menu)this.item).isDisable()) {
                                return;
                            }
                            ContextMenuContent.this.selectedBackground = this;
                            menu.show();
                            this.requestFocus();
                        };
                    } else {
                        this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
                    }
                    if (this.mouseReleasedEventHandler == null) {
                        this.mouseReleasedEventHandler = event -> this.item.fire();
                    } else {
                        this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
                    }
                    this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
                    this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
                } else {
                    this.listener.unregisterChangeListener(this.item.acceleratorProperty());
                    this.updateAccelerator();
                    if (this.mouseEnteredEventHandler == null) {
                        this.mouseEnteredEventHandler = event -> {
                            if (ContextMenuContent.this.openSubmenu != null) {
                                ContextMenuContent.this.openSubmenu.hide();
                            }
                            this.requestFocus();
                        };
                    } else {
                        this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
                    }
                    if (this.mouseReleasedEventHandler == null) {
                        this.mouseReleasedEventHandler = event -> this.doSelect();
                    } else {
                        this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
                    }
                    this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
                    this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
                    this.listener.registerChangeListener(this.item.acceleratorProperty(), "ACCELERATOR");
                }
            }
        }

        private void updateAccelerator() {
            if (this.item.getAccelerator() != null) {
                if (this.right != null) {
                    this.getChildren().remove(this.right);
                }
                String text = this.item.getAccelerator().getDisplayText();
                this.right = new Label(text);
                this.right.setStyle(this.item.getStyle());
                this.right.getStyleClass().add("accelerator-text");
                this.getChildren().add(this.right);
            } else {
                this.getChildren().remove(this.right);
            }
        }

        void doSelect() {
            if (this.item.isDisable()) {
                return;
            }
            if (this.item instanceof CheckMenuItem) {
                CheckMenuItem checkItem;
                checkItem.setSelected(!(checkItem = (CheckMenuItem)this.item).isSelected());
            } else if (this.item instanceof RadioMenuItem) {
                RadioMenuItem radioItem;
                radioItem.setSelected((radioItem = (RadioMenuItem)this.item).getToggleGroup() != null ? true : !radioItem.isSelected());
            }
            this.item.fire();
            if (this.item instanceof CustomMenuItem) {
                CustomMenuItem customMenuItem = (CustomMenuItem)this.item;
                if (customMenuItem.isHideOnClick()) {
                    ContextMenuContent.this.hideAllMenus(this.item);
                }
            } else {
                ContextMenuContent.this.hideAllMenus(this.item);
            }
        }

        private void createNodeMenuItemChildren(CustomMenuItem item) {
            Node node = item.getContent();
            this.getChildren().add(node);
            this.customMenuItemMouseClickedHandler = event -> {
                if (item == null || item.isDisable()) {
                    return;
                }
                item.fire();
                if (item.isHideOnClick()) {
                    ContextMenuContent.this.hideAllMenus(item);
                }
            };
            node.addEventHandler(MouseEvent.MOUSE_CLICKED, this.customMenuItemMouseClickedHandler);
        }

        @Override
        protected void layoutChildren() {
            double xOffset;
            double prefHeight = this.prefHeight(-1.0);
            if (this.left != null) {
                xOffset = this.snappedLeftInset();
                this.left.resize(this.left.prefWidth(-1.0), this.left.prefHeight(-1.0));
                this.positionInArea(this.left, xOffset, 0.0, ContextMenuContent.this.maxLeftWidth, prefHeight, 0.0, HPos.LEFT, VPos.CENTER);
            }
            if (this.graphic != null) {
                xOffset = this.snappedLeftInset() + ContextMenuContent.this.maxLeftWidth;
                this.graphic.resize(this.graphic.prefWidth(-1.0), this.graphic.prefHeight(-1.0));
                this.positionInArea(this.graphic, xOffset, 0.0, ContextMenuContent.this.maxGraphicWidth, prefHeight, 0.0, HPos.LEFT, VPos.CENTER);
            }
            if (this.label != null) {
                xOffset = this.snappedLeftInset() + ContextMenuContent.this.maxLeftWidth + ContextMenuContent.this.maxGraphicWidth;
                this.label.resize(this.label.prefWidth(-1.0), this.label.prefHeight(-1.0));
                this.positionInArea(this.label, xOffset, 0.0, ContextMenuContent.this.maxLabelWidth, prefHeight, 0.0, HPos.LEFT, VPos.CENTER);
            }
            if (this.right != null) {
                xOffset = this.snappedLeftInset() + ContextMenuContent.this.maxLeftWidth + ContextMenuContent.this.maxGraphicWidth + ContextMenuContent.this.maxLabelWidth;
                this.right.resize(this.right.prefWidth(-1.0), this.right.prefHeight(-1.0));
                this.positionInArea(this.right, xOffset, 0.0, ContextMenuContent.this.maxRightWidth, prefHeight, 0.0, HPos.RIGHT, VPos.CENTER);
            }
            if (this.item instanceof CustomMenuItem) {
                Node n = ((CustomMenuItem)this.item).getContent();
                if (this.item instanceof SeparatorMenuItem) {
                    double width = this.prefWidth(-1.0) - (this.snappedLeftInset() + ContextMenuContent.this.maxGraphicWidth + this.snappedRightInset());
                    n.resize(width, n.prefHeight(-1.0));
                    this.positionInArea(n, this.snappedLeftInset() + ContextMenuContent.this.maxGraphicWidth, 0.0, this.prefWidth(-1.0), prefHeight, 0.0, HPos.LEFT, VPos.CENTER);
                } else {
                    n.resize(n.prefWidth(-1.0), n.prefHeight(-1.0));
                    this.positionInArea(n, this.snappedLeftInset(), 0.0, this.getWidth(), prefHeight, 0.0, HPos.LEFT, VPos.CENTER);
                }
            }
        }

        @Override
        protected double computePrefHeight(double width) {
            double prefHeight = 0.0;
            if (this.item instanceof CustomMenuItem || this.item instanceof SeparatorMenuItem) {
                prefHeight = this.getChildren().isEmpty() ? 0.0 : ((Node)this.getChildren().get(0)).prefHeight(-1.0);
            } else {
                prefHeight = Math.max(prefHeight, this.left != null ? this.left.prefHeight(-1.0) : 0.0);
                prefHeight = Math.max(prefHeight, this.graphic != null ? this.graphic.prefHeight(-1.0) : 0.0);
                prefHeight = Math.max(prefHeight, this.label != null ? this.label.prefHeight(-1.0) : 0.0);
                prefHeight = Math.max(prefHeight, this.right != null ? this.right.prefHeight(-1.0) : 0.0);
            }
            return this.snappedTopInset() + prefHeight + this.snappedBottomInset();
        }

        @Override
        protected double computePrefWidth(double height) {
            double nodeMenuItemWidth = 0.0;
            if (this.item instanceof CustomMenuItem && !(this.item instanceof SeparatorMenuItem)) {
                nodeMenuItemWidth = this.snappedLeftInset() + ((CustomMenuItem)this.item).getContent().prefWidth(-1.0) + this.snappedRightInset();
            }
            return Math.max(nodeMenuItemWidth, this.snappedLeftInset() + ContextMenuContent.this.maxLeftWidth + ContextMenuContent.this.maxGraphicWidth + ContextMenuContent.this.maxLabelWidth + ContextMenuContent.this.maxRightWidth + this.snappedRightInset());
        }

        private Node getLeftGraphic(MenuItem item) {
            if (item instanceof RadioMenuItem) {
                Region _graphic = new Region();
                _graphic.getStyleClass().add("radio");
                return _graphic;
            }
            if (item instanceof CheckMenuItem) {
                StackPane _graphic = new StackPane();
                _graphic.getStyleClass().add("check");
                return _graphic;
            }
            return null;
        }

        @Override
        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case SELECTED: {
                    if (this.item instanceof CheckMenuItem) {
                        return ((CheckMenuItem)this.item).isSelected();
                    }
                    if (this.item instanceof RadioMenuItem) {
                        return ((RadioMenuItem)this.item).isSelected();
                    }
                    return false;
                }
                case ACCELERATOR: {
                    return this.item.getAccelerator();
                }
                case TEXT: {
                    String t;
                    Node content;
                    String t2;
                    Label label;
                    String t3;
                    String title = "";
                    if (this.graphic != null && (t3 = (String)this.graphic.queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                        title = title + t3;
                    }
                    if ((label = this.getLabel()) != null && (t2 = (String)label.queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                        title = title + t2;
                    }
                    if (this.item instanceof CustomMenuItem && (content = ((CustomMenuItem)this.item).getContent()) != null && (t = (String)content.queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                        title = title + t;
                    }
                    return title;
                }
                case MNEMONIC: {
                    String mnemonic;
                    Label label = this.getLabel();
                    if (label != null && (mnemonic = (String)label.queryAccessibleAttribute(AccessibleAttribute.MNEMONIC, new Object[0])) != null) {
                        return mnemonic;
                    }
                    return null;
                }
                case DISABLED: {
                    return this.item.isDisable();
                }
                case SUBMENU: {
                    ContextMenuContent.this.createSubmenu();
                    if (ContextMenuContent.this.submenu.getSkin() == null) {
                        ContextMenuContent.this.submenu.impl_styleableGetNode().impl_processCSS(true);
                    }
                    ContextMenuContent cmContent = (ContextMenuContent)ContextMenuContent.this.submenu.getSkin().getNode();
                    return cmContent.itemsContainer;
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }

        @Override
        public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
            switch (action) {
                case SHOW_MENU: {
                    if (!(this.item instanceof Menu)) break;
                    Menu menuItem = (Menu)this.item;
                    if (menuItem.isShowing()) {
                        menuItem.hide();
                        break;
                    }
                    menuItem.show();
                    break;
                }
                case FIRE: {
                    this.doSelect();
                    break;
                }
                default: {
                    super.executeAccessibleAction(action, new Object[0]);
                }
            }
        }
    }

    class ArrowMenuItem
    extends StackPane {
        private StackPane upDownArrow;
        private ContextMenuContent popupMenuContent;
        private boolean up = false;
        private Timeline scrollTimeline;

        public final boolean isUp() {
            return this.up;
        }

        public void setUp(boolean value) {
            this.up = value;
            this.upDownArrow.getStyleClass().setAll((String[])new String[]{this.isUp() ? "menu-up-arrow" : "menu-down-arrow"});
        }

        public ArrowMenuItem(ContextMenuContent pmc) {
            this.getStyleClass().setAll((String[])new String[]{"scroll-arrow"});
            this.upDownArrow = new StackPane();
            this.popupMenuContent = pmc;
            this.upDownArrow.setMouseTransparent(true);
            this.upDownArrow.getStyleClass().setAll((String[])new String[]{this.isUp() ? "menu-up-arrow" : "menu-down-arrow"});
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, me -> {
                if (this.scrollTimeline != null && this.scrollTimeline.getStatus() != Animation.Status.STOPPED) {
                    return;
                }
                this.startTimeline();
            });
            this.addEventHandler(MouseEvent.MOUSE_EXITED, me -> this.stopTimeline());
            this.setVisible(false);
            this.setManaged(false);
            this.getChildren().add(this.upDownArrow);
        }

        @Override
        protected double computePrefWidth(double height) {
            return ContextMenuContent.this.itemsContainer.getWidth();
        }

        @Override
        protected double computePrefHeight(double width) {
            return this.snappedTopInset() + this.upDownArrow.prefHeight(-1.0) + this.snappedBottomInset();
        }

        @Override
        protected void layoutChildren() {
            double w = this.snapSize(this.upDownArrow.prefWidth(-1.0));
            double h = this.snapSize(this.upDownArrow.prefHeight(-1.0));
            this.upDownArrow.resize(w, h);
            this.positionInArea(this.upDownArrow, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, HPos.CENTER, VPos.CENTER);
        }

        private void adjust() {
            if (this.up) {
                this.popupMenuContent.scroll(12.0);
            } else {
                this.popupMenuContent.scroll(-12.0);
            }
        }

        private void startTimeline() {
            this.scrollTimeline = new Timeline();
            this.scrollTimeline.setCycleCount(-1);
            KeyFrame kf = new KeyFrame(Duration.millis(60.0), event -> this.adjust(), new KeyValue[0]);
            this.scrollTimeline.getKeyFrames().clear();
            this.scrollTimeline.getKeyFrames().add(kf);
            this.scrollTimeline.play();
        }

        private void stopTimeline() {
            this.scrollTimeline.stop();
            this.scrollTimeline = null;
        }
    }

    class MenuBox
    extends VBox {
        MenuBox() {
            this.setAccessibleRole(AccessibleRole.CONTEXT_MENU);
        }

        @Override
        protected void layoutChildren() {
            double yOffset = ContextMenuContent.this.ty;
            for (Node n : this.getChildren()) {
                if (!n.isVisible()) continue;
                double prefHeight = this.snapSize(n.prefHeight(-1.0));
                n.resize(this.snapSize(this.getWidth()), prefHeight);
                n.relocate(this.snappedLeftInset(), yOffset);
                yOffset += prefHeight;
            }
        }

        @Override
        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case VISIBLE: {
                    return ContextMenuContent.this.contextMenu.isShowing();
                }
                case PARENT_MENU: {
                    return ContextMenuContent.this.contextMenu.getOwnerNode();
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            List<CssMetaData<Styleable, ?>> nodeStyleables = Node.getClassCssMetaData();
            int max = nodeStyleables.size();
            for (int n = 0; n < max; ++n) {
                CssMetaData<Styleable, ?> styleable = nodeStyleables.get(n);
                if (!"effect".equals(styleable.getProperty())) continue;
                styleables.add(styleable);
                break;
            }
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

